/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.spark.xml.util;

import com.databricks.spark.xml.XmlOptions;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Locale;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;
import scala.util.control.Exception$;

public final class TypeCast$ {
    public static final TypeCast$ MODULE$;
    private final List<DateTimeFormatter> supportedXmlDateFormatters;
    private final List<DateTimeFormatter> supportedXmlTimestampFormatters;

    static {
        new TypeCast$();
    }

    public Object castTo(String datum, DataType castType, XmlOptions options, boolean nullable) {
        block16: {
            Byte by;
            block4: {
                Object object;
                block6: {
                    DataType dataType;
                    block15: {
                        block14: {
                            block13: {
                                block12: {
                                    block11: {
                                        block10: {
                                            block9: {
                                                block8: {
                                                    block7: {
                                                        block5: {
                                                            block3: {
                                                                block2: {
                                                                    String string = datum;
                                                                    String string2 = options.nullValue();
                                                                    if (!(string != null ? !string.equals(string2) : string2 != null) && nullable) break block2;
                                                                    if (!options.treatEmptyValuesAsNulls()) break block3;
                                                                    String string3 = datum;
                                                                    String string4 = "";
                                                                    if (string3 != null ? !string3.equals(string4) : string4 != null) break block3;
                                                                }
                                                                by = null;
                                                                break block4;
                                                            }
                                                            if (!((dataType = castType) instanceof ByteType)) break block5;
                                                            object = BoxesRunTime.boxToByte((byte)new StringOps(Predef$.MODULE$.augmentString(datum)).toByte());
                                                            break block6;
                                                        }
                                                        if (!(dataType instanceof ShortType)) break block7;
                                                        object = BoxesRunTime.boxToShort((short)new StringOps(Predef$.MODULE$.augmentString(datum)).toShort());
                                                        break block6;
                                                    }
                                                    if (!(dataType instanceof IntegerType)) break block8;
                                                    object = BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(datum)).toInt());
                                                    break block6;
                                                }
                                                if (!(dataType instanceof LongType)) break block9;
                                                object = BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(datum)).toLong());
                                                break block6;
                                            }
                                            if (!(dataType instanceof FloatType)) break block10;
                                            object = Try$.MODULE$.apply((Function0)new Serializable(datum){
                                                public static final long serialVersionUID = 0L;
                                                private final String datum$1;

                                                public final float apply() {
                                                    return this.apply$mcF$sp();
                                                }

                                                public float apply$mcF$sp() {
                                                    return new StringOps(Predef$.MODULE$.augmentString(this.datum$1)).toFloat();
                                                }
                                                {
                                                    this.datum$1 = datum$1;
                                                }
                                            }).getOrElse((Function0)new Serializable(datum){
                                                public static final long serialVersionUID = 0L;
                                                private final String datum$1;

                                                public final float apply() {
                                                    return this.apply$mcF$sp();
                                                }

                                                public float apply$mcF$sp() {
                                                    return NumberFormat.getInstance(Locale.getDefault()).parse(this.datum$1).floatValue();
                                                }
                                                {
                                                    this.datum$1 = datum$1;
                                                }
                                            });
                                            break block6;
                                        }
                                        if (!(dataType instanceof DoubleType)) break block11;
                                        object = Try$.MODULE$.apply((Function0)new Serializable(datum){
                                            public static final long serialVersionUID = 0L;
                                            private final String datum$1;

                                            public final double apply() {
                                                return this.apply$mcD$sp();
                                            }

                                            public double apply$mcD$sp() {
                                                return new StringOps(Predef$.MODULE$.augmentString(this.datum$1)).toDouble();
                                            }
                                            {
                                                this.datum$1 = datum$1;
                                            }
                                        }).getOrElse((Function0)new Serializable(datum){
                                            public static final long serialVersionUID = 0L;
                                            private final String datum$1;

                                            public final double apply() {
                                                return this.apply$mcD$sp();
                                            }

                                            public double apply$mcD$sp() {
                                                return NumberFormat.getInstance(Locale.getDefault()).parse(this.datum$1).doubleValue();
                                            }
                                            {
                                                this.datum$1 = datum$1;
                                            }
                                        });
                                        break block6;
                                    }
                                    if (!(dataType instanceof BooleanType)) break block12;
                                    object = BoxesRunTime.boxToBoolean((boolean)this.parseXmlBoolean(datum));
                                    break block6;
                                }
                                if (!(dataType instanceof DecimalType)) break block13;
                                object = new BigDecimal(datum.replaceAll(",", ""));
                                break block6;
                            }
                            if (!(dataType instanceof TimestampType)) break block14;
                            object = this.parseXmlTimestamp(this.supportedXmlTimestampFormatters(), datum);
                            break block6;
                        }
                        if (!(dataType instanceof DateType)) break block15;
                        object = this.parseXmlDate(this.supportedXmlDateFormatters(), datum);
                        break block6;
                    }
                    if (!(dataType instanceof StringType)) break block16;
                    object = datum;
                }
                by = object;
            }
            return by;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{castType.typeName()})));
    }

    public boolean castTo$default$4() {
        return true;
    }

    private boolean parseXmlBoolean(String s) {
        block6: {
            boolean bl;
            block3: {
                String string;
                block5: {
                    block4: {
                        block2: {
                            string = s.toLowerCase();
                            if (!"true".equals(string)) break block2;
                            bl = true;
                            break block3;
                        }
                        if (!"false".equals(string)) break block4;
                        bl = false;
                        break block3;
                    }
                    if (!"1".equals(string)) break block5;
                    bl = true;
                    break block3;
                }
                if (!"0".equals(string)) break block6;
                bl = false;
            }
            return bl;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"For input string: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s})));
    }

    public List<DateTimeFormatter> supportedXmlDateFormatters() {
        return this.supportedXmlDateFormatters;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Date parseXmlDate(List<DateTimeFormatter> formatters, String value) {
        while (true) {
            List<DateTimeFormatter> list;
            if (Nil$.MODULE$.equals(list = formatters)) {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cannot convert value ", " to Date"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value})));
            }
            if (!(list instanceof .colon.colon)) {
                throw new MatchError(list);
            }
            .colon.colon colon2 = (.colon.colon)list;
            DateTimeFormatter head = (DateTimeFormatter)colon2.head();
            List tail = colon2.tl$1();
            try {
                return Date.valueOf(LocalDate.parse(value, head));
            }
            catch (Exception exception) {
                void var8_6;
                formatters = var8_6;
                continue;
            }
            break;
        }
    }

    public List<DateTimeFormatter> supportedXmlTimestampFormatters() {
        return this.supportedXmlTimestampFormatters;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Timestamp parseXmlTimestamp(List<DateTimeFormatter> formatters, String value) {
        while (true) {
            List<DateTimeFormatter> list;
            if (Nil$.MODULE$.equals(list = formatters)) {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cannot convert value ", " to Timestamp"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value})));
            }
            if (!(list instanceof .colon.colon)) {
                throw new MatchError(list);
            }
            .colon.colon colon2 = (.colon.colon)list;
            DateTimeFormatter head = (DateTimeFormatter)colon2.head();
            List tail = colon2.tl$1();
            try {
                return Timestamp.from(ZonedDateTime.parse(value, head).toInstant());
            }
            catch (Exception exception) {
                void var8_6;
                formatters = var8_6;
                continue;
            }
            break;
        }
    }

    public Object convertTo(String datum, DataType dataType, XmlOptions options) {
        block14: {
            Object object;
            block3: {
                DataType dataType2;
                String value;
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block8: {
                                        block7: {
                                            block6: {
                                                block5: {
                                                    block4: {
                                                        block2: {
                                                            value = datum != null && options.ignoreSurroundingSpaces() ? datum.trim() : datum;
                                                            dataType2 = dataType;
                                                            if (!NullType$.MODULE$.equals(dataType2)) break block2;
                                                            object = this.castTo(value, (DataType)StringType$.MODULE$, options, this.castTo$default$4());
                                                            break block3;
                                                        }
                                                        if (!LongType$.MODULE$.equals(dataType2)) break block4;
                                                        object = BoxesRunTime.boxToLong((long)this.signSafeToLong(value, options));
                                                        break block3;
                                                    }
                                                    if (!DoubleType$.MODULE$.equals(dataType2)) break block5;
                                                    object = BoxesRunTime.boxToDouble((double)this.signSafeToDouble(value, options));
                                                    break block3;
                                                }
                                                if (!BooleanType$.MODULE$.equals(dataType2)) break block6;
                                                object = this.castTo(value, (DataType)BooleanType$.MODULE$, options, this.castTo$default$4());
                                                break block3;
                                            }
                                            if (!StringType$.MODULE$.equals(dataType2)) break block7;
                                            object = this.castTo(value, (DataType)StringType$.MODULE$, options, this.castTo$default$4());
                                            break block3;
                                        }
                                        if (!DateType$.MODULE$.equals(dataType2)) break block8;
                                        object = this.castTo(value, (DataType)DateType$.MODULE$, options, this.castTo$default$4());
                                        break block3;
                                    }
                                    if (!TimestampType$.MODULE$.equals(dataType2)) break block9;
                                    object = this.castTo(value, (DataType)TimestampType$.MODULE$, options, this.castTo$default$4());
                                    break block3;
                                }
                                if (!FloatType$.MODULE$.equals(dataType2)) break block10;
                                object = BoxesRunTime.boxToFloat((float)this.signSafeToFloat(value, options));
                                break block3;
                            }
                            if (!ByteType$.MODULE$.equals(dataType2)) break block11;
                            object = this.castTo(value, (DataType)ByteType$.MODULE$, options, this.castTo$default$4());
                            break block3;
                        }
                        if (!ShortType$.MODULE$.equals(dataType2)) break block12;
                        object = this.castTo(value, (DataType)ShortType$.MODULE$, options, this.castTo$default$4());
                        break block3;
                    }
                    if (!IntegerType$.MODULE$.equals(dataType2)) break block13;
                    object = BoxesRunTime.boxToInteger((int)this.signSafeToInt(value, options));
                    break block3;
                }
                if (!(dataType2 instanceof DecimalType)) break block14;
                DecimalType decimalType = (DecimalType)dataType2;
                object = this.castTo(value, (DataType)decimalType, options, this.castTo$default$4());
            }
            return object;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to parse a value for data type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataType})));
    }

    public boolean isBoolean(String value) {
        String string = value.toLowerCase();
        boolean bl = "true".equals(string) ? true : "false".equals(string);
        boolean bl2 = bl;
        return bl2;
    }

    public boolean isDouble(String value) {
        String signSafeValue = value.startsWith("+") || value.startsWith("-") ? value.substring(1) : value;
        return Exception$.MODULE$.allCatch().opt((Function0)new Serializable(signSafeValue){
            public static final long serialVersionUID = 0L;
            private final String signSafeValue$1;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return new StringOps(Predef$.MODULE$.augmentString(this.signSafeValue$1)).toDouble();
            }
            {
                this.signSafeValue$1 = signSafeValue$1;
            }
        }).isDefined();
    }

    public boolean isInteger(String value) {
        String signSafeValue = value.startsWith("+") || value.startsWith("-") ? value.substring(1) : value;
        return Exception$.MODULE$.allCatch().opt((Function0)new Serializable(signSafeValue){
            public static final long serialVersionUID = 0L;
            private final String signSafeValue$2;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return new StringOps(Predef$.MODULE$.augmentString(this.signSafeValue$2)).toInt();
            }
            {
                this.signSafeValue$2 = signSafeValue$2;
            }
        }).isDefined();
    }

    public boolean isLong(String value) {
        String signSafeValue = value.startsWith("+") || value.startsWith("-") ? value.substring(1) : value;
        return Exception$.MODULE$.allCatch().opt((Function0)new Serializable(signSafeValue){
            public static final long serialVersionUID = 0L;
            private final String signSafeValue$3;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return new StringOps(Predef$.MODULE$.augmentString(this.signSafeValue$3)).toLong();
            }
            {
                this.signSafeValue$3 = signSafeValue$3;
            }
        }).isDefined();
    }

    public boolean isTimestamp(String value) {
        return Exception$.MODULE$.allCatch().opt((Function0)new Serializable(value){
            public static final long serialVersionUID = 0L;
            private final String value$1;

            public final Timestamp apply() {
                return Timestamp.valueOf(this.value$1);
            }
            {
                this.value$1 = value$1;
            }
        }).isDefined();
    }

    public long signSafeToLong(String value, XmlOptions options) {
        long l;
        if (value.startsWith("+")) {
            String data = value.substring(1);
            l = BoxesRunTime.unboxToLong((Object)this.castTo(data, (DataType)LongType$.MODULE$, options, this.castTo$default$4()));
        } else if (value.startsWith("-")) {
            String data = value.substring(1);
            l = -BoxesRunTime.unboxToLong((Object)this.castTo(data, (DataType)LongType$.MODULE$, options, this.castTo$default$4()));
        } else {
            String data = value;
            l = BoxesRunTime.unboxToLong((Object)this.castTo(data, (DataType)LongType$.MODULE$, options, this.castTo$default$4()));
        }
        return l;
    }

    public double signSafeToDouble(String value, XmlOptions options) {
        double d;
        if (value.startsWith("+")) {
            String data = value.substring(1);
            d = BoxesRunTime.unboxToDouble((Object)this.castTo(data, (DataType)DoubleType$.MODULE$, options, this.castTo$default$4()));
        } else if (value.startsWith("-")) {
            String data = value.substring(1);
            d = -BoxesRunTime.unboxToDouble((Object)this.castTo(data, (DataType)DoubleType$.MODULE$, options, this.castTo$default$4()));
        } else {
            String data = value;
            d = BoxesRunTime.unboxToDouble((Object)this.castTo(data, (DataType)DoubleType$.MODULE$, options, this.castTo$default$4()));
        }
        return d;
    }

    public int signSafeToInt(String value, XmlOptions options) {
        int n;
        if (value.startsWith("+")) {
            String data = value.substring(1);
            n = BoxesRunTime.unboxToInt((Object)this.castTo(data, (DataType)IntegerType$.MODULE$, options, this.castTo$default$4()));
        } else if (value.startsWith("-")) {
            String data = value.substring(1);
            n = -BoxesRunTime.unboxToInt((Object)this.castTo(data, (DataType)IntegerType$.MODULE$, options, this.castTo$default$4()));
        } else {
            String data = value;
            n = BoxesRunTime.unboxToInt((Object)this.castTo(data, (DataType)IntegerType$.MODULE$, options, this.castTo$default$4()));
        }
        return n;
    }

    public float signSafeToFloat(String value, XmlOptions options) {
        float f;
        if (value.startsWith("+")) {
            String data = value.substring(1);
            f = BoxesRunTime.unboxToFloat((Object)this.castTo(data, (DataType)FloatType$.MODULE$, options, this.castTo$default$4()));
        } else if (value.startsWith("-")) {
            String data = value.substring(1);
            f = -BoxesRunTime.unboxToFloat((Object)this.castTo(data, (DataType)FloatType$.MODULE$, options, this.castTo$default$4()));
        } else {
            String data = value;
            f = BoxesRunTime.unboxToFloat((Object)this.castTo(data, (DataType)FloatType$.MODULE$, options, this.castTo$default$4()));
        }
        return f;
    }

    private TypeCast$() {
        MODULE$ = this;
        this.supportedXmlDateFormatters = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DateTimeFormatter[]{DateTimeFormatter.ISO_DATE}));
        this.supportedXmlTimestampFormatters = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DateTimeFormatter[]{new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter().withZone(ZoneId.of("UTC")), DateTimeFormatter.ISO_LOCAL_DATE_TIME.withZone(ZoneId.of("UTC")), DateTimeFormatter.ISO_OFFSET_DATE_TIME, DateTimeFormatter.ISO_INSTANT}));
    }
}

