/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.spark.xml.util;

import com.databricks.spark.xml.XmlOptions$;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import javax.xml.namespace.QName;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAll;
import org.apache.ws.commons.schema.XmlSchemaAllMember;
import org.apache.ws.commons.schema.XmlSchemaAny;
import org.apache.ws.commons.schema.XmlSchemaAttribute;
import org.apache.ws.commons.schema.XmlSchemaAttributeOrGroupRef;
import org.apache.ws.commons.schema.XmlSchemaChoice;
import org.apache.ws.commons.schema.XmlSchemaChoiceMember;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaContent;
import org.apache.ws.commons.schema.XmlSchemaContentModel;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaFacet;
import org.apache.ws.commons.schema.XmlSchemaFractionDigitsFacet;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSequenceMember;
import org.apache.ws.commons.schema.XmlSchemaSimpleContent;
import org.apache.ws.commons.schema.XmlSchemaSimpleContentExtension;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeContent;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeRestriction;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.commons.schema.XmlSchemaUse;
import org.apache.ws.commons.schema.constants.Constants;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.MapLike;

@Experimental
public final class XSDToSchema$ {
    public static XSDToSchema$ MODULE$;

    static {
        new XSDToSchema$();
    }

    @Experimental
    public StructType read(File xsdFile) {
        XmlSchemaCollection xmlSchemaCollection = new XmlSchemaCollection();
        xmlSchemaCollection.setBaseUri(xsdFile.getParent());
        XmlSchema xmlSchema = xmlSchemaCollection.read((Reader)new InputStreamReader((InputStream)new FileInputStream(xsdFile), StandardCharsets.UTF_8));
        return this.getStructType(xmlSchema);
    }

    @Experimental
    public StructType read(Path xsdFile) {
        return this.read(xsdFile.toFile());
    }

    @Experimental
    public StructType read(String xsdString) {
        XmlSchema xmlSchema = new XmlSchemaCollection().read((Reader)new StringReader(xsdString));
        return this.getStructType(xmlSchema);
    }

    private StructField getStructField(XmlSchema xmlSchema, XmlSchemaType schemaType) {
        StructField structField;
        XmlSchemaType xmlSchemaType = schemaType;
        if (xmlSchemaType instanceof XmlSchemaSimpleType) {
            StringType$ stringType$;
            XmlSchemaSimpleType xmlSchemaSimpleType = (XmlSchemaSimpleType)xmlSchemaType;
            XmlSchemaSimpleTypeContent xmlSchemaSimpleTypeContent = xmlSchemaSimpleType.getContent();
            if (xmlSchemaSimpleTypeContent instanceof XmlSchemaSimpleTypeRestriction) {
                Object object;
                QName matchType;
                XmlSchemaSimpleTypeRestriction xmlSchemaSimpleTypeRestriction = (XmlSchemaSimpleTypeRestriction)xmlSchemaSimpleTypeContent;
                QName qName = xmlSchemaSimpleTypeRestriction.getBaseTypeName();
                QName qName2 = Constants.XSD_ANYSIMPLETYPE;
                QName qName3 = matchType = !(qName != null ? !((Object)qName).equals(qName2) : qName2 != null) ? xmlSchemaSimpleType.getQName() : xmlSchemaSimpleTypeRestriction.getBaseTypeName();
                QName qName4 = Constants.XSD_BOOLEAN;
                QName qName5 = qName3;
                if (!(qName4 != null ? !((Object)qName4).equals(qName5) : qName5 != null)) {
                    object = BooleanType$.MODULE$;
                } else {
                    QName qName6 = Constants.XSD_DECIMAL;
                    QName qName7 = qName3;
                    if (!(qName6 != null ? !((Object)qName6).equals(qName7) : qName7 != null)) {
                        DecimalType decimalType;
                        Option scale = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(xmlSchemaSimpleTypeRestriction.getFacets()).asScala()).collectFirst((PartialFunction)new scala.Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final <A1 extends XmlSchemaFacet, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                XmlSchemaFractionDigitsFacet xmlSchemaFractionDigitsFacet;
                                A1 A1 = x1;
                                Object object = A1 instanceof XmlSchemaFractionDigitsFacet ? (xmlSchemaFractionDigitsFacet = (XmlSchemaFractionDigitsFacet)A1) : function1.apply(x1);
                                return (B1)object;
                            }

                            public final boolean isDefinedAt(XmlSchemaFacet x1) {
                                XmlSchemaFacet xmlSchemaFacet = x1;
                                boolean bl = xmlSchemaFacet instanceof XmlSchemaFractionDigitsFacet;
                                return bl;
                            }
                        });
                        Option option = scale;
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            XmlSchemaFractionDigitsFacet scale2 = (XmlSchemaFractionDigitsFacet)some.value();
                            decimalType = new DecimalType(38, new StringOps(Predef$.MODULE$.augmentString(scale2.getValue().toString())).toInt());
                        } else if (None$.MODULE$.equals(option)) {
                            decimalType = new DecimalType(38, 18);
                        } else {
                            throw new MatchError((Object)option);
                        }
                        object = decimalType;
                    } else {
                        QName qName8 = Constants.XSD_UNSIGNEDLONG;
                        QName qName9 = qName3;
                        if (!(qName8 != null ? !((Object)qName8).equals(qName9) : qName9 != null)) {
                            object = new DecimalType(38, 0);
                        } else {
                            QName qName10 = Constants.XSD_DOUBLE;
                            QName qName11 = qName3;
                            if (!(qName10 != null ? !((Object)qName10).equals(qName11) : qName11 != null)) {
                                object = DoubleType$.MODULE$;
                            } else {
                                QName qName12 = Constants.XSD_FLOAT;
                                QName qName13 = qName3;
                                if (!(qName12 != null ? !((Object)qName12).equals(qName13) : qName13 != null)) {
                                    object = FloatType$.MODULE$;
                                } else {
                                    QName qName14 = Constants.XSD_BYTE;
                                    QName qName15 = qName3;
                                    if (!(qName14 != null ? !((Object)qName14).equals(qName15) : qName15 != null)) {
                                        object = ByteType$.MODULE$;
                                    } else {
                                        boolean bl;
                                        QName qName16 = Constants.XSD_SHORT;
                                        QName qName17 = qName3;
                                        if (!(qName16 != null ? !((Object)qName16).equals(qName17) : qName17 != null)) {
                                            bl = true;
                                        } else {
                                            QName qName18 = Constants.XSD_UNSIGNEDBYTE;
                                            QName qName19 = qName3;
                                            bl = !(qName18 != null ? !((Object)qName18).equals(qName19) : qName19 != null);
                                        }
                                        if (bl) {
                                            object = ShortType$.MODULE$;
                                        } else {
                                            boolean bl2;
                                            QName qName20 = Constants.XSD_INTEGER;
                                            QName qName21 = qName3;
                                            if (!(qName20 != null ? !((Object)qName20).equals(qName21) : qName21 != null)) {
                                                bl2 = true;
                                            } else {
                                                QName qName22 = Constants.XSD_NEGATIVEINTEGER;
                                                QName qName23 = qName3;
                                                if (!(qName22 != null ? !((Object)qName22).equals(qName23) : qName23 != null)) {
                                                    bl2 = true;
                                                } else {
                                                    QName qName24 = Constants.XSD_NONNEGATIVEINTEGER;
                                                    QName qName25 = qName3;
                                                    if (!(qName24 != null ? !((Object)qName24).equals(qName25) : qName25 != null)) {
                                                        bl2 = true;
                                                    } else {
                                                        QName qName26 = Constants.XSD_NONPOSITIVEINTEGER;
                                                        QName qName27 = qName3;
                                                        if (!(qName26 != null ? !((Object)qName26).equals(qName27) : qName27 != null)) {
                                                            bl2 = true;
                                                        } else {
                                                            QName qName28 = Constants.XSD_POSITIVEINTEGER;
                                                            QName qName29 = qName3;
                                                            if (!(qName28 != null ? !((Object)qName28).equals(qName29) : qName29 != null)) {
                                                                bl2 = true;
                                                            } else {
                                                                QName qName30 = Constants.XSD_UNSIGNEDSHORT;
                                                                QName qName31 = qName3;
                                                                bl2 = !(qName30 != null ? !((Object)qName30).equals(qName31) : qName31 != null);
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                            if (bl2) {
                                                object = IntegerType$.MODULE$;
                                            } else {
                                                boolean bl3;
                                                QName qName32 = Constants.XSD_LONG;
                                                QName qName33 = qName3;
                                                if (!(qName32 != null ? !((Object)qName32).equals(qName33) : qName33 != null)) {
                                                    bl3 = true;
                                                } else {
                                                    QName qName34 = Constants.XSD_UNSIGNEDINT;
                                                    QName qName35 = qName3;
                                                    bl3 = !(qName34 != null ? !((Object)qName34).equals(qName35) : qName35 != null);
                                                }
                                                if (bl3) {
                                                    object = LongType$.MODULE$;
                                                } else {
                                                    QName qName36 = Constants.XSD_DATE;
                                                    QName qName37 = qName3;
                                                    if (!(qName36 != null ? !((Object)qName36).equals(qName37) : qName37 != null)) {
                                                        object = DateType$.MODULE$;
                                                    } else {
                                                        QName qName38 = Constants.XSD_DATETIME;
                                                        QName qName39 = qName3;
                                                        object = !(qName38 != null ? !((Object)qName38).equals(qName39) : qName39 != null) ? TimestampType$.MODULE$ : StringType$.MODULE$;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                stringType$ = object;
            } else {
                stringType$ = StringType$.MODULE$;
            }
            StringType$ schemaType2 = stringType$;
            structField = new StructField("baseName", (DataType)schemaType2, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        } else if (xmlSchemaType instanceof XmlSchemaComplexType) {
            StructField structField2;
            XmlSchemaComplexType xmlSchemaComplexType = (XmlSchemaComplexType)xmlSchemaType;
            XmlSchemaContentModel xmlSchemaContentModel = xmlSchemaComplexType.getContentModel();
            if (xmlSchemaContentModel instanceof XmlSchemaSimpleContent) {
                XmlSchemaSimpleContent xmlSchemaSimpleContent = (XmlSchemaSimpleContent)xmlSchemaContentModel;
                XmlSchemaContent xmlSchemaContent = xmlSchemaSimpleContent.getContent();
                if (!(xmlSchemaContent instanceof XmlSchemaSimpleContentExtension)) {
                    throw new MatchError((Object)xmlSchemaContent);
                }
                XmlSchemaSimpleContentExtension xmlSchemaSimpleContentExtension = (XmlSchemaSimpleContentExtension)xmlSchemaContent;
                StructField baseStructField = this.getStructField(xmlSchema, xmlSchema.getParent().getTypeByQName(xmlSchemaSimpleContentExtension.getBaseTypeName()));
                StructField value = new StructField("_VALUE", baseStructField.dataType(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                Buffer attributes = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(xmlSchemaSimpleContentExtension.getAttributes()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    XmlSchemaAttributeOrGroupRef xmlSchemaAttributeOrGroupRef = x0$1;
                    if (!(xmlSchemaAttributeOrGroupRef instanceof XmlSchemaAttribute)) {
                        throw new MatchError((Object)xmlSchemaAttributeOrGroupRef);
                    }
                    XmlSchemaAttribute xmlSchemaAttribute = (XmlSchemaAttribute)xmlSchemaAttributeOrGroupRef;
                    StructField baseStructField = MODULE$.getStructField(xmlSchema, xmlSchema.getParent().getTypeByQName(xmlSchemaAttribute.getSchemaTypeName()));
                    XmlSchemaUse xmlSchemaUse = xmlSchemaAttribute.getUse();
                    XmlSchemaUse xmlSchemaUse2 = XmlSchemaUse.REQUIRED;
                    StructField structField = new StructField(new StringBuilder(1).append("_").append(xmlSchemaAttribute.getName()).toString(), baseStructField.dataType(), xmlSchemaUse == null ? xmlSchemaUse2 != null : !xmlSchemaUse.equals(xmlSchemaUse2), StructField$.MODULE$.apply$default$4());
                    return structField;
                }, Buffer$.MODULE$.canBuildFrom());
                StructField structField3 = value;
                StructField structField4 = new StructField(xmlSchemaComplexType.getName(), (DataType)StructType$.MODULE$.apply((Seq)attributes.$plus$colon((Object)structField3, Buffer$.MODULE$.canBuildFrom())), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                structField2 = structField4;
            } else if (xmlSchemaContentModel == null) {
                Buffer buffer;
                XmlSchemaParticle xmlSchemaParticle = xmlSchemaComplexType.getParticle();
                if (xmlSchemaParticle instanceof XmlSchemaAll) {
                    XmlSchemaAll xmlSchemaAll = (XmlSchemaAll)xmlSchemaParticle;
                    buffer = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(xmlSchemaAll.getItems()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        XmlSchemaAllMember xmlSchemaAllMember = x0$2;
                        if (!(xmlSchemaAllMember instanceof XmlSchemaElement)) {
                            throw new MatchError((Object)xmlSchemaAllMember);
                        }
                        XmlSchemaElement xmlSchemaElement = (XmlSchemaElement)xmlSchemaAllMember;
                        StructField baseStructField = MODULE$.getStructField(xmlSchema, xmlSchemaElement.getSchemaType());
                        boolean nullable = xmlSchemaElement.getMinOccurs() == 0L;
                        StructField structField = xmlSchemaElement.getMaxOccurs() == 1L ? new StructField(xmlSchemaElement.getName(), baseStructField.dataType(), nullable, StructField$.MODULE$.apply$default$4()) : new StructField(xmlSchemaElement.getName(), (DataType)ArrayType$.MODULE$.apply(baseStructField.dataType()), nullable, StructField$.MODULE$.apply$default$4());
                        return structField;
                    }, Buffer$.MODULE$.canBuildFrom());
                } else if (xmlSchemaParticle instanceof XmlSchemaChoice) {
                    XmlSchemaChoice xmlSchemaChoice = (XmlSchemaChoice)xmlSchemaParticle;
                    buffer = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(xmlSchemaChoice.getItems()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                        StructField structField;
                        XmlSchemaChoiceMember xmlSchemaChoiceMember = x0$3;
                        if (xmlSchemaChoiceMember instanceof XmlSchemaElement) {
                            XmlSchemaElement xmlSchemaElement = (XmlSchemaElement)xmlSchemaChoiceMember;
                            StructField baseStructField = MODULE$.getStructField(xmlSchema, xmlSchemaElement.getSchemaType());
                            structField = xmlSchemaElement.getMaxOccurs() == 1L ? new StructField(xmlSchemaElement.getName(), baseStructField.dataType(), true, StructField$.MODULE$.apply$default$4()) : new StructField(xmlSchemaElement.getName(), (DataType)ArrayType$.MODULE$.apply(baseStructField.dataType()), true, StructField$.MODULE$.apply$default$4());
                        } else if (xmlSchemaChoiceMember instanceof XmlSchemaAny) {
                            XmlSchemaAny xmlSchemaAny = (XmlSchemaAny)xmlSchemaChoiceMember;
                            StringType$ dataType = xmlSchemaAny.getMaxOccurs() > 1L ? ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$) : StringType$.MODULE$;
                            structField = new StructField(XmlOptions$.MODULE$.DEFAULT_WILDCARD_COL_NAME(), (DataType)dataType, true, StructField$.MODULE$.apply$default$4());
                        } else {
                            throw new MatchError((Object)xmlSchemaChoiceMember);
                        }
                        return structField;
                    }, Buffer$.MODULE$.canBuildFrom());
                } else if (xmlSchemaParticle instanceof XmlSchemaSequence) {
                    XmlSchemaSequence xmlSchemaSequence = (XmlSchemaSequence)xmlSchemaParticle;
                    buffer = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(xmlSchemaSequence.getItems()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> {
                        Seq seq;
                        XmlSchemaSequenceMember xmlSchemaSequenceMember = x$2;
                        if (xmlSchemaSequenceMember instanceof XmlSchemaChoice) {
                            XmlSchemaChoice xmlSchemaChoice = (XmlSchemaChoice)xmlSchemaSequenceMember;
                            seq = (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(xmlSchemaChoice.getItems()).asScala()).map((Function1 & Serializable & scala.Serializable)e -> {
                                XmlSchemaElement xme = (XmlSchemaElement)e;
                                DataType baseType = MODULE$.getStructField(xmlSchema, xme.getSchemaType()).dataType();
                                DataType dataType = xme.getMaxOccurs() > 1L ? ArrayType$.MODULE$.apply(baseType) : baseType;
                                return new StructField(xme.getName(), dataType, true, StructField$.MODULE$.apply$default$4());
                            }, Buffer$.MODULE$.canBuildFrom());
                        } else if (xmlSchemaSequenceMember instanceof XmlSchemaElement) {
                            XmlSchemaElement xmlSchemaElement = (XmlSchemaElement)xmlSchemaSequenceMember;
                            DataType baseType = MODULE$.getStructField(xmlSchema, xmlSchemaElement.getSchemaType()).dataType();
                            DataType dataType = xmlSchemaElement.getMaxOccurs() > 1L ? ArrayType$.MODULE$.apply(baseType) : baseType;
                            boolean nullable = xmlSchemaElement.getMinOccurs() == 0L;
                            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField(xmlSchemaElement.getName(), dataType, nullable, StructField$.MODULE$.apply$default$4())}));
                        } else if (xmlSchemaSequenceMember instanceof XmlSchemaAny) {
                            XmlSchemaAny xmlSchemaAny = (XmlSchemaAny)xmlSchemaSequenceMember;
                            StringType$ dataType = xmlSchemaAny.getMaxOccurs() > 1L ? ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$) : StringType$.MODULE$;
                            boolean nullable = xmlSchemaAny.getMinOccurs() == 0L;
                            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField(XmlOptions$.MODULE$.DEFAULT_WILDCARD_COL_NAME(), (DataType)dataType, nullable, StructField$.MODULE$.apply$default$4())}));
                        } else {
                            throw new MatchError((Object)xmlSchemaSequenceMember);
                        }
                        return seq;
                    }, Buffer$.MODULE$.canBuildFrom());
                } else {
                    throw new MatchError((Object)xmlSchemaParticle);
                }
                Buffer childFields = buffer;
                Buffer attributes = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(xmlSchemaComplexType.getAttributes()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                    XmlSchemaAttributeOrGroupRef xmlSchemaAttributeOrGroupRef = x0$4;
                    if (!(xmlSchemaAttributeOrGroupRef instanceof XmlSchemaAttribute)) {
                        throw new MatchError((Object)xmlSchemaAttributeOrGroupRef);
                    }
                    XmlSchemaAttribute xmlSchemaAttribute = (XmlSchemaAttribute)xmlSchemaAttributeOrGroupRef;
                    StructField baseStructField = MODULE$.getStructField(xmlSchema, xmlSchema.getParent().getTypeByQName(xmlSchemaAttribute.getSchemaTypeName()));
                    XmlSchemaUse xmlSchemaUse = xmlSchemaAttribute.getUse();
                    XmlSchemaUse xmlSchemaUse2 = XmlSchemaUse.REQUIRED;
                    StructField structField = new StructField(new StringBuilder(1).append("_").append(xmlSchemaAttribute.getName()).toString(), baseStructField.dataType(), xmlSchemaUse == null ? xmlSchemaUse2 != null : !xmlSchemaUse.equals(xmlSchemaUse2), StructField$.MODULE$.apply$default$4());
                    return structField;
                }, Buffer$.MODULE$.canBuildFrom());
                structField2 = new StructField(xmlSchemaComplexType.getName(), (DataType)StructType$.MODULE$.apply((Seq)childFields.$plus$plus((GenTraversableOnce)attributes)), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            } else {
                throw new MatchError((Object)xmlSchemaContentModel);
            }
            structField = structField2;
        } else {
            throw new IllegalArgumentException(new StringBuilder(33).append("Unsupported schema element type: ").append(xmlSchemaType).toString());
        }
        return structField;
    }

    private StructType getStructType(XmlSchema xmlSchema) {
        return StructType$.MODULE$.apply((Seq)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(xmlSchema.getElements()).asScala()).toSeq().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            XmlSchemaElement schemaElement = (XmlSchemaElement)tuple2._2();
            XmlSchemaType schemaType = schemaElement.getSchemaType();
            StructField rootType = MODULE$.getStructField(xmlSchema, schemaType);
            StructField structField = new StructField(schemaElement.getName(), rootType.dataType(), schemaElement.getMinOccurs() == 0L, StructField$.MODULE$.apply$default$4());
            return structField;
        }, Seq$.MODULE$.canBuildFrom()));
    }

    private XSDToSchema$() {
        MODULE$ = this;
    }
}

