/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.spark.xml.util;

import com.databricks.spark.xml.XmlOptions;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Locale;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import scala.util.control.Exception$;

public final class TypeCast$ {
    public static TypeCast$ MODULE$;
    private final Seq<DateTimeFormatter> supportedXmlDateFormatters;
    private final Seq<DateTimeFormatter> supportedXmlTimestampFormatters;

    static {
        new TypeCast$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object castTo(String datum, DataType castType, XmlOptions options) {
        Object object;
        DataType dataType;
        String string = datum;
        String string2 = options.nullValue();
        if (string == null) {
            if (string2 == null) return null;
        } else if (string.equals(string2)) return null;
        if (options.treatEmptyValuesAsNulls()) {
            String string3 = datum;
            String string4 = "";
            if (string3 == null) {
                if (string4 == null) return null;
            } else if (string3.equals(string4)) {
                return null;
            }
        }
        if ((dataType = castType) instanceof ByteType) {
            object = BoxesRunTime.boxToByte((byte)new StringOps(Predef$.MODULE$.augmentString(datum)).toByte());
        } else if (dataType instanceof ShortType) {
            object = BoxesRunTime.boxToShort((short)new StringOps(Predef$.MODULE$.augmentString(datum)).toShort());
        } else if (dataType instanceof IntegerType) {
            object = BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(datum)).toInt());
        } else if (dataType instanceof LongType) {
            object = BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(datum)).toLong());
        } else if (dataType instanceof FloatType) {
            object = Try$.MODULE$.apply((Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(datum)).toFloat()).getOrElse((Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> NumberFormat.getInstance(Locale.getDefault()).parse(datum).floatValue());
        } else if (dataType instanceof DoubleType) {
            object = Try$.MODULE$.apply((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(datum)).toDouble()).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> NumberFormat.getInstance(Locale.getDefault()).parse(datum).doubleValue());
        } else if (dataType instanceof BooleanType) {
            object = BoxesRunTime.boxToBoolean((boolean)this.parseXmlBoolean(datum));
        } else if (dataType instanceof DecimalType) {
            object = new BigDecimal(datum.replaceAll(",", ""));
        } else if (dataType instanceof TimestampType) {
            object = this.parseXmlTimestamp(datum, options);
        } else if (dataType instanceof DateType) {
            object = this.parseXmlDate(datum, options);
        } else {
            if (!(dataType instanceof StringType)) throw new IllegalArgumentException(new StringBuilder(18).append("Unsupported type: ").append(castType.typeName()).toString());
            object = datum;
        }
        Byte by = object;
        return by;
    }

    private boolean parseXmlBoolean(String s) {
        boolean bl;
        String string = s.toLowerCase(Locale.ROOT);
        boolean bl2 = "true".equals(string) ? true : "1".equals(string);
        if (bl2) {
            bl = true;
        } else {
            boolean bl3 = "false".equals(string) ? true : "0".equals(string);
            if (bl3) {
                bl = false;
            } else {
                throw new IllegalArgumentException(new StringBuilder(18).append("For input string: ").append(s).toString());
            }
        }
        return bl;
    }

    private Seq<DateTimeFormatter> supportedXmlDateFormatters() {
        return this.supportedXmlDateFormatters;
    }

    private Date parseXmlDate(String value, XmlOptions options) {
        Object object = new Object();
        try {
            Seq formatters = (Seq)options.dateFormat().map((Function1 & Serializable & scala.Serializable)x$1 -> DateTimeFormatter.ofPattern(x$1)).map((Function1 & Serializable & scala.Serializable)x$1 -> (Seq)MODULE$.supportedXmlDateFormatters().$colon$plus(x$1, Seq$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.supportedXmlDateFormatters());
            formatters.foreach((Function1 & Serializable & scala.Serializable)format -> {
                TypeCast$.$anonfun$parseXmlDate$4(object, value, format);
                return BoxedUnit.UNIT;
            });
            throw new IllegalArgumentException(new StringBuilder(29).append("cannot convert value ").append(value).append(" to Date").toString());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return (Date)ex.value();
        }
    }

    private Seq<DateTimeFormatter> supportedXmlTimestampFormatters() {
        return this.supportedXmlTimestampFormatters;
    }

    private Timestamp parseXmlTimestamp(String value, XmlOptions options) {
        Object object = new Object();
        try {
            Seq formatters = (Seq)options.timestampFormat().map((Function1 & Serializable & scala.Serializable)x$1 -> DateTimeFormatter.ofPattern(x$1)).map((Function1 & Serializable & scala.Serializable)x$2 -> (Seq)MODULE$.supportedXmlTimestampFormatters().$colon$plus(x$2, Seq$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.supportedXmlTimestampFormatters());
            formatters.foreach((Function1 & Serializable & scala.Serializable)format -> {
                TypeCast$.$anonfun$parseXmlTimestamp$4(object, value, format);
                return BoxedUnit.UNIT;
            });
            throw new IllegalArgumentException(new StringBuilder(34).append("cannot convert value ").append(value).append(" to Timestamp").toString());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return (Timestamp)ex.value();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object convertTo(String datum, DataType dataType, XmlOptions options) {
        Object object;
        DataType dataType2;
        String value;
        String string = value = datum != null && options.ignoreSurroundingSpaces() ? datum.trim() : datum;
        String string2 = options.nullValue();
        if (string == null) {
            if (string2 == null) return null;
        } else if (string.equals(string2)) return null;
        if (options.treatEmptyValuesAsNulls()) {
            String string3 = value;
            String string4 = "";
            if (string3 == null) {
                if (string4 == null) return null;
            } else if (string3.equals(string4)) {
                return null;
            }
        }
        if (NullType$.MODULE$.equals(dataType2 = dataType)) {
            object = this.castTo(value, (DataType)StringType$.MODULE$, options);
        } else if (LongType$.MODULE$.equals(dataType2)) {
            object = BoxesRunTime.boxToLong((long)this.signSafeToLong(value, options));
        } else if (DoubleType$.MODULE$.equals(dataType2)) {
            object = BoxesRunTime.boxToDouble((double)this.signSafeToDouble(value, options));
        } else if (BooleanType$.MODULE$.equals(dataType2)) {
            object = this.castTo(value, (DataType)BooleanType$.MODULE$, options);
        } else if (StringType$.MODULE$.equals(dataType2)) {
            object = this.castTo(value, (DataType)StringType$.MODULE$, options);
        } else if (DateType$.MODULE$.equals(dataType2)) {
            object = this.castTo(value, (DataType)DateType$.MODULE$, options);
        } else if (TimestampType$.MODULE$.equals(dataType2)) {
            object = this.castTo(value, (DataType)TimestampType$.MODULE$, options);
        } else if (FloatType$.MODULE$.equals(dataType2)) {
            object = BoxesRunTime.boxToFloat((float)this.signSafeToFloat(value, options));
        } else if (ByteType$.MODULE$.equals(dataType2)) {
            object = this.castTo(value, (DataType)ByteType$.MODULE$, options);
        } else if (ShortType$.MODULE$.equals(dataType2)) {
            object = this.castTo(value, (DataType)ShortType$.MODULE$, options);
        } else if (IntegerType$.MODULE$.equals(dataType2)) {
            object = BoxesRunTime.boxToInteger((int)this.signSafeToInt(value, options));
        } else {
            if (!(dataType2 instanceof DecimalType)) throw new IllegalArgumentException(new StringBuilder(39).append("Failed to parse a value for data type ").append(dataType).append(".").toString());
            DecimalType decimalType = (DecimalType)dataType2;
            object = this.castTo(value, (DataType)decimalType, options);
        }
        Object object2 = object;
        return object2;
    }

    public boolean isBoolean(String value) {
        String string = value.toLowerCase(Locale.ROOT);
        boolean bl = "true".equals(string) ? true : "false".equals(string);
        boolean bl2 = bl;
        return bl2;
    }

    public boolean isDouble(String value) {
        String signSafeValue = value.startsWith("+") || value.startsWith("-") ? value.substring(1) : value;
        return Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(signSafeValue)).toDouble()).isDefined();
    }

    public boolean isInteger(String value) {
        String signSafeValue = value.startsWith("+") || value.startsWith("-") ? value.substring(1) : value;
        return Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(signSafeValue)).toInt()).isDefined();
    }

    public boolean isLong(String value) {
        String signSafeValue = value.startsWith("+") || value.startsWith("-") ? value.substring(1) : value;
        return Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(signSafeValue)).toLong()).isDefined();
    }

    public boolean isTimestamp(String value, XmlOptions options) {
        boolean bl;
        try {
            this.parseXmlTimestamp(value, options);
            bl = true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = false;
        }
        return bl;
    }

    public boolean isDate(String value, XmlOptions options) {
        boolean bl;
        try {
            this.parseXmlDate(value, options);
            bl = true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = false;
        }
        return bl;
    }

    public long signSafeToLong(String value, XmlOptions options) {
        long l;
        if (value.startsWith("+")) {
            String data = value.substring(1);
            l = BoxesRunTime.unboxToLong((Object)this.castTo(data, (DataType)LongType$.MODULE$, options));
        } else if (value.startsWith("-")) {
            String data = value.substring(1);
            l = -BoxesRunTime.unboxToLong((Object)this.castTo(data, (DataType)LongType$.MODULE$, options));
        } else {
            String data = value;
            l = BoxesRunTime.unboxToLong((Object)this.castTo(data, (DataType)LongType$.MODULE$, options));
        }
        return l;
    }

    public double signSafeToDouble(String value, XmlOptions options) {
        double d;
        if (value.startsWith("+")) {
            String data = value.substring(1);
            d = BoxesRunTime.unboxToDouble((Object)this.castTo(data, (DataType)DoubleType$.MODULE$, options));
        } else if (value.startsWith("-")) {
            String data = value.substring(1);
            d = -BoxesRunTime.unboxToDouble((Object)this.castTo(data, (DataType)DoubleType$.MODULE$, options));
        } else {
            String data = value;
            d = BoxesRunTime.unboxToDouble((Object)this.castTo(data, (DataType)DoubleType$.MODULE$, options));
        }
        return d;
    }

    public int signSafeToInt(String value, XmlOptions options) {
        int n;
        if (value.startsWith("+")) {
            String data = value.substring(1);
            n = BoxesRunTime.unboxToInt((Object)this.castTo(data, (DataType)IntegerType$.MODULE$, options));
        } else if (value.startsWith("-")) {
            String data = value.substring(1);
            n = -BoxesRunTime.unboxToInt((Object)this.castTo(data, (DataType)IntegerType$.MODULE$, options));
        } else {
            String data = value;
            n = BoxesRunTime.unboxToInt((Object)this.castTo(data, (DataType)IntegerType$.MODULE$, options));
        }
        return n;
    }

    public float signSafeToFloat(String value, XmlOptions options) {
        float f;
        if (value.startsWith("+")) {
            String data = value.substring(1);
            f = BoxesRunTime.unboxToFloat((Object)this.castTo(data, (DataType)FloatType$.MODULE$, options));
        } else if (value.startsWith("-")) {
            String data = value.substring(1);
            f = -BoxesRunTime.unboxToFloat((Object)this.castTo(data, (DataType)FloatType$.MODULE$, options));
        } else {
            String data = value;
            f = BoxesRunTime.unboxToFloat((Object)this.castTo(data, (DataType)FloatType$.MODULE$, options));
        }
        return f;
    }

    public static final /* synthetic */ void $anonfun$parseXmlDate$4(Object nonLocalReturnKey1$1, String value$1, DateTimeFormatter format) {
        try {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)Date.valueOf(LocalDate.parse(value$1, format)));
        }
        catch (Exception exception) {
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$parseXmlTimestamp$4(Object nonLocalReturnKey2$1, String value$2, DateTimeFormatter format) {
        try {
            throw new NonLocalReturnControl(nonLocalReturnKey2$1, (Object)Timestamp.from(ZonedDateTime.parse(value$2, format).toInstant()));
        }
        catch (Exception exception) {
            return;
        }
    }

    private TypeCast$() {
        MODULE$ = this;
        this.supportedXmlDateFormatters = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DateTimeFormatter[]{DateTimeFormatter.ISO_DATE}));
        this.supportedXmlTimestampFormatters = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DateTimeFormatter[]{new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter().withZone(ZoneId.of("UTC")), DateTimeFormatter.ISO_LOCAL_DATE_TIME.withZone(ZoneId.of("UTC")), DateTimeFormatter.ISO_OFFSET_DATE_TIME, DateTimeFormatter.ISO_INSTANT}));
    }
}

