/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.spark.xml.parsers;

import com.databricks.spark.xml.XmlOptions;
import java.io.Serializable;
import java.io.StringReader;
import javax.xml.namespace.QName;
import javax.xml.stream.EventFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndDocument;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class StaxXmlParserUtils$ {
    public static StaxXmlParserUtils$ MODULE$;
    private final XMLInputFactory factory;

    static {
        new StaxXmlParserUtils$();
    }

    public XMLInputFactory factory() {
        return this.factory;
    }

    public XMLEventReader filteredReader(String xml) {
        EventFilter filter = new EventFilter(){

            public boolean accept(XMLEvent event) {
                boolean bl;
                int n = event.getEventType();
                switch (n) {
                    case 3: 
                    case 5: {
                        bl = false;
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
                return bl;
            }
        };
        XMLEventReader eventReader = this.factory().createXMLEventReader(new StringReader(xml));
        return this.factory().createFilteredReader(eventReader, filter);
    }

    public Attribute[] gatherRootAttributes(XMLEventReader parser) {
        XMLEvent rootEvent = this.skipUntil(parser, 1);
        return (Attribute[])((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(rootEvent.asStartElement().getAttributes()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1).toArray(ClassTag$.MODULE$.apply(Attribute.class));
    }

    /*
     * WARNING - void declaration
     */
    public XMLEvent skipUntil(XMLEventReader parser, int eventType) {
        void var3_3;
        XMLEvent event = parser.peek();
        while (parser.hasNext() && event.getEventType() != eventType) {
            event = parser.nextEvent();
        }
        return var3_3;
    }

    public boolean checkEndElement(XMLEventReader parser) {
        boolean bl;
        while (true) {
            XMLEvent xMLEvent;
            boolean bl2;
            if (bl2 = (xMLEvent = parser.peek()) instanceof EndElement ? true : xMLEvent instanceof EndDocument) {
                bl = true;
                break;
            }
            if (xMLEvent instanceof StartElement) {
                bl = false;
                break;
            }
            parser.nextEvent();
        }
        return bl;
    }

    public Map<String, String> convertAttributesToValuesMap(Attribute[] attributes, XmlOptions options) {
        return options.excludeAttributeFlag() ? Predef$.MODULE$.Map().empty() : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])attributes)).map((Function1 & Serializable & scala.Serializable)attr -> {
            String key = new StringBuilder(0).append(options.attributePrefix()).append(MODULE$.getName(attr.getName(), options)).toString();
            String string = attr.getValue();
            String string2 = options.treatEmptyValuesAsNulls() && string.trim().isEmpty() ? null : string;
            String value = string2;
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
    }

    /*
     * WARNING - void declaration
     */
    public String getName(QName name, XmlOptions options) {
        void var3_3;
        String localPart = name.getLocalPart();
        return options.ignoreNamespace() ? (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])localPart.split(":"))).last() : var3_3;
    }

    public String currentStructureAsString(XMLEventReader parser) {
        boolean bl;
        scala.collection.mutable.StringBuilder xmlString = new scala.collection.mutable.StringBuilder();
        int indent = 0;
        do {
            BoxedUnit boxedUnit;
            XMLEvent xMLEvent;
            if ((xMLEvent = parser.nextEvent()) instanceof StartElement) {
                StartElement startElement = (StartElement)xMLEvent;
                xmlString.append('<').append((Object)startElement.getName());
                ((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(startElement.getAttributes()).asScala()).foreach((Function1 & Serializable & scala.Serializable)a -> {
                    Attribute att = a;
                    return xmlString.append(' ').append((Object)att.getName()).append("=\"").append(att.getValue()).append('\"');
                });
                xmlString.append('>');
                ++indent;
                boxedUnit = BoxedUnit.UNIT;
            } else if (xMLEvent instanceof EndElement) {
                EndElement endElement = (EndElement)xMLEvent;
                xmlString.append("</").append((Object)endElement.getName()).append('>');
                --indent;
                boxedUnit = BoxedUnit.UNIT;
            } else if (xMLEvent instanceof Characters) {
                Characters characters = (Characters)xMLEvent;
                boxedUnit = xmlString.append(characters.getData());
            } else if (xMLEvent != null) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)xMLEvent);
            }
            XMLEvent xMLEvent2 = parser.peek();
            bl = xMLEvent2 instanceof EndElement ? indent > 0 : true;
        } while (bl);
        return xmlString.toString();
    }

    public void skipChildren(XMLEventReader parser) {
        boolean shouldStop = this.checkEndElement(parser);
        while (!shouldStop) {
            BoxedUnit boxedUnit;
            XMLEvent xMLEvent = parser.nextEvent();
            if (xMLEvent instanceof StartElement) {
                BoxedUnit boxedUnit2;
                XMLEvent e = parser.peek();
                Object object = e.isCharacters() && e.asCharacters().isWhiteSpace() ? parser.next() : BoxedUnit.UNIT;
                if (parser.peek().isStartElement()) {
                    this.skipChildren(parser);
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit2;
                continue;
            }
            if (xMLEvent instanceof EndElement) {
                shouldStop = this.checkEndElement(parser);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (xMLEvent != null) {
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            throw new MatchError((Object)xMLEvent);
        }
    }

    /*
     * WARNING - void declaration
     */
    private StaxXmlParserUtils$() {
        void var1_1;
        MODULE$ = this;
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isNamespaceAware", BoxesRunTime.boxToBoolean((boolean)false));
        factory.setProperty("javax.xml.stream.isCoalescing", BoxesRunTime.boxToBoolean((boolean)true));
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", BoxesRunTime.boxToBoolean((boolean)false));
        factory.setProperty("javax.xml.stream.supportDTD", BoxesRunTime.boxToBoolean((boolean)false));
        this.factory = var1_1;
    }
}

