/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.spark.xml.parsers;

import com.databricks.spark.xml.XmlOptions;
import java.io.Serializable;
import java.io.StringReader;
import javax.xml.namespace.QName;
import javax.xml.stream.EventFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndDocument;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class StaxXmlParserUtils$ {
    public static final StaxXmlParserUtils$ MODULE$;
    private static final XMLInputFactory factory;

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        MODULE$ = new StaxXmlParserUtils$();
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isNamespaceAware", BoxesRunTime.boxToBoolean((boolean)false));
        factory.setProperty("javax.xml.stream.isCoalescing", BoxesRunTime.boxToBoolean((boolean)true));
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", BoxesRunTime.boxToBoolean((boolean)false));
        factory.setProperty("javax.xml.stream.supportDTD", BoxesRunTime.boxToBoolean((boolean)false));
        StaxXmlParserUtils$.factory = var0;
    }

    public XMLInputFactory factory() {
        return factory;
    }

    public XMLEventReader filteredReader(String xml) {
        EventFilter filter = new EventFilter(){

            public boolean accept(XMLEvent event) {
                boolean bl;
                int n = event.getEventType();
                switch (n) {
                    case 3: 
                    case 5: {
                        bl = false;
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
                return bl;
            }
        };
        XMLEventReader eventReader = this.factory().createXMLEventReader(new StringReader(xml));
        return this.factory().createFilteredReader(eventReader, filter);
    }

    public Attribute[] gatherRootAttributes(XMLEventReader parser) {
        XMLEvent rootEvent = this.skipUntil(parser, 1);
        return (Attribute[])((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(rootEvent.asStartElement().getAttributes()).asScala()).map((Function1 & Serializable)x$1 -> (Attribute)x$1).toArray(ClassTag$.MODULE$.apply(Attribute.class));
    }

    /*
     * WARNING - void declaration
     */
    public XMLEvent skipUntil(XMLEventReader parser, int eventType) {
        void var3_3;
        XMLEvent event = parser.peek();
        while (parser.hasNext() && event.getEventType() != eventType) {
            event = parser.nextEvent();
        }
        return var3_3;
    }

    public boolean checkEndElement(XMLEventReader parser) {
        boolean bl;
        while (true) {
            XMLEvent xMLEvent;
            boolean bl2;
            if (bl2 = (xMLEvent = parser.peek()) instanceof EndElement ? true : xMLEvent instanceof EndDocument) {
                bl = true;
                break;
            }
            if (xMLEvent instanceof StartElement) {
                bl = false;
                break;
            }
            parser.nextEvent();
        }
        return bl;
    }

    public Map<String, String> convertAttributesToValuesMap(Attribute[] attributes, XmlOptions options) {
        return options.excludeAttributeFlag() ? Predef$.MODULE$.Map().empty() : Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])attributes), (Function1 & Serializable)attr -> {
            String string;
            String key = new StringBuilder(0).append(options.attributePrefix()).append(MODULE$.getName(attr.getName(), options)).toString();
            String string2 = attr.getValue();
            switch (string2 == null ? 0 : string2.hashCode()) {
                default: 
            }
            String value = string = options.treatEmptyValuesAsNulls() && string2.trim().isEmpty() ? null : string2;
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value);
        }, ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    /*
     * WARNING - void declaration
     */
    public String getName(QName name, XmlOptions options) {
        void var3_3;
        String localPart = name.getLocalPart();
        return options.ignoreNamespace() ? (String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])localPart.split(":"))) : var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public String currentStructureAsString(XMLEventReader parser) {
        void var3_2;
        String xmlString = "";
        boolean shouldStop = false;
        while (!shouldStop) {
            BoxedUnit boxedUnit;
            XMLEvent xMLEvent = parser.nextEvent();
            if (xMLEvent instanceof StartElement) {
                StartElement startElement = (StartElement)xMLEvent;
                String attributes = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(startElement.getAttributes()).asScala()).map((Function1 & Serializable)a -> {
                    Attribute att = (Attribute)a;
                    return new StringBuilder(4).append(" ").append(att.getName()).append("=\"").append(att.getValue()).append("\"").toString();
                }).mkString("");
                xmlString = new StringBuilder(2).append(xmlString).append("<").append(startElement.getName()).append(attributes).append(">").toString();
                xmlString = new StringBuilder(0).append(xmlString).append(this.convertChildren$1(parser)).toString();
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (xMLEvent instanceof EndElement) {
                EndElement endElement = (EndElement)xMLEvent;
                xmlString = new StringBuilder(3).append(xmlString).append("</").append(endElement.getName()).append(">").toString();
                shouldStop = this.checkEndElement(parser);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (xMLEvent != null) {
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            throw new MatchError((Object)xMLEvent);
        }
        return var3_2;
    }

    public void skipChildren(XMLEventReader parser) {
        boolean shouldStop = this.checkEndElement(parser);
        while (!shouldStop) {
            BoxedUnit boxedUnit;
            XMLEvent xMLEvent = parser.nextEvent();
            if (xMLEvent instanceof StartElement) {
                BoxedUnit boxedUnit2;
                XMLEvent e = parser.peek();
                Object object = e.isCharacters() && e.asCharacters().isWhiteSpace() ? parser.next() : BoxedUnit.UNIT;
                if (parser.peek().isStartElement()) {
                    this.skipChildren(parser);
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit2;
                continue;
            }
            if (xMLEvent instanceof EndElement) {
                shouldStop = this.checkEndElement(parser);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (xMLEvent != null) {
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            throw new MatchError((Object)xMLEvent);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String convertChildren$1(XMLEventReader parser$1) {
        String childrenXmlString = "";
        boolean bl = false;
        Characters characters = null;
        XMLEvent xMLEvent = parser$1.peek();
        if (xMLEvent instanceof StartElement) {
            childrenXmlString = new StringBuilder(0).append(childrenXmlString).append(this.currentStructureAsString(parser$1)).toString();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return childrenXmlString;
        }
        if (xMLEvent instanceof Characters) {
            bl = true;
            characters = (Characters)xMLEvent;
            if (characters.isWhiteSpace()) {
                childrenXmlString = new StringBuilder(0).append(childrenXmlString).append(characters.getData()).toString();
                parser$1.next();
                XMLEvent xMLEvent2 = parser$1.peek();
                if (xMLEvent2 instanceof StartElement) {
                    childrenXmlString = new StringBuilder(0).append(childrenXmlString).append(this.currentStructureAsString(parser$1)).toString();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    if (xMLEvent2 == null) throw new MatchError((Object)xMLEvent2);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return childrenXmlString;
            }
        }
        if (bl) {
            childrenXmlString = new StringBuilder(0).append(childrenXmlString).append(characters.getData()).toString();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return childrenXmlString;
        }
        if (xMLEvent == null) throw new MatchError((Object)xMLEvent);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return childrenXmlString;
    }

    private StaxXmlParserUtils$() {
    }
}

