package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.ContentEncoding;
import com.datadog.api.v1.client.model.HTTPLogItem;
import com.datadog.api.v1.client.model.LogsListRequest;
import com.datadog.api.v1.client.model.LogsListResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.GenericType;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class LogsApi {
  private ApiClient apiClient;

  public LogsApi() {
    this(Configuration.getDefaultApiClient());
  }

  public LogsApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Get the API cilent
   *
   * @return API client
   */
  public ApiClient getApiClient() {
    return apiClient;
  }

  /**
   * Set the API cilent
   *
   * @param apiClient an instance of API client
   */
  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Search logs List endpoint returns logs that match a log search query. [Results are
   * paginated][1]. **If you are considering archiving logs for your organization, consider use of
   * the Datadog archive capabilities instead of the log list API. See [Datadog Logs Archive
   * documentation][2].** [1]: /logs/guide/collect-multiple-logs-with-pagination [2]:
   * https://docs.datadoghq.com/logs/archives
   *
   * @param body Logs filter (required)
   * @return LogsListResponse
   * @throws ApiException if fails to make API call
   * @http.response.details
   *     <table summary="Response Details" border="1">
   *       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   *       <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
   *       <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
   *       <tr><td> 403 </td><td> Authentication error </td><td>  -  </td></tr>
   *     </table>
   */
  public LogsListResponse listLogs(LogsListRequest body) throws ApiException {
    return listLogsWithHttpInfo(body).getData();
  }

  /**
   * Search logs List endpoint returns logs that match a log search query. [Results are
   * paginated][1]. **If you are considering archiving logs for your organization, consider use of
   * the Datadog archive capabilities instead of the log list API. See [Datadog Logs Archive
   * documentation][2].** [1]: /logs/guide/collect-multiple-logs-with-pagination [2]:
   * https://docs.datadoghq.com/logs/archives
   *
   * @param body Logs filter (required)
   * @return ApiResponse&lt;LogsListResponse&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
   *     <table summary="Response Details" border="1">
   *       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   *       <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
   *       <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
   *       <tr><td> 403 </td><td> Authentication error </td><td>  -  </td></tr>
   *     </table>
   */
  public ApiResponse<LogsListResponse> listLogsWithHttpInfo(LogsListRequest body)
      throws ApiException {
    Object localVarPostBody = body;

    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling listLogs");
    }
    // create path and map variables
    String localVarPath = "/api/v1/logs-queries/list";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    // Set Operation-ID header for telemetry
    localVarHeaderParams.put("DD-OPERATION-ID", "listLogs");

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {"application/json"};
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {"apiKeyAuth", "appKeyAuth"};

    GenericType<LogsListResponse> localVarReturnType = new GenericType<LogsListResponse>() {};

    return apiClient.invokeAPI(
        "LogsApi.listLogs",
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType,
        false);
  }

  /** Manage optional parameters to submitLog. */
  public static class SubmitLogOptionalParameters {
    private ContentEncoding contentEncoding;
    private String ddtags;

    /**
     * Set contentEncoding
     *
     * @param contentEncoding HTTP header used to compress the media-type. (optional)
     * @return SubmitLogOptionalParameters
     */
    public SubmitLogOptionalParameters contentEncoding(ContentEncoding contentEncoding) {
      this.contentEncoding = contentEncoding;
      return this;
    }

    /**
     * Set ddtags
     *
     * @param ddtags Log tags can be passed as query parameters with &#x60;text/plain&#x60; content
     *     type. (optional)
     * @return SubmitLogOptionalParameters
     */
    public SubmitLogOptionalParameters ddtags(String ddtags) {
      this.ddtags = ddtags;
      return this;
    }
  }

  /**
   * Send logs Send your logs to your Datadog platform over HTTP. Limits per HTTP request are: -
   * Maximum content size per payload (uncompressed): 5MB - Maximum size for a single log: 1MB -
   * Maximum array size if sending multiple logs in an array: 1000 entries Any log exceeding 1MB is
   * accepted and truncated by Datadog: - For a single log request, the API truncates the log at 1MB
   * and returns a 2xx. - For a multi-logs request, the API processes all logs, truncates only logs
   * larger than 1MB, and returns a 2xx. Datadog recommends sending your logs compressed. Add the
   * &#x60;Content-Encoding: gzip&#x60; header to the request when sending compressed logs. The
   * status codes answered by the HTTP API are: - 200: OK - 400: Bad request (likely an issue in the
   * payload formatting) - 403: Permission issue (likely using an invalid API Key) - 413: Payload
   * too large (batch is above 5MB uncompressed) - 5xx: Internal error, request should be retried
   * after some time
   *
   * @param body Log to send (JSON format). (required)
   * @return Object
   * @throws ApiException if fails to make API call
   * @http.response.details
   *     <table summary="Response Details" border="1">
   *       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   *       <tr><td> 200 </td><td> Response from server (always 200 empty JSON). </td><td>  -  </td></tr>
   *       <tr><td> 400 </td><td> unexpected error </td><td>  -  </td></tr>
   *     </table>
   */
  public Object submitLog(List<HTTPLogItem> body) throws ApiException {
    return submitLogWithHttpInfo(body, new SubmitLogOptionalParameters()).getData();
  }

  /**
   * Send logs Send your logs to your Datadog platform over HTTP. Limits per HTTP request are: -
   * Maximum content size per payload (uncompressed): 5MB - Maximum size for a single log: 1MB -
   * Maximum array size if sending multiple logs in an array: 1000 entries Any log exceeding 1MB is
   * accepted and truncated by Datadog: - For a single log request, the API truncates the log at 1MB
   * and returns a 2xx. - For a multi-logs request, the API processes all logs, truncates only logs
   * larger than 1MB, and returns a 2xx. Datadog recommends sending your logs compressed. Add the
   * &#x60;Content-Encoding: gzip&#x60; header to the request when sending compressed logs. The
   * status codes answered by the HTTP API are: - 200: OK - 400: Bad request (likely an issue in the
   * payload formatting) - 403: Permission issue (likely using an invalid API Key) - 413: Payload
   * too large (batch is above 5MB uncompressed) - 5xx: Internal error, request should be retried
   * after some time
   *
   * @param body Log to send (JSON format). (required)
   * @param parameters Optional parameters for the request.
   * @return Object
   * @throws ApiException if fails to make API call
   * @http.response.details
   *     <table summary="Response Details" border="1">
   *       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   *       <tr><td> 200 </td><td> Response from server (always 200 empty JSON). </td><td>  -  </td></tr>
   *       <tr><td> 400 </td><td> unexpected error </td><td>  -  </td></tr>
   *     </table>
   */
  public Object submitLog(List<HTTPLogItem> body, SubmitLogOptionalParameters parameters)
      throws ApiException {
    return submitLogWithHttpInfo(body, parameters).getData();
  }

  /**
   * Send logs Send your logs to your Datadog platform over HTTP. Limits per HTTP request are: -
   * Maximum content size per payload (uncompressed): 5MB - Maximum size for a single log: 1MB -
   * Maximum array size if sending multiple logs in an array: 1000 entries Any log exceeding 1MB is
   * accepted and truncated by Datadog: - For a single log request, the API truncates the log at 1MB
   * and returns a 2xx. - For a multi-logs request, the API processes all logs, truncates only logs
   * larger than 1MB, and returns a 2xx. Datadog recommends sending your logs compressed. Add the
   * &#x60;Content-Encoding: gzip&#x60; header to the request when sending compressed logs. The
   * status codes answered by the HTTP API are: - 200: OK - 400: Bad request (likely an issue in the
   * payload formatting) - 403: Permission issue (likely using an invalid API Key) - 413: Payload
   * too large (batch is above 5MB uncompressed) - 5xx: Internal error, request should be retried
   * after some time
   *
   * @param body Log to send (JSON format). (required)
   * @param parameters Optional parameters for the request.
   * @return ApiResponse&lt;Object&gt;
   * @throws ApiException if fails to make API call
   * @http.response.details
   *     <table summary="Response Details" border="1">
   *       <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
   *       <tr><td> 200 </td><td> Response from server (always 200 empty JSON). </td><td>  -  </td></tr>
   *       <tr><td> 400 </td><td> unexpected error </td><td>  -  </td></tr>
   *     </table>
   */
  public ApiResponse<Object> submitLogWithHttpInfo(
      List<HTTPLogItem> body, SubmitLogOptionalParameters parameters) throws ApiException {
    Object localVarPostBody = body;

    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling submitLog");
    }
    ContentEncoding contentEncoding = parameters.contentEncoding;
    String ddtags = parameters.ddtags;
    // create path and map variables
    String localVarPath = "/v1/input";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "ddtags", ddtags));

    // Set Operation-ID header for telemetry
    localVarHeaderParams.put("DD-OPERATION-ID", "submitLog");

    if (contentEncoding != null)
      localVarHeaderParams.put("Content-Encoding", apiClient.parameterToString(contentEncoding));

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json", "application/logplex-1", "text/plain"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {"apiKeyAuth"};

    GenericType<Object> localVarReturnType = new GenericType<Object>() {};

    return apiClient.invokeAPI(
        "LogsApi.submitLog",
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType,
        false);
  }
}
