/*
 * Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2019-Present Datadog, Inc.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

/** Template variable. */
@ApiModel(description = "Template variable.")
@JsonPropertyOrder({
  DashboardTemplateVariable.JSON_PROPERTY_DEFAULT,
  DashboardTemplateVariable.JSON_PROPERTY_NAME,
  DashboardTemplateVariable.JSON_PROPERTY_PREFIX
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class DashboardTemplateVariable {
  public static final String JSON_PROPERTY_DEFAULT = "default";
  private JsonNullable<String> _default = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_PREFIX = "prefix";
  private JsonNullable<String> prefix = JsonNullable.<String>undefined();

  public DashboardTemplateVariable() {}

  @JsonCreator
  public DashboardTemplateVariable(
      @JsonProperty(required = true, value = JSON_PROPERTY_NAME) String name) {
    this.name = name;
  }

  public DashboardTemplateVariable _default(String _default) {
    this._default = JsonNullable.<String>of(_default);
    return this;
  }

  /**
   * The default value for the template variable on dashboard load.
   *
   * @return _default
   */
  @javax.annotation.Nullable
  @ApiModelProperty(
      example = "my-host",
      value = "The default value for the template variable on dashboard load.")
  @JsonIgnore
  public String getDefault() {
    return _default.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DEFAULT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public JsonNullable<String> getDefault_JsonNullable() {
    return _default;
  }

  @JsonProperty(JSON_PROPERTY_DEFAULT)
  public void setDefault_JsonNullable(JsonNullable<String> _default) {
    this._default = _default;
  }

  public void setDefault(String _default) {
    this._default = JsonNullable.<String>of(_default);
  }

  public DashboardTemplateVariable name(String name) {
    this.name = name;
    return this;
  }

  /**
   * The name of the variable.
   *
   * @return name
   */
  @ApiModelProperty(example = "host1", required = true, value = "The name of the variable.")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public DashboardTemplateVariable prefix(String prefix) {
    this.prefix = JsonNullable.<String>of(prefix);
    return this;
  }

  /**
   * The tag prefix associated with the variable. Only tags with this prefix appear in the variable
   * drop-down.
   *
   * @return prefix
   */
  @javax.annotation.Nullable
  @ApiModelProperty(
      example = "host",
      value =
          "The tag prefix associated with the variable. Only tags with this prefix appear in the"
              + " variable drop-down.")
  @JsonIgnore
  public String getPrefix() {
    return prefix.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PREFIX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public JsonNullable<String> getPrefix_JsonNullable() {
    return prefix;
  }

  @JsonProperty(JSON_PROPERTY_PREFIX)
  public void setPrefix_JsonNullable(JsonNullable<String> prefix) {
    this.prefix = prefix;
  }

  public void setPrefix(String prefix) {
    this.prefix = JsonNullable.<String>of(prefix);
  }

  /** Return true if this DashboardTemplateVariable object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DashboardTemplateVariable dashboardTemplateVariable = (DashboardTemplateVariable) o;
    return Objects.equals(this._default, dashboardTemplateVariable._default)
        && Objects.equals(this.name, dashboardTemplateVariable.name)
        && Objects.equals(this.prefix, dashboardTemplateVariable.prefix);
  }

  @Override
  public int hashCode() {
    return Objects.hash(_default, name, prefix);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DashboardTemplateVariable {\n");
    sb.append("    _default: ").append(toIndentedString(_default)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    prefix: ").append(toIndentedString(prefix)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
