/*
 * Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2019-Present Datadog, Inc.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.JSON;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.GenericType;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
@JsonDeserialize(
    using = FormulaAndFunctionQueryDefinition.FormulaAndFunctionQueryDefinitionDeserializer.class)
@JsonSerialize(
    using = FormulaAndFunctionQueryDefinition.FormulaAndFunctionQueryDefinitionSerializer.class)
public class FormulaAndFunctionQueryDefinition extends AbstractOpenApiSchema {
  private static final Logger log =
      Logger.getLogger(FormulaAndFunctionQueryDefinition.class.getName());

  public static class FormulaAndFunctionQueryDefinitionSerializer
      extends StdSerializer<FormulaAndFunctionQueryDefinition> {
    public FormulaAndFunctionQueryDefinitionSerializer(Class<FormulaAndFunctionQueryDefinition> t) {
      super(t);
    }

    public FormulaAndFunctionQueryDefinitionSerializer() {
      this(null);
    }

    @Override
    public void serialize(
        FormulaAndFunctionQueryDefinition value, JsonGenerator jgen, SerializerProvider provider)
        throws IOException, JsonProcessingException {
      jgen.writeObject(value.getActualInstance());
    }
  }

  public static class FormulaAndFunctionQueryDefinitionDeserializer
      extends StdDeserializer<FormulaAndFunctionQueryDefinition> {
    public FormulaAndFunctionQueryDefinitionDeserializer() {
      this(FormulaAndFunctionQueryDefinition.class);
    }

    public FormulaAndFunctionQueryDefinitionDeserializer(Class<?> vc) {
      super(vc);
    }

    @Override
    public FormulaAndFunctionQueryDefinition deserialize(JsonParser jp, DeserializationContext ctxt)
        throws IOException, JsonProcessingException {
      JsonNode tree = jp.readValueAsTree();
      Object deserialized = null;
      boolean typeCoercion = ctxt.isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS);
      int match = 0;
      JsonToken token = tree.traverse(jp.getCodec()).nextToken();
      // deserialize FormulaAndFunctionEventQueryDefinition
      try {
        boolean attemptParsing = true;
        // ensure that we respect type coercion as set on the client ObjectMapper
        if (FormulaAndFunctionEventQueryDefinition.class.equals(Integer.class)
            || FormulaAndFunctionEventQueryDefinition.class.equals(Long.class)
            || FormulaAndFunctionEventQueryDefinition.class.equals(Float.class)
            || FormulaAndFunctionEventQueryDefinition.class.equals(Double.class)
            || FormulaAndFunctionEventQueryDefinition.class.equals(Boolean.class)
            || FormulaAndFunctionEventQueryDefinition.class.equals(String.class)) {
          attemptParsing = typeCoercion;
          if (!attemptParsing) {
            attemptParsing |=
                ((FormulaAndFunctionEventQueryDefinition.class.equals(Integer.class)
                        || FormulaAndFunctionEventQueryDefinition.class.equals(Long.class))
                    && token == JsonToken.VALUE_NUMBER_INT);
            attemptParsing |=
                ((FormulaAndFunctionEventQueryDefinition.class.equals(Float.class)
                        || FormulaAndFunctionEventQueryDefinition.class.equals(Double.class))
                    && (token == JsonToken.VALUE_NUMBER_FLOAT
                        || token == JsonToken.VALUE_NUMBER_INT));
            attemptParsing |=
                (FormulaAndFunctionEventQueryDefinition.class.equals(Boolean.class)
                    && (token == JsonToken.VALUE_FALSE || token == JsonToken.VALUE_TRUE));
            attemptParsing |=
                (FormulaAndFunctionEventQueryDefinition.class.equals(String.class)
                    && token == JsonToken.VALUE_STRING);
          }
        }
        if (attemptParsing) {
          deserialized =
              tree.traverse(jp.getCodec())
                  .readValueAs(FormulaAndFunctionEventQueryDefinition.class);
          // TODO: there is no validation against JSON schema constraints
          // (min, max, enum, pattern...), this does not perform a strict JSON
          // validation, which means the 'match' count may be higher than it should be.
          match++;
          log.log(
              Level.FINER, "Input data matches schema 'FormulaAndFunctionEventQueryDefinition'");
        }
      } catch (Exception e) {
        // deserialization failed, continue
        log.log(
            Level.FINER,
            "Input data does not match schema 'FormulaAndFunctionEventQueryDefinition'",
            e);
      }

      // deserialize FormulaAndFunctionMetricQueryDefinition
      try {
        boolean attemptParsing = true;
        // ensure that we respect type coercion as set on the client ObjectMapper
        if (FormulaAndFunctionMetricQueryDefinition.class.equals(Integer.class)
            || FormulaAndFunctionMetricQueryDefinition.class.equals(Long.class)
            || FormulaAndFunctionMetricQueryDefinition.class.equals(Float.class)
            || FormulaAndFunctionMetricQueryDefinition.class.equals(Double.class)
            || FormulaAndFunctionMetricQueryDefinition.class.equals(Boolean.class)
            || FormulaAndFunctionMetricQueryDefinition.class.equals(String.class)) {
          attemptParsing = typeCoercion;
          if (!attemptParsing) {
            attemptParsing |=
                ((FormulaAndFunctionMetricQueryDefinition.class.equals(Integer.class)
                        || FormulaAndFunctionMetricQueryDefinition.class.equals(Long.class))
                    && token == JsonToken.VALUE_NUMBER_INT);
            attemptParsing |=
                ((FormulaAndFunctionMetricQueryDefinition.class.equals(Float.class)
                        || FormulaAndFunctionMetricQueryDefinition.class.equals(Double.class))
                    && (token == JsonToken.VALUE_NUMBER_FLOAT
                        || token == JsonToken.VALUE_NUMBER_INT));
            attemptParsing |=
                (FormulaAndFunctionMetricQueryDefinition.class.equals(Boolean.class)
                    && (token == JsonToken.VALUE_FALSE || token == JsonToken.VALUE_TRUE));
            attemptParsing |=
                (FormulaAndFunctionMetricQueryDefinition.class.equals(String.class)
                    && token == JsonToken.VALUE_STRING);
          }
        }
        if (attemptParsing) {
          deserialized =
              tree.traverse(jp.getCodec())
                  .readValueAs(FormulaAndFunctionMetricQueryDefinition.class);
          // TODO: there is no validation against JSON schema constraints
          // (min, max, enum, pattern...), this does not perform a strict JSON
          // validation, which means the 'match' count may be higher than it should be.
          match++;
          log.log(
              Level.FINER, "Input data matches schema 'FormulaAndFunctionMetricQueryDefinition'");
        }
      } catch (Exception e) {
        // deserialization failed, continue
        log.log(
            Level.FINER,
            "Input data does not match schema 'FormulaAndFunctionMetricQueryDefinition'",
            e);
      }

      // deserialize FormulaAndFunctionProcessQueryDefinition
      try {
        boolean attemptParsing = true;
        // ensure that we respect type coercion as set on the client ObjectMapper
        if (FormulaAndFunctionProcessQueryDefinition.class.equals(Integer.class)
            || FormulaAndFunctionProcessQueryDefinition.class.equals(Long.class)
            || FormulaAndFunctionProcessQueryDefinition.class.equals(Float.class)
            || FormulaAndFunctionProcessQueryDefinition.class.equals(Double.class)
            || FormulaAndFunctionProcessQueryDefinition.class.equals(Boolean.class)
            || FormulaAndFunctionProcessQueryDefinition.class.equals(String.class)) {
          attemptParsing = typeCoercion;
          if (!attemptParsing) {
            attemptParsing |=
                ((FormulaAndFunctionProcessQueryDefinition.class.equals(Integer.class)
                        || FormulaAndFunctionProcessQueryDefinition.class.equals(Long.class))
                    && token == JsonToken.VALUE_NUMBER_INT);
            attemptParsing |=
                ((FormulaAndFunctionProcessQueryDefinition.class.equals(Float.class)
                        || FormulaAndFunctionProcessQueryDefinition.class.equals(Double.class))
                    && (token == JsonToken.VALUE_NUMBER_FLOAT
                        || token == JsonToken.VALUE_NUMBER_INT));
            attemptParsing |=
                (FormulaAndFunctionProcessQueryDefinition.class.equals(Boolean.class)
                    && (token == JsonToken.VALUE_FALSE || token == JsonToken.VALUE_TRUE));
            attemptParsing |=
                (FormulaAndFunctionProcessQueryDefinition.class.equals(String.class)
                    && token == JsonToken.VALUE_STRING);
          }
        }
        if (attemptParsing) {
          deserialized =
              tree.traverse(jp.getCodec())
                  .readValueAs(FormulaAndFunctionProcessQueryDefinition.class);
          // TODO: there is no validation against JSON schema constraints
          // (min, max, enum, pattern...), this does not perform a strict JSON
          // validation, which means the 'match' count may be higher than it should be.
          match++;
          log.log(
              Level.FINER, "Input data matches schema 'FormulaAndFunctionProcessQueryDefinition'");
        }
      } catch (Exception e) {
        // deserialization failed, continue
        log.log(
            Level.FINER,
            "Input data does not match schema 'FormulaAndFunctionProcessQueryDefinition'",
            e);
      }

      if (match == 1) {
        FormulaAndFunctionQueryDefinition ret = new FormulaAndFunctionQueryDefinition();
        ret.setActualInstance(deserialized);
        return ret;
      }
      throw new IOException(
          String.format(
              "Failed deserialization for FormulaAndFunctionQueryDefinition: %d classes match"
                  + " result, expected 1",
              match));
    }

    /** Handle deserialization of the 'null' value. */
    @Override
    public FormulaAndFunctionQueryDefinition getNullValue(DeserializationContext ctxt)
        throws JsonMappingException {
      throw new JsonMappingException(
          ctxt.getParser(), "FormulaAndFunctionQueryDefinition cannot be null");
    }
  }

  // store a list of schema names defined in oneOf
  public static final Map<String, GenericType> schemas = new HashMap<String, GenericType>();

  public FormulaAndFunctionQueryDefinition() {
    super("oneOf", Boolean.FALSE);
  }

  public FormulaAndFunctionQueryDefinition(FormulaAndFunctionEventQueryDefinition o) {
    super("oneOf", Boolean.FALSE);
    setActualInstance(o);
  }

  public FormulaAndFunctionQueryDefinition(FormulaAndFunctionMetricQueryDefinition o) {
    super("oneOf", Boolean.FALSE);
    setActualInstance(o);
  }

  public FormulaAndFunctionQueryDefinition(FormulaAndFunctionProcessQueryDefinition o) {
    super("oneOf", Boolean.FALSE);
    setActualInstance(o);
  }

  static {
    schemas.put(
        "FormulaAndFunctionEventQueryDefinition",
        new GenericType<FormulaAndFunctionEventQueryDefinition>() {});
    schemas.put(
        "FormulaAndFunctionMetricQueryDefinition",
        new GenericType<FormulaAndFunctionMetricQueryDefinition>() {});
    schemas.put(
        "FormulaAndFunctionProcessQueryDefinition",
        new GenericType<FormulaAndFunctionProcessQueryDefinition>() {});
    JSON.registerDescendants(
        FormulaAndFunctionQueryDefinition.class, Collections.unmodifiableMap(schemas));
  }

  @Override
  public Map<String, GenericType> getSchemas() {
    return FormulaAndFunctionQueryDefinition.schemas;
  }

  /**
   * Set the instance that matches the oneOf child schema, check the instance parameter is valid
   * against the oneOf child schemas: FormulaAndFunctionEventQueryDefinition,
   * FormulaAndFunctionMetricQueryDefinition, FormulaAndFunctionProcessQueryDefinition
   *
   * <p>It could be an instance of the 'oneOf' schemas. The oneOf child schemas may themselves be a
   * composed schema (allOf, anyOf, oneOf).
   */
  @Override
  public void setActualInstance(Object instance) {
    if (JSON.isInstanceOf(
        FormulaAndFunctionEventQueryDefinition.class, instance, new HashSet<Class<?>>())) {
      super.setActualInstance(instance);
      return;
    }

    if (JSON.isInstanceOf(
        FormulaAndFunctionMetricQueryDefinition.class, instance, new HashSet<Class<?>>())) {
      super.setActualInstance(instance);
      return;
    }

    if (JSON.isInstanceOf(
        FormulaAndFunctionProcessQueryDefinition.class, instance, new HashSet<Class<?>>())) {
      super.setActualInstance(instance);
      return;
    }

    throw new RuntimeException(
        "Invalid instance type. Must be FormulaAndFunctionEventQueryDefinition,"
            + " FormulaAndFunctionMetricQueryDefinition,"
            + " FormulaAndFunctionProcessQueryDefinition");
  }

  /**
   * Get the actual instance, which can be the following: FormulaAndFunctionEventQueryDefinition,
   * FormulaAndFunctionMetricQueryDefinition, FormulaAndFunctionProcessQueryDefinition
   *
   * @return The actual instance (FormulaAndFunctionEventQueryDefinition,
   *     FormulaAndFunctionMetricQueryDefinition, FormulaAndFunctionProcessQueryDefinition)
   */
  @Override
  public Object getActualInstance() {
    return super.getActualInstance();
  }

  /**
   * Get the actual instance of `FormulaAndFunctionEventQueryDefinition`. If the actual instanct is
   * not `FormulaAndFunctionEventQueryDefinition`, the ClassCastException will be thrown.
   *
   * @return The actual instance of `FormulaAndFunctionEventQueryDefinition`
   * @throws ClassCastException if the instance is not `FormulaAndFunctionEventQueryDefinition`
   */
  public FormulaAndFunctionEventQueryDefinition getFormulaAndFunctionEventQueryDefinition()
      throws ClassCastException {
    return (FormulaAndFunctionEventQueryDefinition) super.getActualInstance();
  }

  /**
   * Get the actual instance of `FormulaAndFunctionMetricQueryDefinition`. If the actual instanct is
   * not `FormulaAndFunctionMetricQueryDefinition`, the ClassCastException will be thrown.
   *
   * @return The actual instance of `FormulaAndFunctionMetricQueryDefinition`
   * @throws ClassCastException if the instance is not `FormulaAndFunctionMetricQueryDefinition`
   */
  public FormulaAndFunctionMetricQueryDefinition getFormulaAndFunctionMetricQueryDefinition()
      throws ClassCastException {
    return (FormulaAndFunctionMetricQueryDefinition) super.getActualInstance();
  }

  /**
   * Get the actual instance of `FormulaAndFunctionProcessQueryDefinition`. If the actual instanct
   * is not `FormulaAndFunctionProcessQueryDefinition`, the ClassCastException will be thrown.
   *
   * @return The actual instance of `FormulaAndFunctionProcessQueryDefinition`
   * @throws ClassCastException if the instance is not `FormulaAndFunctionProcessQueryDefinition`
   */
  public FormulaAndFunctionProcessQueryDefinition getFormulaAndFunctionProcessQueryDefinition()
      throws ClassCastException {
    return (FormulaAndFunctionProcessQueryDefinition) super.getActualInstance();
  }
}
