/*
 * Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2019-Present Datadog, Inc.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * Use the Category Processor to add a new attribute (without spaces or special characters in the
 * new attribute name) to a log matching a provided search query. Use categories to create groups
 * for an analytical view. For example, URL groups, machine groups, environments, and response time
 * buckets. **Notes**: - The syntax of the query is the one of Logs Explorer search bar. The query
 * can be done on any log attribute or tag, whether it is a facet or not. Wildcards can also be used
 * inside your query. - Once the log has matched one of the Processor queries, it stops. Make sure
 * they are properly ordered in case a log could match several queries. - The names of the
 * categories must be unique. - Once defined in the Category Processor, you can map categories to
 * log status using the Log Status Remapper.
 */
@ApiModel(
    description =
        "Use the Category Processor to add a new attribute (without spaces or special characters"
            + " in the new attribute name) to a log matching a provided search query. Use"
            + " categories to create groups for an analytical view. For example, URL groups,"
            + " machine groups, environments, and response time buckets.  **Notes**:  - The syntax"
            + " of the query is the one of Logs Explorer search bar.   The query can be done on"
            + " any log attribute or tag, whether it is a facet or not.   Wildcards can also be"
            + " used inside your query. - Once the log has matched one of the Processor queries,"
            + " it stops.   Make sure they are properly ordered in case a log could match several"
            + " queries. - The names of the categories must be unique. - Once defined in the"
            + " Category Processor, you can map categories to log status using the Log Status"
            + " Remapper.")
@JsonPropertyOrder({
  LogsCategoryProcessor.JSON_PROPERTY_CATEGORIES,
  LogsCategoryProcessor.JSON_PROPERTY_IS_ENABLED,
  LogsCategoryProcessor.JSON_PROPERTY_NAME,
  LogsCategoryProcessor.JSON_PROPERTY_TARGET,
  LogsCategoryProcessor.JSON_PROPERTY_TYPE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class LogsCategoryProcessor {
  public static final String JSON_PROPERTY_CATEGORIES = "categories";
  private List<LogsCategoryProcessorCategory> categories = new ArrayList<>();

  public static final String JSON_PROPERTY_IS_ENABLED = "is_enabled";
  private Boolean isEnabled = false;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_TARGET = "target";
  private String target;

  public static final String JSON_PROPERTY_TYPE = "type";
  private LogsCategoryProcessorType type = LogsCategoryProcessorType.CATEGORY_PROCESSOR;

  public LogsCategoryProcessor() {}

  @JsonCreator
  public LogsCategoryProcessor(
      @JsonProperty(required = true, value = JSON_PROPERTY_CATEGORIES)
          List<LogsCategoryProcessorCategory> categories,
      @JsonProperty(required = true, value = JSON_PROPERTY_TARGET) String target,
      @JsonProperty(required = true, value = JSON_PROPERTY_TYPE) LogsCategoryProcessorType type) {
    this.categories = categories;
    this.target = target;
    this.type = type;
  }

  public LogsCategoryProcessor categories(List<LogsCategoryProcessorCategory> categories) {
    this.categories = categories;
    return this;
  }

  public LogsCategoryProcessor addCategoriesItem(LogsCategoryProcessorCategory categoriesItem) {
    this.categories.add(categoriesItem);
    return this;
  }

  /**
   * Array of filters to match or not a log and their corresponding &#x60;name&#x60;to assign a
   * custom value to the log.
   *
   * @return categories
   */
  @ApiModelProperty(
      example = "[]",
      required = true,
      value =
          "Array of filters to match or not a log and their corresponding `name`to assign a custom"
              + " value to the log.")
  @JsonProperty(JSON_PROPERTY_CATEGORIES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public List<LogsCategoryProcessorCategory> getCategories() {
    return categories;
  }

  public void setCategories(List<LogsCategoryProcessorCategory> categories) {
    this.categories = categories;
  }

  public LogsCategoryProcessor isEnabled(Boolean isEnabled) {
    this.isEnabled = isEnabled;
    return this;
  }

  /**
   * Whether or not the processor is enabled.
   *
   * @return isEnabled
   */
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Whether or not the processor is enabled.")
  @JsonProperty(JSON_PROPERTY_IS_ENABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getIsEnabled() {
    return isEnabled;
  }

  public void setIsEnabled(Boolean isEnabled) {
    this.isEnabled = isEnabled;
  }

  public LogsCategoryProcessor name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Name of the processor.
   *
   * @return name
   */
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Name of the processor.")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public LogsCategoryProcessor target(String target) {
    this.target = target;
    return this;
  }

  /**
   * Name of the target attribute which value is defined by the matching category.
   *
   * @return target
   */
  @ApiModelProperty(
      example = "",
      required = true,
      value = "Name of the target attribute which value is defined by the matching category.")
  @JsonProperty(JSON_PROPERTY_TARGET)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getTarget() {
    return target;
  }

  public void setTarget(String target) {
    this.target = target;
  }

  public LogsCategoryProcessor type(LogsCategoryProcessorType type) {
    this.type = type;
    return this;
  }

  /**
   * Get type
   *
   * @return type
   */
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public LogsCategoryProcessorType getType() {
    return type;
  }

  public void setType(LogsCategoryProcessorType type) {
    this.type = type;
  }

  /** Return true if this LogsCategoryProcessor object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LogsCategoryProcessor logsCategoryProcessor = (LogsCategoryProcessor) o;
    return Objects.equals(this.categories, logsCategoryProcessor.categories)
        && Objects.equals(this.isEnabled, logsCategoryProcessor.isEnabled)
        && Objects.equals(this.name, logsCategoryProcessor.name)
        && Objects.equals(this.target, logsCategoryProcessor.target)
        && Objects.equals(this.type, logsCategoryProcessor.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(categories, isEnabled, name, target, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LogsCategoryProcessor {\n");
    sb.append("    categories: ").append(toIndentedString(categories)).append("\n");
    sb.append("    isEnabled: ").append(toIndentedString(isEnabled)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    target: ").append(toIndentedString(target)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
