/*
 * Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2019-Present Datadog, Inc.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** Object with all Index configurations for a given organization. */
@ApiModel(description = "Object with all Index configurations for a given organization.")
@JsonPropertyOrder({LogsIndexListResponse.JSON_PROPERTY_INDEXES})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class LogsIndexListResponse {
  public static final String JSON_PROPERTY_INDEXES = "indexes";
  private List<LogsIndex> indexes = null;

  public LogsIndexListResponse indexes(List<LogsIndex> indexes) {
    this.indexes = indexes;
    return this;
  }

  public LogsIndexListResponse addIndexesItem(LogsIndex indexesItem) {
    if (this.indexes == null) {
      this.indexes = new ArrayList<>();
    }
    this.indexes.add(indexesItem);
    return this;
  }

  /**
   * Array of Log index configurations.
   *
   * @return indexes
   */
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Array of Log index configurations.")
  @JsonProperty(JSON_PROPERTY_INDEXES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<LogsIndex> getIndexes() {
    return indexes;
  }

  public void setIndexes(List<LogsIndex> indexes) {
    this.indexes = indexes;
  }

  /** Return true if this LogsIndexListResponse object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LogsIndexListResponse logsIndexListResponse = (LogsIndexListResponse) o;
    return Objects.equals(this.indexes, logsIndexListResponse.indexes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(indexes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LogsIndexListResponse {\n");
    sb.append("    indexes: ").append(toIndentedString(indexes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
