/*
 * Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2019-Present Datadog, Inc.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

/** The attributes of a notebook &#x60;distribution&#x60; cell. */
@ApiModel(description = "The attributes of a notebook `distribution` cell.")
@JsonPropertyOrder({
  NotebookDistributionCellAttributes.JSON_PROPERTY_DEFINITION,
  NotebookDistributionCellAttributes.JSON_PROPERTY_GRAPH_SIZE,
  NotebookDistributionCellAttributes.JSON_PROPERTY_SPLIT_BY,
  NotebookDistributionCellAttributes.JSON_PROPERTY_TIME
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class NotebookDistributionCellAttributes {
  public static final String JSON_PROPERTY_DEFINITION = "definition";
  private DistributionWidgetDefinition definition;

  public static final String JSON_PROPERTY_GRAPH_SIZE = "graph_size";
  private NotebookGraphSize graphSize;

  public static final String JSON_PROPERTY_SPLIT_BY = "split_by";
  private NotebookSplitBy splitBy;

  public static final String JSON_PROPERTY_TIME = "time";
  private JsonNullable<NotebookCellTime> time = JsonNullable.<NotebookCellTime>undefined();

  public NotebookDistributionCellAttributes() {}

  @JsonCreator
  public NotebookDistributionCellAttributes(
      @JsonProperty(required = true, value = JSON_PROPERTY_DEFINITION)
          DistributionWidgetDefinition definition) {
    this.definition = definition;
  }

  public NotebookDistributionCellAttributes definition(DistributionWidgetDefinition definition) {
    this.definition = definition;
    return this;
  }

  /**
   * Get definition
   *
   * @return definition
   */
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_DEFINITION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public DistributionWidgetDefinition getDefinition() {
    return definition;
  }

  public void setDefinition(DistributionWidgetDefinition definition) {
    this.definition = definition;
  }

  public NotebookDistributionCellAttributes graphSize(NotebookGraphSize graphSize) {
    this.graphSize = graphSize;
    return this;
  }

  /**
   * Get graphSize
   *
   * @return graphSize
   */
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_GRAPH_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public NotebookGraphSize getGraphSize() {
    return graphSize;
  }

  public void setGraphSize(NotebookGraphSize graphSize) {
    this.graphSize = graphSize;
  }

  public NotebookDistributionCellAttributes splitBy(NotebookSplitBy splitBy) {
    this.splitBy = splitBy;
    return this;
  }

  /**
   * Get splitBy
   *
   * @return splitBy
   */
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SPLIT_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public NotebookSplitBy getSplitBy() {
    return splitBy;
  }

  public void setSplitBy(NotebookSplitBy splitBy) {
    this.splitBy = splitBy;
  }

  public NotebookDistributionCellAttributes time(NotebookCellTime time) {
    this.time = JsonNullable.<NotebookCellTime>of(time);
    return this;
  }

  /**
   * Get time
   *
   * @return time
   */
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonIgnore
  public NotebookCellTime getTime() {
    return time.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public JsonNullable<NotebookCellTime> getTime_JsonNullable() {
    return time;
  }

  @JsonProperty(JSON_PROPERTY_TIME)
  public void setTime_JsonNullable(JsonNullable<NotebookCellTime> time) {
    this.time = time;
  }

  public void setTime(NotebookCellTime time) {
    this.time = JsonNullable.<NotebookCellTime>of(time);
  }

  /** Return true if this NotebookDistributionCellAttributes object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    NotebookDistributionCellAttributes notebookDistributionCellAttributes =
        (NotebookDistributionCellAttributes) o;
    return Objects.equals(this.definition, notebookDistributionCellAttributes.definition)
        && Objects.equals(this.graphSize, notebookDistributionCellAttributes.graphSize)
        && Objects.equals(this.splitBy, notebookDistributionCellAttributes.splitBy)
        && Objects.equals(this.time, notebookDistributionCellAttributes.time);
  }

  @Override
  public int hashCode() {
    return Objects.hash(definition, graphSize, splitBy, time);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class NotebookDistributionCellAttributes {\n");
    sb.append("    definition: ").append(toIndentedString(definition)).append("\n");
    sb.append("    graphSize: ").append(toIndentedString(graphSize)).append("\n");
    sb.append("    splitBy: ").append(toIndentedString(splitBy)).append("\n");
    sb.append("    time: ").append(toIndentedString(time)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
