/*
 * Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2019-Present Datadog, Inc.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/** The attribute object associated with the SLO correction to be created */
@ApiModel(description = "The attribute object associated with the SLO correction to be created")
@JsonPropertyOrder({
  SLOCorrectionCreateRequestAttributes.JSON_PROPERTY_CATEGORY,
  SLOCorrectionCreateRequestAttributes.JSON_PROPERTY_DESCRIPTION,
  SLOCorrectionCreateRequestAttributes.JSON_PROPERTY_END,
  SLOCorrectionCreateRequestAttributes.JSON_PROPERTY_SLO_ID,
  SLOCorrectionCreateRequestAttributes.JSON_PROPERTY_START,
  SLOCorrectionCreateRequestAttributes.JSON_PROPERTY_TIMEZONE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class SLOCorrectionCreateRequestAttributes {
  public static final String JSON_PROPERTY_CATEGORY = "category";
  private SLOCorrectionCategory category;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_END = "end";
  private Long end;

  public static final String JSON_PROPERTY_SLO_ID = "slo_id";
  private String sloId;

  public static final String JSON_PROPERTY_START = "start";
  private Long start;

  public static final String JSON_PROPERTY_TIMEZONE = "timezone";
  private String timezone;

  public SLOCorrectionCreateRequestAttributes() {}

  @JsonCreator
  public SLOCorrectionCreateRequestAttributes(
      @JsonProperty(required = true, value = JSON_PROPERTY_CATEGORY) SLOCorrectionCategory category,
      @JsonProperty(required = true, value = JSON_PROPERTY_END) Long end,
      @JsonProperty(required = true, value = JSON_PROPERTY_SLO_ID) String sloId,
      @JsonProperty(required = true, value = JSON_PROPERTY_START) Long start) {
    this.category = category;
    this.end = end;
    this.sloId = sloId;
    this.start = start;
  }

  public SLOCorrectionCreateRequestAttributes category(SLOCorrectionCategory category) {
    this.category = category;
    return this;
  }

  /**
   * Get category
   *
   * @return category
   */
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public SLOCorrectionCategory getCategory() {
    return category;
  }

  public void setCategory(SLOCorrectionCategory category) {
    this.category = category;
  }

  public SLOCorrectionCreateRequestAttributes description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Description of the correction being made.
   *
   * @return description
   */
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Description of the correction being made.")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public SLOCorrectionCreateRequestAttributes end(Long end) {
    this.end = end;
    return this;
  }

  /**
   * Ending time of the correction in epoch seconds
   *
   * @return end
   */
  @ApiModelProperty(
      example = "1600000000",
      required = true,
      value = "Ending time of the correction in epoch seconds")
  @JsonProperty(JSON_PROPERTY_END)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public Long getEnd() {
    return end;
  }

  public void setEnd(Long end) {
    this.end = end;
  }

  public SLOCorrectionCreateRequestAttributes sloId(String sloId) {
    this.sloId = sloId;
    return this;
  }

  /**
   * ID of the SLO that this correction will be applied to
   *
   * @return sloId
   */
  @ApiModelProperty(
      example = "sloId",
      required = true,
      value = "ID of the SLO that this correction will be applied to")
  @JsonProperty(JSON_PROPERTY_SLO_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getSloId() {
    return sloId;
  }

  public void setSloId(String sloId) {
    this.sloId = sloId;
  }

  public SLOCorrectionCreateRequestAttributes start(Long start) {
    this.start = start;
    return this;
  }

  /**
   * Starting time of the correction in epoch seconds
   *
   * @return start
   */
  @ApiModelProperty(
      example = "1600000000",
      required = true,
      value = "Starting time of the correction in epoch seconds")
  @JsonProperty(JSON_PROPERTY_START)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public Long getStart() {
    return start;
  }

  public void setStart(Long start) {
    this.start = start;
  }

  public SLOCorrectionCreateRequestAttributes timezone(String timezone) {
    this.timezone = timezone;
    return this;
  }

  /**
   * The timezone to display in the UI for the correction times (defaults to \&quot;UTC\&quot;)
   *
   * @return timezone
   */
  @javax.annotation.Nullable
  @ApiModelProperty(
      example = "UTC",
      value = "The timezone to display in the UI for the correction times (defaults to \"UTC\")")
  @JsonProperty(JSON_PROPERTY_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getTimezone() {
    return timezone;
  }

  public void setTimezone(String timezone) {
    this.timezone = timezone;
  }

  /** Return true if this SLOCorrectionCreateRequestAttributes object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SLOCorrectionCreateRequestAttributes slOCorrectionCreateRequestAttributes =
        (SLOCorrectionCreateRequestAttributes) o;
    return Objects.equals(this.category, slOCorrectionCreateRequestAttributes.category)
        && Objects.equals(this.description, slOCorrectionCreateRequestAttributes.description)
        && Objects.equals(this.end, slOCorrectionCreateRequestAttributes.end)
        && Objects.equals(this.sloId, slOCorrectionCreateRequestAttributes.sloId)
        && Objects.equals(this.start, slOCorrectionCreateRequestAttributes.start)
        && Objects.equals(this.timezone, slOCorrectionCreateRequestAttributes.timezone);
  }

  @Override
  public int hashCode() {
    return Objects.hash(category, description, end, sloId, start, timezone);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SLOCorrectionCreateRequestAttributes {\n");
    sb.append("    category: ").append(toIndentedString(category)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    end: ").append(toIndentedString(end)).append("\n");
    sb.append("    sloId: ").append(toIndentedString(sloId)).append("\n");
    sb.append("    start: ").append(toIndentedString(start)).append("\n");
    sb.append("    timezone: ").append(toIndentedString(timezone)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
