/*
 * Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2019-Present Datadog, Inc.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** A response with one or more service level objective. */
@ApiModel(description = "A response with one or more service level objective.")
@JsonPropertyOrder({
  SLOListResponse.JSON_PROPERTY_DATA,
  SLOListResponse.JSON_PROPERTY_ERRORS,
  SLOListResponse.JSON_PROPERTY_METADATA
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class SLOListResponse {
  public static final String JSON_PROPERTY_DATA = "data";
  private List<ServiceLevelObjective> data = null;

  public static final String JSON_PROPERTY_ERRORS = "errors";
  private List<String> errors = null;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private SLOListResponseMetadata metadata;

  public SLOListResponse data(List<ServiceLevelObjective> data) {
    this.data = data;
    return this;
  }

  public SLOListResponse addDataItem(ServiceLevelObjective dataItem) {
    if (this.data == null) {
      this.data = new ArrayList<>();
    }
    this.data.add(dataItem);
    return this;
  }

  /**
   * An array of service level objective objects.
   *
   * @return data
   */
  @javax.annotation.Nullable
  @ApiModelProperty(value = "An array of service level objective objects.")
  @JsonProperty(JSON_PROPERTY_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<ServiceLevelObjective> getData() {
    return data;
  }

  public void setData(List<ServiceLevelObjective> data) {
    this.data = data;
  }

  public SLOListResponse errors(List<String> errors) {
    this.errors = errors;
    return this;
  }

  public SLOListResponse addErrorsItem(String errorsItem) {
    if (this.errors == null) {
      this.errors = new ArrayList<>();
    }
    this.errors.add(errorsItem);
    return this;
  }

  /**
   * An array of error messages. Each endpoint documents how/whether this field is used.
   *
   * @return errors
   */
  @javax.annotation.Nullable
  @ApiModelProperty(
      value = "An array of error messages. Each endpoint documents how/whether this field is used.")
  @JsonProperty(JSON_PROPERTY_ERRORS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getErrors() {
    return errors;
  }

  public void setErrors(List<String> errors) {
    this.errors = errors;
  }

  public SLOListResponse metadata(SLOListResponseMetadata metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * Get metadata
   *
   * @return metadata
   */
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public SLOListResponseMetadata getMetadata() {
    return metadata;
  }

  public void setMetadata(SLOListResponseMetadata metadata) {
    this.metadata = metadata;
  }

  /** Return true if this SLOListResponse object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SLOListResponse slOListResponse = (SLOListResponse) o;
    return Objects.equals(this.data, slOListResponse.data)
        && Objects.equals(this.errors, slOListResponse.errors)
        && Objects.equals(this.metadata, slOListResponse.metadata);
  }

  @Override
  public int hashCode() {
    return Objects.hash(data, errors, metadata);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SLOListResponse {\n");
    sb.append("    data: ").append(toIndentedString(data)).append("\n");
    sb.append("    errors: ").append(toIndentedString(errors)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
