/*
 * Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2019-Present Datadog, Inc.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** Configuration object for a Synthetic API test. */
@ApiModel(description = "Configuration object for a Synthetic API test.")
@JsonPropertyOrder({
  SyntheticsAPITestConfig.JSON_PROPERTY_ASSERTIONS,
  SyntheticsAPITestConfig.JSON_PROPERTY_CONFIG_VARIABLES,
  SyntheticsAPITestConfig.JSON_PROPERTY_REQUEST,
  SyntheticsAPITestConfig.JSON_PROPERTY_STEPS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class SyntheticsAPITestConfig {
  public static final String JSON_PROPERTY_ASSERTIONS = "assertions";
  private List<SyntheticsAssertion> assertions = null;

  public static final String JSON_PROPERTY_CONFIG_VARIABLES = "configVariables";
  private List<SyntheticsConfigVariable> configVariables = null;

  public static final String JSON_PROPERTY_REQUEST = "request";
  private SyntheticsTestRequest request;

  public static final String JSON_PROPERTY_STEPS = "steps";
  private List<SyntheticsAPIStep> steps = null;

  public SyntheticsAPITestConfig assertions(List<SyntheticsAssertion> assertions) {
    this.assertions = assertions;
    return this;
  }

  public SyntheticsAPITestConfig addAssertionsItem(SyntheticsAssertion assertionsItem) {
    if (this.assertions == null) {
      this.assertions = new ArrayList<>();
    }
    this.assertions.add(assertionsItem);
    return this;
  }

  /**
   * Array of assertions used for the test.
   *
   * @return assertions
   */
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[]", value = "Array of assertions used for the test.")
  @JsonProperty(JSON_PROPERTY_ASSERTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<SyntheticsAssertion> getAssertions() {
    return assertions;
  }

  public void setAssertions(List<SyntheticsAssertion> assertions) {
    this.assertions = assertions;
  }

  public SyntheticsAPITestConfig configVariables(List<SyntheticsConfigVariable> configVariables) {
    this.configVariables = configVariables;
    return this;
  }

  public SyntheticsAPITestConfig addConfigVariablesItem(
      SyntheticsConfigVariable configVariablesItem) {
    if (this.configVariables == null) {
      this.configVariables = new ArrayList<>();
    }
    this.configVariables.add(configVariablesItem);
    return this;
  }

  /**
   * Array of variables used for the test.
   *
   * @return configVariables
   */
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Array of variables used for the test.")
  @JsonProperty(JSON_PROPERTY_CONFIG_VARIABLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<SyntheticsConfigVariable> getConfigVariables() {
    return configVariables;
  }

  public void setConfigVariables(List<SyntheticsConfigVariable> configVariables) {
    this.configVariables = configVariables;
  }

  public SyntheticsAPITestConfig request(SyntheticsTestRequest request) {
    this.request = request;
    return this;
  }

  /**
   * Get request
   *
   * @return request
   */
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_REQUEST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public SyntheticsTestRequest getRequest() {
    return request;
  }

  public void setRequest(SyntheticsTestRequest request) {
    this.request = request;
  }

  public SyntheticsAPITestConfig steps(List<SyntheticsAPIStep> steps) {
    this.steps = steps;
    return this;
  }

  public SyntheticsAPITestConfig addStepsItem(SyntheticsAPIStep stepsItem) {
    if (this.steps == null) {
      this.steps = new ArrayList<>();
    }
    this.steps.add(stepsItem);
    return this;
  }

  /**
   * When the test subtype is &#x60;multi&#x60;, the steps of the test.
   *
   * @return steps
   */
  @javax.annotation.Nullable
  @ApiModelProperty(value = "When the test subtype is `multi`, the steps of the test.")
  @JsonProperty(JSON_PROPERTY_STEPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<SyntheticsAPIStep> getSteps() {
    return steps;
  }

  public void setSteps(List<SyntheticsAPIStep> steps) {
    this.steps = steps;
  }

  /** Return true if this SyntheticsAPITestConfig object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SyntheticsAPITestConfig syntheticsAPITestConfig = (SyntheticsAPITestConfig) o;
    return Objects.equals(this.assertions, syntheticsAPITestConfig.assertions)
        && Objects.equals(this.configVariables, syntheticsAPITestConfig.configVariables)
        && Objects.equals(this.request, syntheticsAPITestConfig.request)
        && Objects.equals(this.steps, syntheticsAPITestConfig.steps);
  }

  @Override
  public int hashCode() {
    return Objects.hash(assertions, configVariables, request, steps);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SyntheticsAPITestConfig {\n");
    sb.append("    assertions: ").append(toIndentedString(assertions)).append("\n");
    sb.append("    configVariables: ").append(toIndentedString(configVariables)).append("\n");
    sb.append("    request: ").append(toIndentedString(request)).append("\n");
    sb.append("    steps: ").append(toIndentedString(steps)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
