/*
 * Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2019-Present Datadog, Inc.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** Response containing the number of profiled hosts for each hour for a given organization. */
@ApiModel(
    description =
        "Response containing the number of profiled hosts for each hour for a given organization.")
@JsonPropertyOrder({UsageProfilingResponse.JSON_PROPERTY_USAGE})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class UsageProfilingResponse {
  public static final String JSON_PROPERTY_USAGE = "usage";
  private List<UsageProfilingHour> usage = null;

  public UsageProfilingResponse usage(List<UsageProfilingHour> usage) {
    this.usage = usage;
    return this;
  }

  public UsageProfilingResponse addUsageItem(UsageProfilingHour usageItem) {
    if (this.usage == null) {
      this.usage = new ArrayList<>();
    }
    this.usage.add(usageItem);
    return this;
  }

  /**
   * Get hourly usage for profiled hosts.
   *
   * @return usage
   */
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Get hourly usage for profiled hosts.")
  @JsonProperty(JSON_PROPERTY_USAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<UsageProfilingHour> getUsage() {
    return usage;
  }

  public void setUsage(List<UsageProfilingHour> usage) {
    this.usage = usage;
  }

  /** Return true if this UsageProfilingResponse object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UsageProfilingResponse usageProfilingResponse = (UsageProfilingResponse) o;
    return Objects.equals(this.usage, usageProfilingResponse.usage);
  }

  @Override
  public int hashCode() {
    return Objects.hash(usage);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UsageProfilingResponse {\n");
    sb.append("    usage: ").append(toIndentedString(usage)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
