/*
 * Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2019-Present Datadog, Inc.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.datadog.api.v2.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/** Datadog application key. */
@ApiModel(description = "Datadog application key.")
@JsonPropertyOrder({
  FullApplicationKey.JSON_PROPERTY_ATTRIBUTES,
  FullApplicationKey.JSON_PROPERTY_ID,
  FullApplicationKey.JSON_PROPERTY_RELATIONSHIPS,
  FullApplicationKey.JSON_PROPERTY_TYPE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class FullApplicationKey {
  public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
  private FullApplicationKeyAttributes attributes;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_RELATIONSHIPS = "relationships";
  private ApplicationKeyRelationships relationships;

  public static final String JSON_PROPERTY_TYPE = "type";
  private ApplicationKeysType type = ApplicationKeysType.APPLICATION_KEYS;

  public FullApplicationKey attributes(FullApplicationKeyAttributes attributes) {
    this.attributes = attributes;
    return this;
  }

  /**
   * Get attributes
   *
   * @return attributes
   */
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ATTRIBUTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public FullApplicationKeyAttributes getAttributes() {
    return attributes;
  }

  public void setAttributes(FullApplicationKeyAttributes attributes) {
    this.attributes = attributes;
  }

  public FullApplicationKey id(String id) {
    this.id = id;
    return this;
  }

  /**
   * ID of the application key.
   *
   * @return id
   */
  @javax.annotation.Nullable
  @ApiModelProperty(value = "ID of the application key.")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public FullApplicationKey relationships(ApplicationKeyRelationships relationships) {
    this.relationships = relationships;
    return this;
  }

  /**
   * Get relationships
   *
   * @return relationships
   */
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RELATIONSHIPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ApplicationKeyRelationships getRelationships() {
    return relationships;
  }

  public void setRelationships(ApplicationKeyRelationships relationships) {
    this.relationships = relationships;
  }

  public FullApplicationKey type(ApplicationKeysType type) {
    this.type = type;
    return this;
  }

  /**
   * Get type
   *
   * @return type
   */
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ApplicationKeysType getType() {
    return type;
  }

  public void setType(ApplicationKeysType type) {
    this.type = type;
  }

  /** Return true if this FullApplicationKey object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FullApplicationKey fullApplicationKey = (FullApplicationKey) o;
    return Objects.equals(this.attributes, fullApplicationKey.attributes)
        && Objects.equals(this.id, fullApplicationKey.id)
        && Objects.equals(this.relationships, fullApplicationKey.relationships)
        && Objects.equals(this.type, fullApplicationKey.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(attributes, id, relationships, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FullApplicationKey {\n");
    sb.append("    attributes: ").append(toIndentedString(attributes)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    relationships: ").append(toIndentedString(relationships)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
