/*
 * Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2019-Present Datadog, Inc.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.datadog.api.v2.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

/** The incident service&#39;s attributes from a response. */
@ApiModel(description = "The incident service's attributes from a response.")
@JsonPropertyOrder({
  IncidentServiceResponseAttributes.JSON_PROPERTY_CREATED,
  IncidentServiceResponseAttributes.JSON_PROPERTY_MODIFIED,
  IncidentServiceResponseAttributes.JSON_PROPERTY_NAME
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class IncidentServiceResponseAttributes {
  public static final String JSON_PROPERTY_CREATED = "created";
  private OffsetDateTime created;

  public static final String JSON_PROPERTY_MODIFIED = "modified";
  private OffsetDateTime modified;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  /**
   * Timestamp of when the incident service was created.
   *
   * @return created
   */
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Timestamp of when the incident service was created.")
  @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getCreated() {
    return created;
  }

  /**
   * Timestamp of when the incident service was modified.
   *
   * @return modified
   */
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Timestamp of when the incident service was modified.")
  @JsonProperty(JSON_PROPERTY_MODIFIED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getModified() {
    return modified;
  }

  public IncidentServiceResponseAttributes name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Name of the incident service.
   *
   * @return name
   */
  @javax.annotation.Nullable
  @ApiModelProperty(example = "service name", value = "Name of the incident service.")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  /** Return true if this IncidentServiceResponseAttributes object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    IncidentServiceResponseAttributes incidentServiceResponseAttributes =
        (IncidentServiceResponseAttributes) o;
    return Objects.equals(this.created, incidentServiceResponseAttributes.created)
        && Objects.equals(this.modified, incidentServiceResponseAttributes.modified)
        && Objects.equals(this.name, incidentServiceResponseAttributes.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(created, modified, name);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IncidentServiceResponseAttributes {\n");
    sb.append("    created: ").append(toIndentedString(created)).append("\n");
    sb.append("    modified: ").append(toIndentedString(modified)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
