/*
 * Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2019-Present Datadog, Inc.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.datadog.api.v2.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/** Incident Service data from responses. */
@ApiModel(description = "Incident Service data from responses.")
@JsonPropertyOrder({
  IncidentServiceResponseData.JSON_PROPERTY_ATTRIBUTES,
  IncidentServiceResponseData.JSON_PROPERTY_ID,
  IncidentServiceResponseData.JSON_PROPERTY_RELATIONSHIPS,
  IncidentServiceResponseData.JSON_PROPERTY_TYPE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class IncidentServiceResponseData {
  public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
  private IncidentServiceResponseAttributes attributes;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_RELATIONSHIPS = "relationships";
  private IncidentServiceRelationships relationships;

  public static final String JSON_PROPERTY_TYPE = "type";
  private IncidentServiceType type = IncidentServiceType.SERVICES;

  public IncidentServiceResponseData() {}

  @JsonCreator
  public IncidentServiceResponseData(
      @JsonProperty(required = true, value = JSON_PROPERTY_ID) String id,
      @JsonProperty(required = true, value = JSON_PROPERTY_TYPE) IncidentServiceType type) {
    this.id = id;
    this.type = type;
  }

  public IncidentServiceResponseData attributes(IncidentServiceResponseAttributes attributes) {
    this.attributes = attributes;
    return this;
  }

  /**
   * Get attributes
   *
   * @return attributes
   */
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ATTRIBUTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public IncidentServiceResponseAttributes getAttributes() {
    return attributes;
  }

  public void setAttributes(IncidentServiceResponseAttributes attributes) {
    this.attributes = attributes;
  }

  public IncidentServiceResponseData id(String id) {
    this.id = id;
    return this;
  }

  /**
   * The incident service&#39;s ID.
   *
   * @return id
   */
  @ApiModelProperty(
      example = "00000000-0000-0000-0000-000000000000",
      required = true,
      value = "The incident service's ID.")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public IncidentServiceResponseData relationships(IncidentServiceRelationships relationships) {
    this.relationships = relationships;
    return this;
  }

  /**
   * Get relationships
   *
   * @return relationships
   */
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RELATIONSHIPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public IncidentServiceRelationships getRelationships() {
    return relationships;
  }

  public void setRelationships(IncidentServiceRelationships relationships) {
    this.relationships = relationships;
  }

  public IncidentServiceResponseData type(IncidentServiceType type) {
    this.type = type;
    return this;
  }

  /**
   * Get type
   *
   * @return type
   */
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public IncidentServiceType getType() {
    return type;
  }

  public void setType(IncidentServiceType type) {
    this.type = type;
  }

  /** Return true if this IncidentServiceResponseData object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    IncidentServiceResponseData incidentServiceResponseData = (IncidentServiceResponseData) o;
    return Objects.equals(this.attributes, incidentServiceResponseData.attributes)
        && Objects.equals(this.id, incidentServiceResponseData.id)
        && Objects.equals(this.relationships, incidentServiceResponseData.relationships)
        && Objects.equals(this.type, incidentServiceResponseData.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(attributes, id, relationships, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IncidentServiceResponseData {\n");
    sb.append("    attributes: ").append(toIndentedString(attributes)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    relationships: ").append(toIndentedString(relationships)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
