/*
 * Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2019-Present Datadog, Inc.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.datadog.api.v2.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/** Pagination properties. */
@ApiModel(description = "Pagination properties.")
@JsonPropertyOrder({
  IncidentServicesResponseMetaPagination.JSON_PROPERTY_NEXT_OFFSET,
  IncidentServicesResponseMetaPagination.JSON_PROPERTY_OFFSET,
  IncidentServicesResponseMetaPagination.JSON_PROPERTY_SIZE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class IncidentServicesResponseMetaPagination {
  public static final String JSON_PROPERTY_NEXT_OFFSET = "next_offset";
  private Long nextOffset;

  public static final String JSON_PROPERTY_OFFSET = "offset";
  private Long offset;

  public static final String JSON_PROPERTY_SIZE = "size";
  private Long size;

  public IncidentServicesResponseMetaPagination nextOffset(Long nextOffset) {
    this.nextOffset = nextOffset;
    return this;
  }

  /**
   * The index of the first element in the next page of results. Equal to page size added to the
   * current offset.
   *
   * @return nextOffset
   */
  @javax.annotation.Nullable
  @ApiModelProperty(
      example = "1000",
      value =
          "The index of the first element in the next page of results. Equal to page size added to"
              + " the current offset.")
  @JsonProperty(JSON_PROPERTY_NEXT_OFFSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Long getNextOffset() {
    return nextOffset;
  }

  public void setNextOffset(Long nextOffset) {
    this.nextOffset = nextOffset;
  }

  public IncidentServicesResponseMetaPagination offset(Long offset) {
    this.offset = offset;
    return this;
  }

  /**
   * The index of the first element in the results.
   *
   * @return offset
   */
  @javax.annotation.Nullable
  @ApiModelProperty(example = "10", value = "The index of the first element in the results.")
  @JsonProperty(JSON_PROPERTY_OFFSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Long getOffset() {
    return offset;
  }

  public void setOffset(Long offset) {
    this.offset = offset;
  }

  public IncidentServicesResponseMetaPagination size(Long size) {
    this.size = size;
    return this;
  }

  /**
   * Maximum size of pages to return.
   *
   * @return size
   */
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1000", value = "Maximum size of pages to return.")
  @JsonProperty(JSON_PROPERTY_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Long getSize() {
    return size;
  }

  public void setSize(Long size) {
    this.size = size;
  }

  /** Return true if this IncidentServicesResponse_meta_pagination object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    IncidentServicesResponseMetaPagination incidentServicesResponseMetaPagination =
        (IncidentServicesResponseMetaPagination) o;
    return Objects.equals(this.nextOffset, incidentServicesResponseMetaPagination.nextOffset)
        && Objects.equals(this.offset, incidentServicesResponseMetaPagination.offset)
        && Objects.equals(this.size, incidentServicesResponseMetaPagination.size);
  }

  @Override
  public int hashCode() {
    return Objects.hash(nextOffset, offset, size);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IncidentServicesResponseMetaPagination {\n");
    sb.append("    nextOffset: ").append(toIndentedString(nextOffset)).append("\n");
    sb.append("    offset: ").append(toIndentedString(offset)).append("\n");
    sb.append("    size: ").append(toIndentedString(size)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
