/*
 * Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2019-Present Datadog, Inc.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.datadog.api.v2.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/** Incident data for an update request. */
@ApiModel(description = "Incident data for an update request.")
@JsonPropertyOrder({
  IncidentUpdateData.JSON_PROPERTY_ATTRIBUTES,
  IncidentUpdateData.JSON_PROPERTY_ID,
  IncidentUpdateData.JSON_PROPERTY_RELATIONSHIPS,
  IncidentUpdateData.JSON_PROPERTY_TYPE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class IncidentUpdateData {
  public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
  private IncidentUpdateAttributes attributes;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_RELATIONSHIPS = "relationships";
  private IncidentUpdateRelationships relationships;

  public static final String JSON_PROPERTY_TYPE = "type";
  private IncidentType type = IncidentType.INCIDENTS;

  public IncidentUpdateData() {}

  @JsonCreator
  public IncidentUpdateData(
      @JsonProperty(required = true, value = JSON_PROPERTY_ID) String id,
      @JsonProperty(required = true, value = JSON_PROPERTY_TYPE) IncidentType type) {
    this.id = id;
    this.type = type;
  }

  public IncidentUpdateData attributes(IncidentUpdateAttributes attributes) {
    this.attributes = attributes;
    return this;
  }

  /**
   * Get attributes
   *
   * @return attributes
   */
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ATTRIBUTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public IncidentUpdateAttributes getAttributes() {
    return attributes;
  }

  public void setAttributes(IncidentUpdateAttributes attributes) {
    this.attributes = attributes;
  }

  public IncidentUpdateData id(String id) {
    this.id = id;
    return this;
  }

  /**
   * The team&#39;s ID.
   *
   * @return id
   */
  @ApiModelProperty(
      example = "00000000-0000-0000-0000-000000000000",
      required = true,
      value = "The team's ID.")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public IncidentUpdateData relationships(IncidentUpdateRelationships relationships) {
    this.relationships = relationships;
    return this;
  }

  /**
   * Get relationships
   *
   * @return relationships
   */
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RELATIONSHIPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public IncidentUpdateRelationships getRelationships() {
    return relationships;
  }

  public void setRelationships(IncidentUpdateRelationships relationships) {
    this.relationships = relationships;
  }

  public IncidentUpdateData type(IncidentType type) {
    this.type = type;
    return this;
  }

  /**
   * Get type
   *
   * @return type
   */
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public IncidentType getType() {
    return type;
  }

  public void setType(IncidentType type) {
    this.type = type;
  }

  /** Return true if this IncidentUpdateData object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    IncidentUpdateData incidentUpdateData = (IncidentUpdateData) o;
    return Objects.equals(this.attributes, incidentUpdateData.attributes)
        && Objects.equals(this.id, incidentUpdateData.id)
        && Objects.equals(this.relationships, incidentUpdateData.relationships)
        && Objects.equals(this.type, incidentUpdateData.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(attributes, id, relationships, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IncidentUpdateData {\n");
    sb.append("    attributes: ").append(toIndentedString(attributes)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    relationships: ").append(toIndentedString(relationships)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
