/*
 * Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2019-Present Datadog, Inc.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.datadog.api.v2.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/** The Azure archive destination. */
@ApiModel(description = "The Azure archive destination.")
@JsonPropertyOrder({
  LogsArchiveDestinationAzure.JSON_PROPERTY_CONTAINER,
  LogsArchiveDestinationAzure.JSON_PROPERTY_INTEGRATION,
  LogsArchiveDestinationAzure.JSON_PROPERTY_PATH,
  LogsArchiveDestinationAzure.JSON_PROPERTY_REGION,
  LogsArchiveDestinationAzure.JSON_PROPERTY_STORAGE_ACCOUNT,
  LogsArchiveDestinationAzure.JSON_PROPERTY_TYPE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class LogsArchiveDestinationAzure {
  public static final String JSON_PROPERTY_CONTAINER = "container";
  private String container;

  public static final String JSON_PROPERTY_INTEGRATION = "integration";
  private LogsArchiveIntegrationAzure integration;

  public static final String JSON_PROPERTY_PATH = "path";
  private String path;

  public static final String JSON_PROPERTY_REGION = "region";
  private String region;

  public static final String JSON_PROPERTY_STORAGE_ACCOUNT = "storage_account";
  private String storageAccount;

  public static final String JSON_PROPERTY_TYPE = "type";
  private LogsArchiveDestinationAzureType type = LogsArchiveDestinationAzureType.AZURE;

  public LogsArchiveDestinationAzure() {}

  @JsonCreator
  public LogsArchiveDestinationAzure(
      @JsonProperty(required = true, value = JSON_PROPERTY_CONTAINER) String container,
      @JsonProperty(required = true, value = JSON_PROPERTY_INTEGRATION)
          LogsArchiveIntegrationAzure integration,
      @JsonProperty(required = true, value = JSON_PROPERTY_STORAGE_ACCOUNT) String storageAccount,
      @JsonProperty(required = true, value = JSON_PROPERTY_TYPE)
          LogsArchiveDestinationAzureType type) {
    this.container = container;
    this.integration = integration;
    this.storageAccount = storageAccount;
    this.type = type;
  }

  public LogsArchiveDestinationAzure container(String container) {
    this.container = container;
    return this;
  }

  /**
   * The container where the archive will be stored.
   *
   * @return container
   */
  @ApiModelProperty(
      example = "container-name",
      required = true,
      value = "The container where the archive will be stored.")
  @JsonProperty(JSON_PROPERTY_CONTAINER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getContainer() {
    return container;
  }

  public void setContainer(String container) {
    this.container = container;
  }

  public LogsArchiveDestinationAzure integration(LogsArchiveIntegrationAzure integration) {
    this.integration = integration;
    return this;
  }

  /**
   * Get integration
   *
   * @return integration
   */
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_INTEGRATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public LogsArchiveIntegrationAzure getIntegration() {
    return integration;
  }

  public void setIntegration(LogsArchiveIntegrationAzure integration) {
    this.integration = integration;
  }

  public LogsArchiveDestinationAzure path(String path) {
    this.path = path;
    return this;
  }

  /**
   * The archive path.
   *
   * @return path
   */
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The archive path.")
  @JsonProperty(JSON_PROPERTY_PATH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPath() {
    return path;
  }

  public void setPath(String path) {
    this.path = path;
  }

  public LogsArchiveDestinationAzure region(String region) {
    this.region = region;
    return this;
  }

  /**
   * The region where the archive will be stored.
   *
   * @return region
   */
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The region where the archive will be stored.")
  @JsonProperty(JSON_PROPERTY_REGION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getRegion() {
    return region;
  }

  public void setRegion(String region) {
    this.region = region;
  }

  public LogsArchiveDestinationAzure storageAccount(String storageAccount) {
    this.storageAccount = storageAccount;
    return this;
  }

  /**
   * The associated storage account.
   *
   * @return storageAccount
   */
  @ApiModelProperty(
      example = "account-name",
      required = true,
      value = "The associated storage account.")
  @JsonProperty(JSON_PROPERTY_STORAGE_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getStorageAccount() {
    return storageAccount;
  }

  public void setStorageAccount(String storageAccount) {
    this.storageAccount = storageAccount;
  }

  public LogsArchiveDestinationAzure type(LogsArchiveDestinationAzureType type) {
    this.type = type;
    return this;
  }

  /**
   * Get type
   *
   * @return type
   */
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public LogsArchiveDestinationAzureType getType() {
    return type;
  }

  public void setType(LogsArchiveDestinationAzureType type) {
    this.type = type;
  }

  /** Return true if this LogsArchiveDestinationAzure object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LogsArchiveDestinationAzure logsArchiveDestinationAzure = (LogsArchiveDestinationAzure) o;
    return Objects.equals(this.container, logsArchiveDestinationAzure.container)
        && Objects.equals(this.integration, logsArchiveDestinationAzure.integration)
        && Objects.equals(this.path, logsArchiveDestinationAzure.path)
        && Objects.equals(this.region, logsArchiveDestinationAzure.region)
        && Objects.equals(this.storageAccount, logsArchiveDestinationAzure.storageAccount)
        && Objects.equals(this.type, logsArchiveDestinationAzure.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(container, integration, path, region, storageAccount, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LogsArchiveDestinationAzure {\n");
    sb.append("    container: ").append(toIndentedString(container)).append("\n");
    sb.append("    integration: ").append(toIndentedString(integration)).append("\n");
    sb.append("    path: ").append(toIndentedString(path)).append("\n");
    sb.append("    region: ").append(toIndentedString(region)).append("\n");
    sb.append("    storageAccount: ").append(toIndentedString(storageAccount)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
