/*
 * Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2019-Present Datadog, Inc.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.datadog.api.v2.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/** The compute rule to compute the log-based metric. */
@ApiModel(description = "The compute rule to compute the log-based metric.")
@JsonPropertyOrder({
  LogsMetricResponseCompute.JSON_PROPERTY_AGGREGATION_TYPE,
  LogsMetricResponseCompute.JSON_PROPERTY_PATH
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class LogsMetricResponseCompute {
  public static final String JSON_PROPERTY_AGGREGATION_TYPE = "aggregation_type";
  private LogsMetricResponseComputeAggregationType aggregationType;

  public static final String JSON_PROPERTY_PATH = "path";
  private String path;

  public LogsMetricResponseCompute aggregationType(
      LogsMetricResponseComputeAggregationType aggregationType) {
    this.aggregationType = aggregationType;
    return this;
  }

  /**
   * Get aggregationType
   *
   * @return aggregationType
   */
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_AGGREGATION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public LogsMetricResponseComputeAggregationType getAggregationType() {
    return aggregationType;
  }

  public void setAggregationType(LogsMetricResponseComputeAggregationType aggregationType) {
    this.aggregationType = aggregationType;
  }

  public LogsMetricResponseCompute path(String path) {
    this.path = path;
    return this;
  }

  /**
   * The path to the value the log-based metric will aggregate on (only used if the aggregation type
   * is a \&quot;distribution\&quot;).
   *
   * @return path
   */
  @javax.annotation.Nullable
  @ApiModelProperty(
      example = "@duration",
      value =
          "The path to the value the log-based metric will aggregate on (only used if the"
              + " aggregation type is a \"distribution\").")
  @JsonProperty(JSON_PROPERTY_PATH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPath() {
    return path;
  }

  public void setPath(String path) {
    this.path = path;
  }

  /** Return true if this LogsMetricResponseCompute object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LogsMetricResponseCompute logsMetricResponseCompute = (LogsMetricResponseCompute) o;
    return Objects.equals(this.aggregationType, logsMetricResponseCompute.aggregationType)
        && Objects.equals(this.path, logsMetricResponseCompute.path);
  }

  @Override
  public int hashCode() {
    return Objects.hash(aggregationType, path);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LogsMetricResponseCompute {\n");
    sb.append("    aggregationType: ").append(toIndentedString(aggregationType)).append("\n");
    sb.append("    path: ").append(toIndentedString(path)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
