/*
 * Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2019-Present Datadog, Inc.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.datadog.api.v2.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** Object containing the definition of a metric tag configuration attributes. */
@ApiModel(
    description = "Object containing the definition of a metric tag configuration attributes.")
@JsonPropertyOrder({
  MetricTagConfigurationAttributes.JSON_PROPERTY_CREATED_AT,
  MetricTagConfigurationAttributes.JSON_PROPERTY_INCLUDE_PERCENTILES,
  MetricTagConfigurationAttributes.JSON_PROPERTY_METRIC_TYPE,
  MetricTagConfigurationAttributes.JSON_PROPERTY_MODIFIED_AT,
  MetricTagConfigurationAttributes.JSON_PROPERTY_TAGS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class MetricTagConfigurationAttributes {
  public static final String JSON_PROPERTY_CREATED_AT = "created_at";
  private OffsetDateTime createdAt;

  public static final String JSON_PROPERTY_INCLUDE_PERCENTILES = "include_percentiles";
  private Boolean includePercentiles;

  public static final String JSON_PROPERTY_METRIC_TYPE = "metric_type";
  private MetricTagConfigurationMetricTypes metricType = MetricTagConfigurationMetricTypes.GAUGE;

  public static final String JSON_PROPERTY_MODIFIED_AT = "modified_at";
  private OffsetDateTime modifiedAt;

  public static final String JSON_PROPERTY_TAGS = "tags";
  private List<String> tags = null;

  public MetricTagConfigurationAttributes createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

  /**
   * Timestamp when the tag configuration was created.
   *
   * @return createdAt
   */
  @javax.annotation.Nullable
  @ApiModelProperty(
      example = "2020-03-31T09:48:37.463835Z",
      value = "Timestamp when the tag configuration was created.")
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public MetricTagConfigurationAttributes includePercentiles(Boolean includePercentiles) {
    this.includePercentiles = includePercentiles;
    return this;
  }

  /**
   * Toggle to turn on/off percentile aggregations for distribution metrics. Only present when the
   * &#x60;metric_type&#x60; is &#x60;distribution&#x60;.
   *
   * @return includePercentiles
   */
  @javax.annotation.Nullable
  @ApiModelProperty(
      example = "true",
      value =
          "Toggle to turn on/off percentile aggregations for distribution metrics. Only present"
              + " when the `metric_type` is `distribution`.")
  @JsonProperty(JSON_PROPERTY_INCLUDE_PERCENTILES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getIncludePercentiles() {
    return includePercentiles;
  }

  public void setIncludePercentiles(Boolean includePercentiles) {
    this.includePercentiles = includePercentiles;
  }

  public MetricTagConfigurationAttributes metricType(MetricTagConfigurationMetricTypes metricType) {
    this.metricType = metricType;
    return this;
  }

  /**
   * Get metricType
   *
   * @return metricType
   */
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_METRIC_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public MetricTagConfigurationMetricTypes getMetricType() {
    return metricType;
  }

  public void setMetricType(MetricTagConfigurationMetricTypes metricType) {
    this.metricType = metricType;
  }

  public MetricTagConfigurationAttributes modifiedAt(OffsetDateTime modifiedAt) {
    this.modifiedAt = modifiedAt;
    return this;
  }

  /**
   * Timestamp when the tag configuration was last modified.
   *
   * @return modifiedAt
   */
  @javax.annotation.Nullable
  @ApiModelProperty(
      example = "2020-03-31T09:48:37.463835Z",
      value = "Timestamp when the tag configuration was last modified.")
  @JsonProperty(JSON_PROPERTY_MODIFIED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getModifiedAt() {
    return modifiedAt;
  }

  public void setModifiedAt(OffsetDateTime modifiedAt) {
    this.modifiedAt = modifiedAt;
  }

  public MetricTagConfigurationAttributes tags(List<String> tags) {
    this.tags = tags;
    return this;
  }

  public MetricTagConfigurationAttributes addTagsItem(String tagsItem) {
    if (this.tags == null) {
      this.tags = new ArrayList<>();
    }
    this.tags.add(tagsItem);
    return this;
  }

  /**
   * List of tag keys on which to group.
   *
   * @return tags
   */
  @javax.annotation.Nullable
  @ApiModelProperty(
      example = "[\"app\",\"datacenter\"]",
      value = "List of tag keys on which to group.")
  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getTags() {
    return tags;
  }

  public void setTags(List<String> tags) {
    this.tags = tags;
  }

  /** Return true if this MetricTagConfigurationAttributes object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MetricTagConfigurationAttributes metricTagConfigurationAttributes =
        (MetricTagConfigurationAttributes) o;
    return Objects.equals(this.createdAt, metricTagConfigurationAttributes.createdAt)
        && Objects.equals(
            this.includePercentiles, metricTagConfigurationAttributes.includePercentiles)
        && Objects.equals(this.metricType, metricTagConfigurationAttributes.metricType)
        && Objects.equals(this.modifiedAt, metricTagConfigurationAttributes.modifiedAt)
        && Objects.equals(this.tags, metricTagConfigurationAttributes.tags);
  }

  @Override
  public int hashCode() {
    return Objects.hash(createdAt, includePercentiles, metricType, modifiedAt, tags);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MetricTagConfigurationAttributes {\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    includePercentiles: ").append(toIndentedString(includePercentiles)).append("\n");
    sb.append("    metricType: ").append(toIndentedString(metricType)).append("\n");
    sb.append("    modifiedAt: ").append(toIndentedString(modifiedAt)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
