/*
 * Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2019-Present Datadog, Inc.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.datadog.api.v2.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** Relationship to users. */
@ApiModel(description = "Relationship to users.")
@JsonPropertyOrder({RelationshipToUsers.JSON_PROPERTY_DATA})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class RelationshipToUsers {
  public static final String JSON_PROPERTY_DATA = "data";
  private List<RelationshipToUserData> data = new ArrayList<>();

  public RelationshipToUsers() {}

  @JsonCreator
  public RelationshipToUsers(
      @JsonProperty(required = true, value = JSON_PROPERTY_DATA)
          List<RelationshipToUserData> data) {
    this.data = data;
  }

  public RelationshipToUsers data(List<RelationshipToUserData> data) {
    this.data = data;
    return this;
  }

  public RelationshipToUsers addDataItem(RelationshipToUserData dataItem) {
    this.data.add(dataItem);
    return this;
  }

  /**
   * Relationships to user objects.
   *
   * @return data
   */
  @ApiModelProperty(example = "[]", required = true, value = "Relationships to user objects.")
  @JsonProperty(JSON_PROPERTY_DATA)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public List<RelationshipToUserData> getData() {
    return data;
  }

  public void setData(List<RelationshipToUserData> data) {
    this.data = data;
  }

  /** Return true if this RelationshipToUsers object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RelationshipToUsers relationshipToUsers = (RelationshipToUsers) o;
    return Objects.equals(this.data, relationshipToUsers.data);
  }

  @Override
  public int hashCode() {
    return Objects.hash(data);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RelationshipToUsers {\n");
    sb.append("    data: ").append(toIndentedString(data)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
