/*
 * Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2019-Present Datadog, Inc.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.datadog.api.v2.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/** Optional metadata associated to the response. */
@ApiModel(description = "Optional metadata associated to the response.")
@JsonPropertyOrder({SecurityFilterMeta.JSON_PROPERTY_WARNING})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class SecurityFilterMeta {
  public static final String JSON_PROPERTY_WARNING = "warning";
  private String warning;

  public SecurityFilterMeta warning(String warning) {
    this.warning = warning;
    return this;
  }

  /**
   * A warning message.
   *
   * @return warning
   */
  @javax.annotation.Nullable
  @ApiModelProperty(
      example = "All the security filters are disabled. As a result, no logs are being analyzed.",
      value = "A warning message.")
  @JsonProperty(JSON_PROPERTY_WARNING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getWarning() {
    return warning;
  }

  public void setWarning(String warning) {
    this.warning = warning;
  }

  /** Return true if this SecurityFilterMeta object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SecurityFilterMeta securityFilterMeta = (SecurityFilterMeta) o;
    return Objects.equals(this.warning, securityFilterMeta.warning);
  }

  @Override
  public int hashCode() {
    return Objects.hash(warning);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SecurityFilterMeta {\n");
    sb.append("    warning: ").append(toIndentedString(warning)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
