/*
 * Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2019-Present Datadog, Inc.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.datadog.api.v2.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** The security filters properties to be updated. */
@ApiModel(description = "The security filters properties to be updated.")
@JsonPropertyOrder({
  SecurityFilterUpdateAttributes.JSON_PROPERTY_EXCLUSION_FILTERS,
  SecurityFilterUpdateAttributes.JSON_PROPERTY_FILTERED_DATA_TYPE,
  SecurityFilterUpdateAttributes.JSON_PROPERTY_IS_ENABLED,
  SecurityFilterUpdateAttributes.JSON_PROPERTY_NAME,
  SecurityFilterUpdateAttributes.JSON_PROPERTY_QUERY,
  SecurityFilterUpdateAttributes.JSON_PROPERTY_VERSION
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class SecurityFilterUpdateAttributes {
  public static final String JSON_PROPERTY_EXCLUSION_FILTERS = "exclusion_filters";
  private List<SecurityFilterExclusionFilter> exclusionFilters = null;

  public static final String JSON_PROPERTY_FILTERED_DATA_TYPE = "filtered_data_type";
  private SecurityFilterFilteredDataType filteredDataType;

  public static final String JSON_PROPERTY_IS_ENABLED = "is_enabled";
  private Boolean isEnabled;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_QUERY = "query";
  private String query;

  public static final String JSON_PROPERTY_VERSION = "version";
  private Integer version;

  public SecurityFilterUpdateAttributes exclusionFilters(
      List<SecurityFilterExclusionFilter> exclusionFilters) {
    this.exclusionFilters = exclusionFilters;
    return this;
  }

  public SecurityFilterUpdateAttributes addExclusionFiltersItem(
      SecurityFilterExclusionFilter exclusionFiltersItem) {
    if (this.exclusionFilters == null) {
      this.exclusionFilters = new ArrayList<>();
    }
    this.exclusionFilters.add(exclusionFiltersItem);
    return this;
  }

  /**
   * Exclusion filters to exclude some logs from the security filter.
   *
   * @return exclusionFilters
   */
  @javax.annotation.Nullable
  @ApiModelProperty(
      example = "[]",
      value = "Exclusion filters to exclude some logs from the security filter.")
  @JsonProperty(JSON_PROPERTY_EXCLUSION_FILTERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<SecurityFilterExclusionFilter> getExclusionFilters() {
    return exclusionFilters;
  }

  public void setExclusionFilters(List<SecurityFilterExclusionFilter> exclusionFilters) {
    this.exclusionFilters = exclusionFilters;
  }

  public SecurityFilterUpdateAttributes filteredDataType(
      SecurityFilterFilteredDataType filteredDataType) {
    this.filteredDataType = filteredDataType;
    return this;
  }

  /**
   * Get filteredDataType
   *
   * @return filteredDataType
   */
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FILTERED_DATA_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public SecurityFilterFilteredDataType getFilteredDataType() {
    return filteredDataType;
  }

  public void setFilteredDataType(SecurityFilterFilteredDataType filteredDataType) {
    this.filteredDataType = filteredDataType;
  }

  public SecurityFilterUpdateAttributes isEnabled(Boolean isEnabled) {
    this.isEnabled = isEnabled;
    return this;
  }

  /**
   * Whether the security filter is enabled.
   *
   * @return isEnabled
   */
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Whether the security filter is enabled.")
  @JsonProperty(JSON_PROPERTY_IS_ENABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getIsEnabled() {
    return isEnabled;
  }

  public void setIsEnabled(Boolean isEnabled) {
    this.isEnabled = isEnabled;
  }

  public SecurityFilterUpdateAttributes name(String name) {
    this.name = name;
    return this;
  }

  /**
   * The name of the security filter.
   *
   * @return name
   */
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Custom security filter", value = "The name of the security filter.")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public SecurityFilterUpdateAttributes query(String query) {
    this.query = query;
    return this;
  }

  /**
   * The query of the security filter.
   *
   * @return query
   */
  @javax.annotation.Nullable
  @ApiModelProperty(example = "service:api", value = "The query of the security filter.")
  @JsonProperty(JSON_PROPERTY_QUERY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getQuery() {
    return query;
  }

  public void setQuery(String query) {
    this.query = query;
  }

  public SecurityFilterUpdateAttributes version(Integer version) {
    this.version = version;
    return this;
  }

  /**
   * The version of the security filter to update. maximum: 2147483647
   *
   * @return version
   */
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1", value = "The version of the security filter to update.")
  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getVersion() {
    return version;
  }

  public void setVersion(Integer version) {
    this.version = version;
  }

  /** Return true if this SecurityFilterUpdateAttributes object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SecurityFilterUpdateAttributes securityFilterUpdateAttributes =
        (SecurityFilterUpdateAttributes) o;
    return Objects.equals(this.exclusionFilters, securityFilterUpdateAttributes.exclusionFilters)
        && Objects.equals(this.filteredDataType, securityFilterUpdateAttributes.filteredDataType)
        && Objects.equals(this.isEnabled, securityFilterUpdateAttributes.isEnabled)
        && Objects.equals(this.name, securityFilterUpdateAttributes.name)
        && Objects.equals(this.query, securityFilterUpdateAttributes.query)
        && Objects.equals(this.version, securityFilterUpdateAttributes.version);
  }

  @Override
  public int hashCode() {
    return Objects.hash(exclusionFilters, filteredDataType, isEnabled, name, query, version);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SecurityFilterUpdateAttributes {\n");
    sb.append("    exclusionFilters: ").append(toIndentedString(exclusionFilters)).append("\n");
    sb.append("    filteredDataType: ").append(toIndentedString(filteredDataType)).append("\n");
    sb.append("    isEnabled: ").append(toIndentedString(isEnabled)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    query: ").append(toIndentedString(query)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
