/*
 * Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2019-Present Datadog, Inc.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.datadog.api.v2.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * A time window is specified to match when at least one of the cases matches true. This is a
 * sliding window and evaluates in real time.
 */
public enum SecurityMonitoringRuleEvaluationWindow {
  ZERO_MINUTES(0),

  ONE_MINUTE(60),

  FIVE_MINUTES(300),

  TEN_MINUTES(600),

  FIFTEEN_MINUTES(900),

  THIRTY_MINUTES(1800),

  ONE_HOUR(3600),

  TWO_HOURS(7200);

  private Integer value;

  SecurityMonitoringRuleEvaluationWindow(Integer value) {
    this.value = value;
  }

  @JsonValue
  public Integer getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static SecurityMonitoringRuleEvaluationWindow fromValue(Integer value) {
    for (SecurityMonitoringRuleEvaluationWindow b :
        SecurityMonitoringRuleEvaluationWindow.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}
