/*
 * Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2019-Present Datadog, Inc.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.datadog.api.v2.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * A signal will “close” regardless of the query being matched once the time exceeds the maximum
 * duration. This time is calculated from the first seen timestamp.
 */
public enum SecurityMonitoringRuleMaxSignalDuration {
  ZERO_MINUTES(0),

  ONE_MINUTE(60),

  FIVE_MINUTES(300),

  TEN_MINUTES(600),

  FIFTEEN_MINUTES(900),

  THIRTY_MINUTES(1800),

  ONE_HOUR(3600),

  TWO_HOURS(7200),

  THREE_HOURS(10800),

  SIX_HOURS(21600),

  TWELVE_HOURS(43200),

  ONE_DAY(86400);

  private Integer value;

  SecurityMonitoringRuleMaxSignalDuration(Integer value) {
    this.value = value;
  }

  @JsonValue
  public Integer getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static SecurityMonitoringRuleMaxSignalDuration fromValue(Integer value) {
    for (SecurityMonitoringRuleMaxSignalDuration b :
        SecurityMonitoringRuleMaxSignalDuration.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}
