/*
 * Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2019-Present Datadog, Inc.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.datadog.api.v2.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * The duration in days during which values are learned, and after which signals will be generated
 * for values that weren&#39;t learned. If set to 0, a signal will be generated for all new values
 * after the first value is learned.
 */
public enum SecurityMonitoringRuleNewValueOptionsLearningDuration {
  ZERO_DAYS(0),

  ONE_DAY(1),

  SEVEN_DAYS(7);

  private Integer value;

  SecurityMonitoringRuleNewValueOptionsLearningDuration(Integer value) {
    this.value = value;
  }

  @JsonValue
  public Integer getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static SecurityMonitoringRuleNewValueOptionsLearningDuration fromValue(Integer value) {
    for (SecurityMonitoringRuleNewValueOptionsLearningDuration b :
        SecurityMonitoringRuleNewValueOptionsLearningDuration.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}
