/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.QueryValueWidgetDefinitionType;
import com.datadog.api.v1.client.model.QueryValueWidgetRequest;
import com.datadog.api.v1.client.model.WidgetCustomLink;
import com.datadog.api.v1.client.model.WidgetTextAlign;
import com.datadog.api.v1.client.model.WidgetTime;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Query values display the current value of a given metric, APM, or log query.")
@JsonPropertyOrder(value={"autoscale", "custom_links", "custom_unit", "precision", "requests", "text_align", "time", "title", "title_align", "title_size", "type"})
public class QueryValueWidgetDefinition {
    public static final String JSON_PROPERTY_AUTOSCALE = "autoscale";
    private Boolean autoscale;
    public static final String JSON_PROPERTY_CUSTOM_LINKS = "custom_links";
    private List<WidgetCustomLink> customLinks = null;
    public static final String JSON_PROPERTY_CUSTOM_UNIT = "custom_unit";
    private String customUnit;
    public static final String JSON_PROPERTY_PRECISION = "precision";
    private Long precision;
    public static final String JSON_PROPERTY_REQUESTS = "requests";
    private List<QueryValueWidgetRequest> requests = new ArrayList<QueryValueWidgetRequest>();
    public static final String JSON_PROPERTY_TEXT_ALIGN = "text_align";
    private WidgetTextAlign textAlign;
    public static final String JSON_PROPERTY_TIME = "time";
    private WidgetTime time;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    public static final String JSON_PROPERTY_TITLE_ALIGN = "title_align";
    private WidgetTextAlign titleAlign;
    public static final String JSON_PROPERTY_TITLE_SIZE = "title_size";
    private String titleSize;
    public static final String JSON_PROPERTY_TYPE = "type";
    private QueryValueWidgetDefinitionType type = QueryValueWidgetDefinitionType.QUERY_VALUE;

    public QueryValueWidgetDefinition() {
    }

    @JsonCreator
    public QueryValueWidgetDefinition(@JsonProperty(required=true, value="requests") List<QueryValueWidgetRequest> requests, @JsonProperty(required=true, value="type") QueryValueWidgetDefinitionType type) {
        this.requests = requests;
        this.type = type;
    }

    public QueryValueWidgetDefinition autoscale(Boolean autoscale) {
        this.autoscale = autoscale;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether to use auto-scaling or not.")
    @JsonProperty(value="autoscale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAutoscale() {
        return this.autoscale;
    }

    public void setAutoscale(Boolean autoscale) {
        this.autoscale = autoscale;
    }

    public QueryValueWidgetDefinition customLinks(List<WidgetCustomLink> customLinks) {
        this.customLinks = customLinks;
        return this;
    }

    public QueryValueWidgetDefinition addCustomLinksItem(WidgetCustomLink customLinksItem) {
        if (this.customLinks == null) {
            this.customLinks = new ArrayList<WidgetCustomLink>();
        }
        this.customLinks.add(customLinksItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of custom links.")
    @JsonProperty(value="custom_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<WidgetCustomLink> getCustomLinks() {
        return this.customLinks;
    }

    public void setCustomLinks(List<WidgetCustomLink> customLinks) {
        this.customLinks = customLinks;
    }

    public QueryValueWidgetDefinition customUnit(String customUnit) {
        this.customUnit = customUnit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Display a unit of your choice on the widget.")
    @JsonProperty(value="custom_unit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCustomUnit() {
        return this.customUnit;
    }

    public void setCustomUnit(String customUnit) {
        this.customUnit = customUnit;
    }

    public QueryValueWidgetDefinition precision(Long precision) {
        this.precision = precision;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of decimals to show. If not defined, the widget uses the raw value.")
    @JsonProperty(value="precision")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getPrecision() {
        return this.precision;
    }

    public void setPrecision(Long precision) {
        this.precision = precision;
    }

    public QueryValueWidgetDefinition requests(List<QueryValueWidgetRequest> requests) {
        this.requests = requests;
        return this;
    }

    public QueryValueWidgetDefinition addRequestsItem(QueryValueWidgetRequest requestsItem) {
        this.requests.add(requestsItem);
        return this;
    }

    @ApiModelProperty(example="[{\"q/apm_query/log_query\":\"<METRIC_1>{<SCOPE_1>}\"}]", required=true, value="Widget definition.")
    @JsonProperty(value="requests")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<QueryValueWidgetRequest> getRequests() {
        return this.requests;
    }

    public void setRequests(List<QueryValueWidgetRequest> requests) {
        this.requests = requests;
    }

    public QueryValueWidgetDefinition textAlign(WidgetTextAlign textAlign) {
        this.textAlign = textAlign;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="text_align")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTextAlign getTextAlign() {
        return this.textAlign;
    }

    public void setTextAlign(WidgetTextAlign textAlign) {
        this.textAlign = textAlign;
    }

    public QueryValueWidgetDefinition time(WidgetTime time) {
        this.time = time;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="time")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTime getTime() {
        return this.time;
    }

    public void setTime(WidgetTime time) {
        this.time = time;
    }

    public QueryValueWidgetDefinition title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Title of your widget.")
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public QueryValueWidgetDefinition titleAlign(WidgetTextAlign titleAlign) {
        this.titleAlign = titleAlign;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="title_align")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTextAlign getTitleAlign() {
        return this.titleAlign;
    }

    public void setTitleAlign(WidgetTextAlign titleAlign) {
        this.titleAlign = titleAlign;
    }

    public QueryValueWidgetDefinition titleSize(String titleSize) {
        this.titleSize = titleSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Size of the title.")
    @JsonProperty(value="title_size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitleSize() {
        return this.titleSize;
    }

    public void setTitleSize(String titleSize) {
        this.titleSize = titleSize;
    }

    public QueryValueWidgetDefinition type(QueryValueWidgetDefinitionType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public QueryValueWidgetDefinitionType getType() {
        return this.type;
    }

    public void setType(QueryValueWidgetDefinitionType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryValueWidgetDefinition queryValueWidgetDefinition = (QueryValueWidgetDefinition)o;
        return Objects.equals(this.autoscale, queryValueWidgetDefinition.autoscale) && Objects.equals(this.customLinks, queryValueWidgetDefinition.customLinks) && Objects.equals(this.customUnit, queryValueWidgetDefinition.customUnit) && Objects.equals(this.precision, queryValueWidgetDefinition.precision) && Objects.equals(this.requests, queryValueWidgetDefinition.requests) && Objects.equals((Object)this.textAlign, (Object)queryValueWidgetDefinition.textAlign) && Objects.equals(this.time, queryValueWidgetDefinition.time) && Objects.equals(this.title, queryValueWidgetDefinition.title) && Objects.equals((Object)this.titleAlign, (Object)queryValueWidgetDefinition.titleAlign) && Objects.equals(this.titleSize, queryValueWidgetDefinition.titleSize) && Objects.equals((Object)this.type, (Object)queryValueWidgetDefinition.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.autoscale, this.customLinks, this.customUnit, this.precision, this.requests, this.textAlign, this.time, this.title, this.titleAlign, this.titleSize, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QueryValueWidgetDefinition {\n");
        sb.append("    autoscale: ").append(this.toIndentedString(this.autoscale)).append("\n");
        sb.append("    customLinks: ").append(this.toIndentedString(this.customLinks)).append("\n");
        sb.append("    customUnit: ").append(this.toIndentedString(this.customUnit)).append("\n");
        sb.append("    precision: ").append(this.toIndentedString(this.precision)).append("\n");
        sb.append("    requests: ").append(this.toIndentedString(this.requests)).append("\n");
        sb.append("    textAlign: ").append(this.toIndentedString((Object)this.textAlign)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    titleAlign: ").append(this.toIndentedString((Object)this.titleAlign)).append("\n");
        sb.append("    titleSize: ").append(this.toIndentedString(this.titleSize)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

