/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.SyntheticsBasicAuth;
import com.datadog.api.v1.client.model.SyntheticsCIBatchMetadata;
import com.datadog.api.v1.client.model.SyntheticsDeviceID;
import com.datadog.api.v1.client.model.SyntheticsTestOptionsRetry;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Test configuration for Synthetics CI")
@JsonPropertyOrder(value={"allowInsecureCertificates", "basicAuth", "body", "bodyType", "cookies", "deviceIds", "followRedirects", "headers", "locations", "metadata", "public_id", "retry", "startUrl", "variables"})
public class SyntheticsCITest {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ALLOW_INSECURE_CERTIFICATES = "allowInsecureCertificates";
    private Boolean allowInsecureCertificates;
    public static final String JSON_PROPERTY_BASIC_AUTH = "basicAuth";
    private SyntheticsBasicAuth basicAuth;
    public static final String JSON_PROPERTY_BODY = "body";
    private String body;
    public static final String JSON_PROPERTY_BODY_TYPE = "bodyType";
    private String bodyType;
    public static final String JSON_PROPERTY_COOKIES = "cookies";
    private String cookies;
    public static final String JSON_PROPERTY_DEVICE_IDS = "deviceIds";
    private List<SyntheticsDeviceID> deviceIds = null;
    public static final String JSON_PROPERTY_FOLLOW_REDIRECTS = "followRedirects";
    private Boolean followRedirects;
    public static final String JSON_PROPERTY_HEADERS = "headers";
    private Map<String, String> headers = null;
    public static final String JSON_PROPERTY_LOCATIONS = "locations";
    private List<String> locations = null;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private SyntheticsCIBatchMetadata metadata;
    public static final String JSON_PROPERTY_PUBLIC_ID = "public_id";
    private String publicId;
    public static final String JSON_PROPERTY_RETRY = "retry";
    private SyntheticsTestOptionsRetry retry;
    public static final String JSON_PROPERTY_START_URL = "startUrl";
    private String startUrl;
    public static final String JSON_PROPERTY_VARIABLES = "variables";
    private Map<String, String> variables = null;

    public SyntheticsCITest() {
    }

    @JsonCreator
    public SyntheticsCITest(@JsonProperty(required=true, value="public_id") String publicId) {
        this.publicId = publicId;
    }

    public SyntheticsCITest allowInsecureCertificates(Boolean allowInsecureCertificates) {
        this.allowInsecureCertificates = allowInsecureCertificates;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Disable certificate checks in API tests.")
    @JsonProperty(value="allowInsecureCertificates")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAllowInsecureCertificates() {
        return this.allowInsecureCertificates;
    }

    public void setAllowInsecureCertificates(Boolean allowInsecureCertificates) {
        this.allowInsecureCertificates = allowInsecureCertificates;
    }

    public SyntheticsCITest basicAuth(SyntheticsBasicAuth basicAuth) {
        this.basicAuth = basicAuth;
        this.unparsed |= basicAuth.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="basicAuth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsBasicAuth getBasicAuth() {
        return this.basicAuth;
    }

    public void setBasicAuth(SyntheticsBasicAuth basicAuth) {
        this.basicAuth = basicAuth;
    }

    public SyntheticsCITest body(String body) {
        this.body = body;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Body to include in the test.")
    @JsonProperty(value="body")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public SyntheticsCITest bodyType(String bodyType) {
        this.bodyType = bodyType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Type of the data sent in a synthetics API test.")
    @JsonProperty(value="bodyType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBodyType() {
        return this.bodyType;
    }

    public void setBodyType(String bodyType) {
        this.bodyType = bodyType;
    }

    public SyntheticsCITest cookies(String cookies) {
        this.cookies = cookies;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Cookies for the request.")
    @JsonProperty(value="cookies")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCookies() {
        return this.cookies;
    }

    public void setCookies(String cookies) {
        this.cookies = cookies;
    }

    public SyntheticsCITest deviceIds(List<SyntheticsDeviceID> deviceIds) {
        this.deviceIds = deviceIds;
        return this;
    }

    public SyntheticsCITest addDeviceIdsItem(SyntheticsDeviceID deviceIdsItem) {
        if (this.deviceIds == null) {
            this.deviceIds = new ArrayList<SyntheticsDeviceID>();
        }
        this.deviceIds.add(deviceIdsItem);
        this.unparsed |= !deviceIdsItem.isValid();
        return this;
    }

    @Nullable
    @ApiModelProperty(value="For browser test, array with the different device IDs used to run the test.")
    @JsonProperty(value="deviceIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SyntheticsDeviceID> getDeviceIds() {
        return this.deviceIds;
    }

    public void setDeviceIds(List<SyntheticsDeviceID> deviceIds) {
        this.deviceIds = deviceIds;
    }

    public SyntheticsCITest followRedirects(Boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="For API HTTP test, whether or not the test should follow redirects.")
    @JsonProperty(value="followRedirects")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public void setFollowRedirects(Boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public SyntheticsCITest headers(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public SyntheticsCITest putHeadersItem(String key, String headersItem) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(key, headersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Headers to include when performing the test.")
    @JsonProperty(value="headers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public SyntheticsCITest locations(List<String> locations) {
        this.locations = locations;
        return this;
    }

    public SyntheticsCITest addLocationsItem(String locationsItem) {
        if (this.locations == null) {
            this.locations = new ArrayList<String>();
        }
        this.locations.add(locationsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of locations used to run the test.")
    @JsonProperty(value="locations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getLocations() {
        return this.locations;
    }

    public void setLocations(List<String> locations) {
        this.locations = locations;
    }

    public SyntheticsCITest metadata(SyntheticsCIBatchMetadata metadata) {
        this.metadata = metadata;
        this.unparsed |= metadata.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsCIBatchMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(SyntheticsCIBatchMetadata metadata) {
        this.metadata = metadata;
    }

    public SyntheticsCITest publicId(String publicId) {
        this.publicId = publicId;
        return this;
    }

    @ApiModelProperty(example="aaa-aaa-aaa", required=true, value="The public ID of the Synthetics test to trigger.")
    @JsonProperty(value="public_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPublicId() {
        return this.publicId;
    }

    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    public SyntheticsCITest retry(SyntheticsTestOptionsRetry retry) {
        this.retry = retry;
        this.unparsed |= retry.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="retry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsTestOptionsRetry getRetry() {
        return this.retry;
    }

    public void setRetry(SyntheticsTestOptionsRetry retry) {
        this.retry = retry;
    }

    public SyntheticsCITest startUrl(String startUrl) {
        this.startUrl = startUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Starting URL for the browser test.")
    @JsonProperty(value="startUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStartUrl() {
        return this.startUrl;
    }

    public void setStartUrl(String startUrl) {
        this.startUrl = startUrl;
    }

    public SyntheticsCITest variables(Map<String, String> variables) {
        this.variables = variables;
        return this;
    }

    public SyntheticsCITest putVariablesItem(String key, String variablesItem) {
        if (this.variables == null) {
            this.variables = new HashMap<String, String>();
        }
        this.variables.put(key, variablesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Variables to replace in the test.")
    @JsonProperty(value="variables")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, String> variables) {
        this.variables = variables;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyntheticsCITest syntheticsCITest = (SyntheticsCITest)o;
        return Objects.equals(this.allowInsecureCertificates, syntheticsCITest.allowInsecureCertificates) && Objects.equals(this.basicAuth, syntheticsCITest.basicAuth) && Objects.equals(this.body, syntheticsCITest.body) && Objects.equals(this.bodyType, syntheticsCITest.bodyType) && Objects.equals(this.cookies, syntheticsCITest.cookies) && Objects.equals(this.deviceIds, syntheticsCITest.deviceIds) && Objects.equals(this.followRedirects, syntheticsCITest.followRedirects) && Objects.equals(this.headers, syntheticsCITest.headers) && Objects.equals(this.locations, syntheticsCITest.locations) && Objects.equals(this.metadata, syntheticsCITest.metadata) && Objects.equals(this.publicId, syntheticsCITest.publicId) && Objects.equals(this.retry, syntheticsCITest.retry) && Objects.equals(this.startUrl, syntheticsCITest.startUrl) && Objects.equals(this.variables, syntheticsCITest.variables);
    }

    public int hashCode() {
        return Objects.hash(this.allowInsecureCertificates, this.basicAuth, this.body, this.bodyType, this.cookies, this.deviceIds, this.followRedirects, this.headers, this.locations, this.metadata, this.publicId, this.retry, this.startUrl, this.variables);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SyntheticsCITest {\n");
        sb.append("    allowInsecureCertificates: ").append(this.toIndentedString(this.allowInsecureCertificates)).append("\n");
        sb.append("    basicAuth: ").append(this.toIndentedString(this.basicAuth)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    bodyType: ").append(this.toIndentedString(this.bodyType)).append("\n");
        sb.append("    cookies: ").append(this.toIndentedString(this.cookies)).append("\n");
        sb.append("    deviceIds: ").append(this.toIndentedString(this.deviceIds)).append("\n");
        sb.append("    followRedirects: ").append(this.toIndentedString(this.followRedirects)).append("\n");
        sb.append("    headers: ").append(this.toIndentedString(this.headers)).append("\n");
        sb.append("    locations: ").append(this.toIndentedString(this.locations)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    publicId: ").append(this.toIndentedString(this.publicId)).append("\n");
        sb.append("    retry: ").append(this.toIndentedString(this.retry)).append("\n");
        sb.append("    startUrl: ").append(this.toIndentedString(this.startUrl)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

