/*
 * Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2019-Present Datadog, Inc.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * The groups widget allows you to keep similar graphs together on your timeboard. Each group has a
 * custom header, can hold one to many graphs, and is collapsible.
 */
@JsonPropertyOrder({
  GroupWidgetDefinition.JSON_PROPERTY_BACKGROUND_COLOR,
  GroupWidgetDefinition.JSON_PROPERTY_BANNER_IMG,
  GroupWidgetDefinition.JSON_PROPERTY_LAYOUT_TYPE,
  GroupWidgetDefinition.JSON_PROPERTY_SHOW_TITLE,
  GroupWidgetDefinition.JSON_PROPERTY_TITLE,
  GroupWidgetDefinition.JSON_PROPERTY_TITLE_ALIGN,
  GroupWidgetDefinition.JSON_PROPERTY_TYPE,
  GroupWidgetDefinition.JSON_PROPERTY_WIDGETS
})
@javax.annotation.Generated(
    value = "https://github.com/DataDog/datadog-api-client-java/blob/master/.generator")
public class GroupWidgetDefinition {
  @JsonIgnore public boolean unparsed = false;
  public static final String JSON_PROPERTY_BACKGROUND_COLOR = "background_color";
  private String backgroundColor;

  public static final String JSON_PROPERTY_BANNER_IMG = "banner_img";
  private String bannerImg;

  public static final String JSON_PROPERTY_LAYOUT_TYPE = "layout_type";
  private WidgetLayoutType layoutType;

  public static final String JSON_PROPERTY_SHOW_TITLE = "show_title";
  private Boolean showTitle = true;

  public static final String JSON_PROPERTY_TITLE = "title";
  private String title;

  public static final String JSON_PROPERTY_TITLE_ALIGN = "title_align";
  private WidgetTextAlign titleAlign;

  public static final String JSON_PROPERTY_TYPE = "type";
  private GroupWidgetDefinitionType type = GroupWidgetDefinitionType.GROUP;

  public static final String JSON_PROPERTY_WIDGETS = "widgets";
  private List<Widget> widgets = new ArrayList<>();

  public GroupWidgetDefinition() {}

  @JsonCreator
  public GroupWidgetDefinition(
      @JsonProperty(required = true, value = JSON_PROPERTY_LAYOUT_TYPE) WidgetLayoutType layoutType,
      @JsonProperty(required = true, value = JSON_PROPERTY_TYPE) GroupWidgetDefinitionType type,
      @JsonProperty(required = true, value = JSON_PROPERTY_WIDGETS) List<Widget> widgets) {
    this.layoutType = layoutType;
    this.unparsed |= !layoutType.isValid();
    this.type = type;
    this.unparsed |= !type.isValid();
    this.widgets = widgets;
  }

  public GroupWidgetDefinition backgroundColor(String backgroundColor) {
    this.backgroundColor = backgroundColor;
    return this;
  }

  /**
   * Background color of the group title.
   *
   * @return backgroundColor
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BACKGROUND_COLOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getBackgroundColor() {
    return backgroundColor;
  }

  public void setBackgroundColor(String backgroundColor) {
    this.backgroundColor = backgroundColor;
  }

  public GroupWidgetDefinition bannerImg(String bannerImg) {
    this.bannerImg = bannerImg;
    return this;
  }

  /**
   * URL of image to display as a banner for the group.
   *
   * @return bannerImg
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BANNER_IMG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getBannerImg() {
    return bannerImg;
  }

  public void setBannerImg(String bannerImg) {
    this.bannerImg = bannerImg;
  }

  public GroupWidgetDefinition layoutType(WidgetLayoutType layoutType) {
    this.layoutType = layoutType;
    this.unparsed |= !layoutType.isValid();
    return this;
  }

  /**
   * Layout type of the group.
   *
   * @return layoutType
   */
  @JsonProperty(JSON_PROPERTY_LAYOUT_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public WidgetLayoutType getLayoutType() {
    return layoutType;
  }

  public void setLayoutType(WidgetLayoutType layoutType) {
    if (!layoutType.isValid()) {
      this.unparsed = true;
    }
    this.layoutType = layoutType;
  }

  public GroupWidgetDefinition showTitle(Boolean showTitle) {
    this.showTitle = showTitle;
    return this;
  }

  /**
   * Whether to show the title or not.
   *
   * @return showTitle
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SHOW_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getShowTitle() {
    return showTitle;
  }

  public void setShowTitle(Boolean showTitle) {
    this.showTitle = showTitle;
  }

  public GroupWidgetDefinition title(String title) {
    this.title = title;
    return this;
  }

  /**
   * Title of the widget.
   *
   * @return title
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getTitle() {
    return title;
  }

  public void setTitle(String title) {
    this.title = title;
  }

  public GroupWidgetDefinition titleAlign(WidgetTextAlign titleAlign) {
    this.titleAlign = titleAlign;
    this.unparsed |= !titleAlign.isValid();
    return this;
  }

  /**
   * How to align the text on the widget.
   *
   * @return titleAlign
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TITLE_ALIGN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public WidgetTextAlign getTitleAlign() {
    return titleAlign;
  }

  public void setTitleAlign(WidgetTextAlign titleAlign) {
    if (!titleAlign.isValid()) {
      this.unparsed = true;
    }
    this.titleAlign = titleAlign;
  }

  public GroupWidgetDefinition type(GroupWidgetDefinitionType type) {
    this.type = type;
    this.unparsed |= !type.isValid();
    return this;
  }

  /**
   * Type of the group widget.
   *
   * @return type
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public GroupWidgetDefinitionType getType() {
    return type;
  }

  public void setType(GroupWidgetDefinitionType type) {
    if (!type.isValid()) {
      this.unparsed = true;
    }
    this.type = type;
  }

  public GroupWidgetDefinition widgets(List<Widget> widgets) {
    this.widgets = widgets;
    for (Widget item : widgets) {
      this.unparsed |= item.unparsed;
    }
    return this;
  }

  public GroupWidgetDefinition addWidgetsItem(Widget widgetsItem) {
    this.widgets.add(widgetsItem);
    this.unparsed |= widgetsItem.unparsed;
    return this;
  }

  /**
   * List of widget groups.
   *
   * @return widgets
   */
  @JsonProperty(JSON_PROPERTY_WIDGETS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public List<Widget> getWidgets() {
    return widgets;
  }

  public void setWidgets(List<Widget> widgets) {
    this.widgets = widgets;
  }

  /** Return true if this GroupWidgetDefinition object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GroupWidgetDefinition groupWidgetDefinition = (GroupWidgetDefinition) o;
    return Objects.equals(this.backgroundColor, groupWidgetDefinition.backgroundColor)
        && Objects.equals(this.bannerImg, groupWidgetDefinition.bannerImg)
        && Objects.equals(this.layoutType, groupWidgetDefinition.layoutType)
        && Objects.equals(this.showTitle, groupWidgetDefinition.showTitle)
        && Objects.equals(this.title, groupWidgetDefinition.title)
        && Objects.equals(this.titleAlign, groupWidgetDefinition.titleAlign)
        && Objects.equals(this.type, groupWidgetDefinition.type)
        && Objects.equals(this.widgets, groupWidgetDefinition.widgets);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        backgroundColor, bannerImg, layoutType, showTitle, title, titleAlign, type, widgets);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GroupWidgetDefinition {\n");
    sb.append("    backgroundColor: ").append(toIndentedString(backgroundColor)).append("\n");
    sb.append("    bannerImg: ").append(toIndentedString(bannerImg)).append("\n");
    sb.append("    layoutType: ").append(toIndentedString(layoutType)).append("\n");
    sb.append("    showTitle: ").append(toIndentedString(showTitle)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    titleAlign: ").append(toIndentedString(titleAlign)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    widgets: ").append(toIndentedString(widgets)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
