/*
 * Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2019-Present Datadog, Inc.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Objects;

/** An assertion for the <code>validatesJSONPath</code> operator. */
@JsonPropertyOrder({
  SyntheticsAssertionJSONPathTarget.JSON_PROPERTY_OPERATOR,
  SyntheticsAssertionJSONPathTarget.JSON_PROPERTY_PROPERTY,
  SyntheticsAssertionJSONPathTarget.JSON_PROPERTY_TARGET,
  SyntheticsAssertionJSONPathTarget.JSON_PROPERTY_TYPE
})
@javax.annotation.Generated(
    value = "https://github.com/DataDog/datadog-api-client-java/blob/master/.generator")
public class SyntheticsAssertionJSONPathTarget {
  @JsonIgnore public boolean unparsed = false;
  public static final String JSON_PROPERTY_OPERATOR = "operator";
  private SyntheticsAssertionJSONPathOperator operator;

  public static final String JSON_PROPERTY_PROPERTY = "property";
  private String property;

  public static final String JSON_PROPERTY_TARGET = "target";
  private SyntheticsAssertionJSONPathTargetTarget target;

  public static final String JSON_PROPERTY_TYPE = "type";
  private SyntheticsAssertionType type;

  public SyntheticsAssertionJSONPathTarget() {}

  @JsonCreator
  public SyntheticsAssertionJSONPathTarget(
      @JsonProperty(required = true, value = JSON_PROPERTY_OPERATOR)
          SyntheticsAssertionJSONPathOperator operator,
      @JsonProperty(required = true, value = JSON_PROPERTY_TYPE) SyntheticsAssertionType type) {
    this.operator = operator;
    this.unparsed |= !operator.isValid();
    this.type = type;
    this.unparsed |= !type.isValid();
  }

  public SyntheticsAssertionJSONPathTarget operator(SyntheticsAssertionJSONPathOperator operator) {
    this.operator = operator;
    this.unparsed |= !operator.isValid();
    return this;
  }

  /**
   * Assertion operator to apply.
   *
   * @return operator
   */
  @JsonProperty(JSON_PROPERTY_OPERATOR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public SyntheticsAssertionJSONPathOperator getOperator() {
    return operator;
  }

  public void setOperator(SyntheticsAssertionJSONPathOperator operator) {
    if (!operator.isValid()) {
      this.unparsed = true;
    }
    this.operator = operator;
  }

  public SyntheticsAssertionJSONPathTarget property(String property) {
    this.property = property;
    return this;
  }

  /**
   * The associated assertion property.
   *
   * @return property
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROPERTY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getProperty() {
    return property;
  }

  public void setProperty(String property) {
    this.property = property;
  }

  public SyntheticsAssertionJSONPathTarget target(SyntheticsAssertionJSONPathTargetTarget target) {
    this.target = target;
    this.unparsed |= target.unparsed;
    return this;
  }

  /**
   * Composed target for <code>validatesJSONPath</code> operator.
   *
   * @return target
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TARGET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public SyntheticsAssertionJSONPathTargetTarget getTarget() {
    return target;
  }

  public void setTarget(SyntheticsAssertionJSONPathTargetTarget target) {
    this.target = target;
  }

  public SyntheticsAssertionJSONPathTarget type(SyntheticsAssertionType type) {
    this.type = type;
    this.unparsed |= !type.isValid();
    return this;
  }

  /**
   * Type of the assertion.
   *
   * @return type
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public SyntheticsAssertionType getType() {
    return type;
  }

  public void setType(SyntheticsAssertionType type) {
    if (!type.isValid()) {
      this.unparsed = true;
    }
    this.type = type;
  }

  /** Return true if this SyntheticsAssertionJSONPathTarget object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SyntheticsAssertionJSONPathTarget syntheticsAssertionJsonPathTarget =
        (SyntheticsAssertionJSONPathTarget) o;
    return Objects.equals(this.operator, syntheticsAssertionJsonPathTarget.operator)
        && Objects.equals(this.property, syntheticsAssertionJsonPathTarget.property)
        && Objects.equals(this.target, syntheticsAssertionJsonPathTarget.target)
        && Objects.equals(this.type, syntheticsAssertionJsonPathTarget.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(operator, property, target, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SyntheticsAssertionJSONPathTarget {\n");
    sb.append("    operator: ").append(toIndentedString(operator)).append("\n");
    sb.append("    property: ").append(toIndentedString(property)).append("\n");
    sb.append("    target: ").append(toIndentedString(target)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
