/*
 * Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2019-Present Datadog, Inc.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

/** The direction to sort by. */
@JsonSerialize(using = UsageSortDirection.UsageSortDirectionSerializer.class)
public class UsageSortDirection {

  public static final UsageSortDirection DESC = new UsageSortDirection("desc");
  public static final UsageSortDirection ASC = new UsageSortDirection("asc");

  private static final Set<String> allowedValues =
      new HashSet<String>(Arrays.asList("desc", "asc"));

  private String value;

  public boolean isValid() {
    return allowedValues.contains(this.value);
  }

  UsageSortDirection(String value) {
    this.value = value;
  }

  public static class UsageSortDirectionSerializer extends StdSerializer<UsageSortDirection> {
    public UsageSortDirectionSerializer(Class<UsageSortDirection> t) {
      super(t);
    }

    public UsageSortDirectionSerializer() {
      this(null);
    }

    @Override
    public void serialize(UsageSortDirection value, JsonGenerator jgen, SerializerProvider provider)
        throws IOException, JsonProcessingException {
      jgen.writeObject(value.value);
    }
  }

  @JsonValue
  public String getValue() {
    return this.value;
  }

  public void setValue(String value) {
    this.value = value;
  }

  /** Return true if this UsageSortDirection object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    return this.value.equals(((UsageSortDirection) o).value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(value);
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static UsageSortDirection fromValue(String value) {
    return new UsageSortDirection(value);
  }
}
