/*
 * Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2019-Present Datadog, Inc.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.datadog.api.v2.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** Response object that includes a list of Agent rule. */
@JsonPropertyOrder({CloudWorkloadSecurityAgentRulesListResponse.JSON_PROPERTY_DATA})
@javax.annotation.Generated(
    value = "https://github.com/DataDog/datadog-api-client-java/blob/master/.generator")
public class CloudWorkloadSecurityAgentRulesListResponse {
  @JsonIgnore public boolean unparsed = false;
  public static final String JSON_PROPERTY_DATA = "data";
  private List<CloudWorkloadSecurityAgentRuleData> data = null;

  public CloudWorkloadSecurityAgentRulesListResponse data(
      List<CloudWorkloadSecurityAgentRuleData> data) {
    this.data = data;
    for (CloudWorkloadSecurityAgentRuleData item : data) {
      this.unparsed |= item.unparsed;
    }
    return this;
  }

  public CloudWorkloadSecurityAgentRulesListResponse addDataItem(
      CloudWorkloadSecurityAgentRuleData dataItem) {
    if (this.data == null) {
      this.data = new ArrayList<>();
    }
    this.data.add(dataItem);
    this.unparsed |= dataItem.unparsed;
    return this;
  }

  /**
   * A list of Agent rules objects.
   *
   * @return data
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<CloudWorkloadSecurityAgentRuleData> getData() {
    return data;
  }

  public void setData(List<CloudWorkloadSecurityAgentRuleData> data) {
    this.data = data;
  }

  /** Return true if this CloudWorkloadSecurityAgentRulesListResponse object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CloudWorkloadSecurityAgentRulesListResponse cloudWorkloadSecurityAgentRulesListResponse =
        (CloudWorkloadSecurityAgentRulesListResponse) o;
    return Objects.equals(this.data, cloudWorkloadSecurityAgentRulesListResponse.data);
  }

  @Override
  public int hashCode() {
    return Objects.hash(data);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CloudWorkloadSecurityAgentRulesListResponse {\n");
    sb.append("    data: ").append(toIndentedString(data)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
