/*
 * Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2019-Present Datadog, Inc.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.datadog.api.v2.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Objects;

/** Metric origin information. */
@JsonPropertyOrder({
  MetricOrigin.JSON_PROPERTY_METRIC_TYPE,
  MetricOrigin.JSON_PROPERTY_PRODUCT,
  MetricOrigin.JSON_PROPERTY_SERVICE
})
@javax.annotation.Generated(
    value = "https://github.com/DataDog/datadog-api-client-java/blob/master/.generator")
public class MetricOrigin {
  @JsonIgnore public boolean unparsed = false;
  public static final String JSON_PROPERTY_METRIC_TYPE = "metric_type";
  private Integer metricType = 0;

  public static final String JSON_PROPERTY_PRODUCT = "product";
  private Integer product = 0;

  public static final String JSON_PROPERTY_SERVICE = "service";
  private Integer service = 0;

  public MetricOrigin metricType(Integer metricType) {
    this.metricType = metricType;
    return this;
  }

  /**
   * The origin metric type code maximum: 1000
   *
   * @return metricType
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_METRIC_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getMetricType() {
    return metricType;
  }

  public void setMetricType(Integer metricType) {
    this.metricType = metricType;
  }

  public MetricOrigin product(Integer product) {
    this.product = product;
    return this;
  }

  /**
   * The origin product code maximum: 1000
   *
   * @return product
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PRODUCT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getProduct() {
    return product;
  }

  public void setProduct(Integer product) {
    this.product = product;
  }

  public MetricOrigin service(Integer service) {
    this.service = service;
    return this;
  }

  /**
   * The origin service code maximum: 1000
   *
   * @return service
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SERVICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getService() {
    return service;
  }

  public void setService(Integer service) {
    this.service = service;
  }

  /** Return true if this MetricOrigin object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MetricOrigin metricOrigin = (MetricOrigin) o;
    return Objects.equals(this.metricType, metricOrigin.metricType)
        && Objects.equals(this.product, metricOrigin.product)
        && Objects.equals(this.service, metricOrigin.service);
  }

  @Override
  public int hashCode() {
    return Objects.hash(metricType, product, service);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MetricOrigin {\n");
    sb.append("    metricType: ").append(toIndentedString(metricType)).append("\n");
    sb.append("    product: ").append(toIndentedString(product)).append("\n");
    sb.append("    service: ").append(toIndentedString(service)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
