/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client;

import com.datadoghq.com.fasterxml.jackson.core.JsonGenerator;
import com.datadoghq.com.fasterxml.jackson.databind.SerializerProvider;
import com.datadoghq.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public class JsonTimeSerializer
extends StdSerializer<OffsetDateTime> {
    private static DateTimeFormatter msFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    private static DateTimeFormatter missingMsFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssXXX");

    public JsonTimeSerializer() {
        this((Class<OffsetDateTime>)null);
    }

    public JsonTimeSerializer(Class<OffsetDateTime> t) {
        super(t);
    }

    @Override
    public void serialize(OffsetDateTime value, JsonGenerator gen, SerializerProvider arg2) throws IOException {
        if (value.getNano() == 0) {
            gen.writeString(missingMsFormatter.format(value));
        } else {
            gen.writeString(msFormatter.format(value));
        }
    }
}

