/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v1.model.HostListResponse;
import com.datadog.api.client.v1.model.HostMuteResponse;
import com.datadog.api.client.v1.model.HostMuteSettings;
import com.datadog.api.client.v1.model.HostTotals;
import com.datadoghq.jakarta.ws.rs.client.Invocation;
import com.datadoghq.jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class HostsApi {
    private ApiClient apiClient;

    public HostsApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public HostsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public HostTotals getHostTotals() throws ApiException {
        return this.getHostTotalsWithHttpInfo(new GetHostTotalsOptionalParameters()).getData();
    }

    public CompletableFuture<HostTotals> getHostTotalsAsync() {
        return this.getHostTotalsWithHttpInfoAsync(new GetHostTotalsOptionalParameters()).thenApply(response -> (HostTotals)response.getData());
    }

    public HostTotals getHostTotals(GetHostTotalsOptionalParameters parameters) throws ApiException {
        return this.getHostTotalsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<HostTotals> getHostTotalsAsync(GetHostTotalsOptionalParameters parameters) {
        return this.getHostTotalsWithHttpInfoAsync(parameters).thenApply(response -> (HostTotals)response.getData());
    }

    public ApiResponse<HostTotals> getHostTotalsWithHttpInfo(GetHostTotalsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        Long from = parameters.from;
        String localVarPath = "/api/v1/hosts/totals";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "from", from));
        Invocation.Builder builder = this.apiClient.createBuilder("v1.HostsApi.getHostTotals", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<HostTotals>(){});
    }

    public CompletableFuture<ApiResponse<HostTotals>> getHostTotalsWithHttpInfoAsync(GetHostTotalsOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        Long from = parameters.from;
        String localVarPath = "/api/v1/hosts/totals";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "from", from));
        try {
            builder = this.apiClient.createBuilder("v1.HostsApi.getHostTotals", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<HostTotals>> result = new CompletableFuture<ApiResponse<HostTotals>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<HostTotals>(){});
    }

    public HostListResponse listHosts() throws ApiException {
        return this.listHostsWithHttpInfo(new ListHostsOptionalParameters()).getData();
    }

    public CompletableFuture<HostListResponse> listHostsAsync() {
        return this.listHostsWithHttpInfoAsync(new ListHostsOptionalParameters()).thenApply(response -> (HostListResponse)response.getData());
    }

    public HostListResponse listHosts(ListHostsOptionalParameters parameters) throws ApiException {
        return this.listHostsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<HostListResponse> listHostsAsync(ListHostsOptionalParameters parameters) {
        return this.listHostsWithHttpInfoAsync(parameters).thenApply(response -> (HostListResponse)response.getData());
    }

    public ApiResponse<HostListResponse> listHostsWithHttpInfo(ListHostsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        String filter = parameters.filter;
        String sortField = parameters.sortField;
        String sortDir = parameters.sortDir;
        Long start = parameters.start;
        Long count = parameters.count;
        Long from = parameters.from;
        Boolean includeMutedHostsData = parameters.includeMutedHostsData;
        Boolean includeHostsMetadata = parameters.includeHostsMetadata;
        String localVarPath = "/api/v1/hosts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort_field", sortField));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort_dir", sortDir));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start", start));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "count", count));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "from", from));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include_muted_hosts_data", includeMutedHostsData));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include_hosts_metadata", includeHostsMetadata));
        Invocation.Builder builder = this.apiClient.createBuilder("v1.HostsApi.listHosts", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<HostListResponse>(){});
    }

    public CompletableFuture<ApiResponse<HostListResponse>> listHostsWithHttpInfoAsync(ListHostsOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String filter = parameters.filter;
        String sortField = parameters.sortField;
        String sortDir = parameters.sortDir;
        Long start = parameters.start;
        Long count = parameters.count;
        Long from = parameters.from;
        Boolean includeMutedHostsData = parameters.includeMutedHostsData;
        Boolean includeHostsMetadata = parameters.includeHostsMetadata;
        String localVarPath = "/api/v1/hosts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort_field", sortField));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort_dir", sortDir));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start", start));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "count", count));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "from", from));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include_muted_hosts_data", includeMutedHostsData));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include_hosts_metadata", includeHostsMetadata));
        try {
            builder = this.apiClient.createBuilder("v1.HostsApi.listHosts", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<HostListResponse>> result = new CompletableFuture<ApiResponse<HostListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<HostListResponse>(){});
    }

    public HostMuteResponse muteHost(String hostName, HostMuteSettings body) throws ApiException {
        return this.muteHostWithHttpInfo(hostName, body).getData();
    }

    public CompletableFuture<HostMuteResponse> muteHostAsync(String hostName, HostMuteSettings body) {
        return this.muteHostWithHttpInfoAsync(hostName, body).thenApply(response -> (HostMuteResponse)response.getData());
    }

    public ApiResponse<HostMuteResponse> muteHostWithHttpInfo(String hostName, HostMuteSettings body) throws ApiException {
        HostMuteSettings localVarPostBody = body;
        if (hostName == null) {
            throw new ApiException(400, "Missing the required parameter 'hostName' when calling muteHost");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling muteHost");
        }
        String localVarPath = "/api/v1/host/{host_name}/mute".replaceAll("\\{host_name\\}", this.apiClient.escapeString(hostName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.HostsApi.muteHost", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<HostMuteResponse>(){});
    }

    public CompletableFuture<ApiResponse<HostMuteResponse>> muteHostWithHttpInfoAsync(String hostName, HostMuteSettings body) {
        Invocation.Builder builder;
        HostMuteSettings localVarPostBody = body;
        if (hostName == null) {
            CompletableFuture<ApiResponse<HostMuteResponse>> result = new CompletableFuture<ApiResponse<HostMuteResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'hostName' when calling muteHost"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<HostMuteResponse>> result = new CompletableFuture<ApiResponse<HostMuteResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling muteHost"));
            return result;
        }
        String localVarPath = "/api/v1/host/{host_name}/mute".replaceAll("\\{host_name\\}", this.apiClient.escapeString(hostName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.HostsApi.muteHost", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<HostMuteResponse>> result = new CompletableFuture<ApiResponse<HostMuteResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<HostMuteResponse>(){});
    }

    public HostMuteResponse unmuteHost(String hostName) throws ApiException {
        return this.unmuteHostWithHttpInfo(hostName).getData();
    }

    public CompletableFuture<HostMuteResponse> unmuteHostAsync(String hostName) {
        return this.unmuteHostWithHttpInfoAsync(hostName).thenApply(response -> (HostMuteResponse)response.getData());
    }

    public ApiResponse<HostMuteResponse> unmuteHostWithHttpInfo(String hostName) throws ApiException {
        Object localVarPostBody = null;
        if (hostName == null) {
            throw new ApiException(400, "Missing the required parameter 'hostName' when calling unmuteHost");
        }
        String localVarPath = "/api/v1/host/{host_name}/unmute".replaceAll("\\{host_name\\}", this.apiClient.escapeString(hostName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.HostsApi.unmuteHost", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<HostMuteResponse>(){});
    }

    public CompletableFuture<ApiResponse<HostMuteResponse>> unmuteHostWithHttpInfoAsync(String hostName) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (hostName == null) {
            CompletableFuture<ApiResponse<HostMuteResponse>> result = new CompletableFuture<ApiResponse<HostMuteResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'hostName' when calling unmuteHost"));
            return result;
        }
        String localVarPath = "/api/v1/host/{host_name}/unmute".replaceAll("\\{host_name\\}", this.apiClient.escapeString(hostName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.HostsApi.unmuteHost", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<HostMuteResponse>> result = new CompletableFuture<ApiResponse<HostMuteResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<HostMuteResponse>(){});
    }

    public static class ListHostsOptionalParameters {
        private String filter;
        private String sortField;
        private String sortDir;
        private Long start;
        private Long count;
        private Long from;
        private Boolean includeMutedHostsData;
        private Boolean includeHostsMetadata;

        public ListHostsOptionalParameters filter(String filter) {
            this.filter = filter;
            return this;
        }

        public ListHostsOptionalParameters sortField(String sortField) {
            this.sortField = sortField;
            return this;
        }

        public ListHostsOptionalParameters sortDir(String sortDir) {
            this.sortDir = sortDir;
            return this;
        }

        public ListHostsOptionalParameters start(Long start) {
            this.start = start;
            return this;
        }

        public ListHostsOptionalParameters count(Long count) {
            this.count = count;
            return this;
        }

        public ListHostsOptionalParameters from(Long from) {
            this.from = from;
            return this;
        }

        public ListHostsOptionalParameters includeMutedHostsData(Boolean includeMutedHostsData) {
            this.includeMutedHostsData = includeMutedHostsData;
            return this;
        }

        public ListHostsOptionalParameters includeHostsMetadata(Boolean includeHostsMetadata) {
            this.includeHostsMetadata = includeHostsMetadata;
            return this;
        }
    }

    public static class GetHostTotalsOptionalParameters {
        private Long from;

        public GetHostTotalsOptionalParameters from(Long from) {
            this.from = from;
            return this;
        }
    }
}

