/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.LogsDailyLimitReset;
import com.datadog.api.client.v1.model.LogsExclusion;
import com.datadog.api.client.v1.model.LogsFilter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"daily_limit", "daily_limit_reset", "daily_limit_warning_threshold_percentage", "exclusion_filters", "filter", "is_rate_limited", "name", "num_retention_days"})
public class LogsIndex {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DAILY_LIMIT = "daily_limit";
    private Long dailyLimit;
    public static final String JSON_PROPERTY_DAILY_LIMIT_RESET = "daily_limit_reset";
    private LogsDailyLimitReset dailyLimitReset;
    public static final String JSON_PROPERTY_DAILY_LIMIT_WARNING_THRESHOLD_PERCENTAGE = "daily_limit_warning_threshold_percentage";
    private Double dailyLimitWarningThresholdPercentage;
    public static final String JSON_PROPERTY_EXCLUSION_FILTERS = "exclusion_filters";
    private List<LogsExclusion> exclusionFilters = null;
    public static final String JSON_PROPERTY_FILTER = "filter";
    private LogsFilter filter;
    public static final String JSON_PROPERTY_IS_RATE_LIMITED = "is_rate_limited";
    private Boolean isRateLimited;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_NUM_RETENTION_DAYS = "num_retention_days";
    private Long numRetentionDays;
    private Map<String, Object> additionalProperties;

    public LogsIndex() {
    }

    @JsonCreator
    public LogsIndex(@JsonProperty(required=true, value="filter") LogsFilter filter, @JsonProperty(required=true, value="name") String name) {
        this.filter = filter;
        this.unparsed |= filter.unparsed;
        this.name = name;
    }

    public LogsIndex dailyLimit(Long dailyLimit) {
        this.dailyLimit = dailyLimit;
        return this;
    }

    @Nullable
    @JsonProperty(value="daily_limit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getDailyLimit() {
        return this.dailyLimit;
    }

    public void setDailyLimit(Long dailyLimit) {
        this.dailyLimit = dailyLimit;
    }

    public LogsIndex dailyLimitReset(LogsDailyLimitReset dailyLimitReset) {
        this.dailyLimitReset = dailyLimitReset;
        this.unparsed |= dailyLimitReset.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="daily_limit_reset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogsDailyLimitReset getDailyLimitReset() {
        return this.dailyLimitReset;
    }

    public void setDailyLimitReset(LogsDailyLimitReset dailyLimitReset) {
        this.dailyLimitReset = dailyLimitReset;
    }

    public LogsIndex dailyLimitWarningThresholdPercentage(Double dailyLimitWarningThresholdPercentage) {
        this.dailyLimitWarningThresholdPercentage = dailyLimitWarningThresholdPercentage;
        return this;
    }

    @Nullable
    @JsonProperty(value="daily_limit_warning_threshold_percentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getDailyLimitWarningThresholdPercentage() {
        return this.dailyLimitWarningThresholdPercentage;
    }

    public void setDailyLimitWarningThresholdPercentage(Double dailyLimitWarningThresholdPercentage) {
        this.dailyLimitWarningThresholdPercentage = dailyLimitWarningThresholdPercentage;
    }

    public LogsIndex exclusionFilters(List<LogsExclusion> exclusionFilters) {
        this.exclusionFilters = exclusionFilters;
        for (LogsExclusion item : exclusionFilters) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public LogsIndex addExclusionFiltersItem(LogsExclusion exclusionFiltersItem) {
        if (this.exclusionFilters == null) {
            this.exclusionFilters = new ArrayList<LogsExclusion>();
        }
        this.exclusionFilters.add(exclusionFiltersItem);
        this.unparsed |= exclusionFiltersItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="exclusion_filters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LogsExclusion> getExclusionFilters() {
        return this.exclusionFilters;
    }

    public void setExclusionFilters(List<LogsExclusion> exclusionFilters) {
        this.exclusionFilters = exclusionFilters;
    }

    public LogsIndex filter(LogsFilter filter) {
        this.filter = filter;
        this.unparsed |= filter.unparsed;
        return this;
    }

    @JsonProperty(value="filter")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LogsFilter getFilter() {
        return this.filter;
    }

    public void setFilter(LogsFilter filter) {
        this.filter = filter;
    }

    @Nullable
    @JsonProperty(value="is_rate_limited")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsRateLimited() {
        return this.isRateLimited;
    }

    public LogsIndex name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LogsIndex numRetentionDays(Long numRetentionDays) {
        this.numRetentionDays = numRetentionDays;
        return this;
    }

    @Nullable
    @JsonProperty(value="num_retention_days")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getNumRetentionDays() {
        return this.numRetentionDays;
    }

    public void setNumRetentionDays(Long numRetentionDays) {
        this.numRetentionDays = numRetentionDays;
    }

    @JsonAnySetter
    public LogsIndex putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsIndex logsIndex = (LogsIndex)o;
        return Objects.equals(this.dailyLimit, logsIndex.dailyLimit) && Objects.equals(this.dailyLimitReset, logsIndex.dailyLimitReset) && Objects.equals(this.dailyLimitWarningThresholdPercentage, logsIndex.dailyLimitWarningThresholdPercentage) && Objects.equals(this.exclusionFilters, logsIndex.exclusionFilters) && Objects.equals(this.filter, logsIndex.filter) && Objects.equals(this.isRateLimited, logsIndex.isRateLimited) && Objects.equals(this.name, logsIndex.name) && Objects.equals(this.numRetentionDays, logsIndex.numRetentionDays) && Objects.equals(this.additionalProperties, logsIndex.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.dailyLimit, this.dailyLimitReset, this.dailyLimitWarningThresholdPercentage, this.exclusionFilters, this.filter, this.isRateLimited, this.name, this.numRetentionDays, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsIndex {\n");
        sb.append("    dailyLimit: ").append(this.toIndentedString(this.dailyLimit)).append("\n");
        sb.append("    dailyLimitReset: ").append(this.toIndentedString(this.dailyLimitReset)).append("\n");
        sb.append("    dailyLimitWarningThresholdPercentage: ").append(this.toIndentedString(this.dailyLimitWarningThresholdPercentage)).append("\n");
        sb.append("    exclusionFilters: ").append(this.toIndentedString(this.exclusionFilters)).append("\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    isRateLimited: ").append(this.toIndentedString(this.isRateLimited)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    numRetentionDays: ").append(this.toIndentedString(this.numRetentionDays)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

