/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.Organization;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"orgs"})
public class OrganizationListResponse {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ORGS = "orgs";
    private List<Organization> orgs = null;
    private Map<String, Object> additionalProperties;

    public OrganizationListResponse orgs(List<Organization> orgs) {
        this.orgs = orgs;
        for (Organization item : orgs) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public OrganizationListResponse addOrgsItem(Organization orgsItem) {
        if (this.orgs == null) {
            this.orgs = new ArrayList<Organization>();
        }
        this.orgs.add(orgsItem);
        this.unparsed |= orgsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="orgs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Organization> getOrgs() {
        return this.orgs;
    }

    public void setOrgs(List<Organization> orgs) {
        this.orgs = orgs;
    }

    @JsonAnySetter
    public OrganizationListResponse putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrganizationListResponse organizationListResponse = (OrganizationListResponse)o;
        return Objects.equals(this.orgs, organizationListResponse.orgs) && Objects.equals(this.additionalProperties, organizationListResponse.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.orgs, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrganizationListResponse {\n");
        sb.append("    orgs: ").append(this.toIndentedString(this.orgs)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

