/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.SLOTimeframe;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"target", "target_display", "timeframe", "warning", "warning_display"})
public class SLOThreshold {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_TARGET = "target";
    private Double target;
    public static final String JSON_PROPERTY_TARGET_DISPLAY = "target_display";
    private String targetDisplay;
    public static final String JSON_PROPERTY_TIMEFRAME = "timeframe";
    private SLOTimeframe timeframe;
    public static final String JSON_PROPERTY_WARNING = "warning";
    private Double warning;
    public static final String JSON_PROPERTY_WARNING_DISPLAY = "warning_display";
    private String warningDisplay;
    private Map<String, Object> additionalProperties;

    public SLOThreshold() {
    }

    @JsonCreator
    public SLOThreshold(@JsonProperty(required=true, value="target") Double target, @JsonProperty(required=true, value="timeframe") SLOTimeframe timeframe) {
        this.target = target;
        this.timeframe = timeframe;
        this.unparsed |= !timeframe.isValid();
    }

    public SLOThreshold target(Double target) {
        this.target = target;
        return this;
    }

    @JsonProperty(value="target")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Double getTarget() {
        return this.target;
    }

    public void setTarget(Double target) {
        this.target = target;
    }

    public SLOThreshold targetDisplay(String targetDisplay) {
        this.targetDisplay = targetDisplay;
        return this;
    }

    @Nullable
    @JsonProperty(value="target_display")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTargetDisplay() {
        return this.targetDisplay;
    }

    public void setTargetDisplay(String targetDisplay) {
        this.targetDisplay = targetDisplay;
    }

    public SLOThreshold timeframe(SLOTimeframe timeframe) {
        this.timeframe = timeframe;
        this.unparsed |= !timeframe.isValid();
        return this;
    }

    @JsonProperty(value="timeframe")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SLOTimeframe getTimeframe() {
        return this.timeframe;
    }

    public void setTimeframe(SLOTimeframe timeframe) {
        if (!timeframe.isValid()) {
            this.unparsed = true;
        }
        this.timeframe = timeframe;
    }

    public SLOThreshold warning(Double warning) {
        this.warning = warning;
        return this;
    }

    @Nullable
    @JsonProperty(value="warning")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getWarning() {
        return this.warning;
    }

    public void setWarning(Double warning) {
        this.warning = warning;
    }

    public SLOThreshold warningDisplay(String warningDisplay) {
        this.warningDisplay = warningDisplay;
        return this;
    }

    @Nullable
    @JsonProperty(value="warning_display")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWarningDisplay() {
        return this.warningDisplay;
    }

    public void setWarningDisplay(String warningDisplay) {
        this.warningDisplay = warningDisplay;
    }

    @JsonAnySetter
    public SLOThreshold putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SLOThreshold sloThreshold = (SLOThreshold)o;
        return Objects.equals(this.target, sloThreshold.target) && Objects.equals(this.targetDisplay, sloThreshold.targetDisplay) && Objects.equals(this.timeframe, sloThreshold.timeframe) && Objects.equals(this.warning, sloThreshold.warning) && Objects.equals(this.warningDisplay, sloThreshold.warningDisplay) && Objects.equals(this.additionalProperties, sloThreshold.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.target, this.targetDisplay, this.timeframe, this.warning, this.warningDisplay, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SLOThreshold {\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("    targetDisplay: ").append(this.toIndentedString(this.targetDisplay)).append("\n");
        sb.append("    timeframe: ").append(this.toIndentedString(this.timeframe)).append("\n");
        sb.append("    warning: ").append(this.toIndentedString(this.warning)).append("\n");
        sb.append("    warningDisplay: ").append(this.toIndentedString(this.warningDisplay)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

