/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.AWSRelatedAccountsResponse;
import com.datadog.api.client.v2.model.AwsCURConfigPatchRequest;
import com.datadog.api.client.v2.model.AwsCURConfigPostRequest;
import com.datadog.api.client.v2.model.AwsCURConfigResponse;
import com.datadog.api.client.v2.model.AwsCURConfigsResponse;
import com.datadog.api.client.v2.model.AzureUCConfigPairsResponse;
import com.datadog.api.client.v2.model.AzureUCConfigPatchRequest;
import com.datadog.api.client.v2.model.AzureUCConfigPostRequest;
import com.datadog.api.client.v2.model.AzureUCConfigsResponse;
import com.datadog.api.client.v2.model.CloudCostActivityResponse;
import com.datadoghq.jakarta.ws.rs.client.Invocation;
import com.datadoghq.jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class CloudCostManagementApi {
    private ApiClient apiClient;

    public CloudCostManagementApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public CloudCostManagementApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public AwsCURConfigResponse createCostAWSCURConfig(AwsCURConfigPostRequest body) throws ApiException {
        return this.createCostAWSCURConfigWithHttpInfo(body).getData();
    }

    public CompletableFuture<AwsCURConfigResponse> createCostAWSCURConfigAsync(AwsCURConfigPostRequest body) {
        return this.createCostAWSCURConfigWithHttpInfoAsync(body).thenApply(response -> (AwsCURConfigResponse)response.getData());
    }

    public ApiResponse<AwsCURConfigResponse> createCostAWSCURConfigWithHttpInfo(AwsCURConfigPostRequest body) throws ApiException {
        AwsCURConfigPostRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createCostAWSCURConfig");
        }
        String localVarPath = "/api/v2/cost/aws_cur_config";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.createCostAWSCURConfig", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AwsCURConfigResponse>(){});
    }

    public CompletableFuture<ApiResponse<AwsCURConfigResponse>> createCostAWSCURConfigWithHttpInfoAsync(AwsCURConfigPostRequest body) {
        Invocation.Builder builder;
        AwsCURConfigPostRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<AwsCURConfigResponse>> result = new CompletableFuture<ApiResponse<AwsCURConfigResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createCostAWSCURConfig"));
            return result;
        }
        String localVarPath = "/api/v2/cost/aws_cur_config";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.createCostAWSCURConfig", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AwsCURConfigResponse>> result = new CompletableFuture<ApiResponse<AwsCURConfigResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AwsCURConfigResponse>(){});
    }

    public AzureUCConfigPairsResponse createCostAzureUCConfigs(AzureUCConfigPostRequest body) throws ApiException {
        return this.createCostAzureUCConfigsWithHttpInfo(body).getData();
    }

    public CompletableFuture<AzureUCConfigPairsResponse> createCostAzureUCConfigsAsync(AzureUCConfigPostRequest body) {
        return this.createCostAzureUCConfigsWithHttpInfoAsync(body).thenApply(response -> (AzureUCConfigPairsResponse)response.getData());
    }

    public ApiResponse<AzureUCConfigPairsResponse> createCostAzureUCConfigsWithHttpInfo(AzureUCConfigPostRequest body) throws ApiException {
        AzureUCConfigPostRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createCostAzureUCConfigs");
        }
        String localVarPath = "/api/v2/cost/azure_uc_config";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.createCostAzureUCConfigs", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AzureUCConfigPairsResponse>(){});
    }

    public CompletableFuture<ApiResponse<AzureUCConfigPairsResponse>> createCostAzureUCConfigsWithHttpInfoAsync(AzureUCConfigPostRequest body) {
        Invocation.Builder builder;
        AzureUCConfigPostRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<AzureUCConfigPairsResponse>> result = new CompletableFuture<ApiResponse<AzureUCConfigPairsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createCostAzureUCConfigs"));
            return result;
        }
        String localVarPath = "/api/v2/cost/azure_uc_config";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.createCostAzureUCConfigs", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AzureUCConfigPairsResponse>> result = new CompletableFuture<ApiResponse<AzureUCConfigPairsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AzureUCConfigPairsResponse>(){});
    }

    public void deleteCostAWSCURConfig(String cloudAccountId) throws ApiException {
        this.deleteCostAWSCURConfigWithHttpInfo(cloudAccountId);
    }

    public CompletableFuture<Void> deleteCostAWSCURConfigAsync(String cloudAccountId) {
        return this.deleteCostAWSCURConfigWithHttpInfoAsync(cloudAccountId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteCostAWSCURConfigWithHttpInfo(String cloudAccountId) throws ApiException {
        Object localVarPostBody = null;
        if (cloudAccountId == null) {
            throw new ApiException(400, "Missing the required parameter 'cloudAccountId' when calling deleteCostAWSCURConfig");
        }
        String localVarPath = "/api/v2/cost/aws_cur_config/{cloud_account_id}".replaceAll("\\{cloud_account_id\\}", this.apiClient.escapeString(cloudAccountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.deleteCostAWSCURConfig", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteCostAWSCURConfigWithHttpInfoAsync(String cloudAccountId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (cloudAccountId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'cloudAccountId' when calling deleteCostAWSCURConfig"));
            return result;
        }
        String localVarPath = "/api/v2/cost/aws_cur_config/{cloud_account_id}".replaceAll("\\{cloud_account_id\\}", this.apiClient.escapeString(cloudAccountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.deleteCostAWSCURConfig", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void deleteCostAzureUCConfig(String cloudAccountId) throws ApiException {
        this.deleteCostAzureUCConfigWithHttpInfo(cloudAccountId);
    }

    public CompletableFuture<Void> deleteCostAzureUCConfigAsync(String cloudAccountId) {
        return this.deleteCostAzureUCConfigWithHttpInfoAsync(cloudAccountId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteCostAzureUCConfigWithHttpInfo(String cloudAccountId) throws ApiException {
        Object localVarPostBody = null;
        if (cloudAccountId == null) {
            throw new ApiException(400, "Missing the required parameter 'cloudAccountId' when calling deleteCostAzureUCConfig");
        }
        String localVarPath = "/api/v2/cost/azure_uc_config/{cloud_account_id}".replaceAll("\\{cloud_account_id\\}", this.apiClient.escapeString(cloudAccountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.deleteCostAzureUCConfig", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteCostAzureUCConfigWithHttpInfoAsync(String cloudAccountId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (cloudAccountId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'cloudAccountId' when calling deleteCostAzureUCConfig"));
            return result;
        }
        String localVarPath = "/api/v2/cost/azure_uc_config/{cloud_account_id}".replaceAll("\\{cloud_account_id\\}", this.apiClient.escapeString(cloudAccountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.deleteCostAzureUCConfig", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CloudCostActivityResponse getCloudCostActivity() throws ApiException {
        return this.getCloudCostActivityWithHttpInfo().getData();
    }

    public CompletableFuture<CloudCostActivityResponse> getCloudCostActivityAsync() {
        return this.getCloudCostActivityWithHttpInfoAsync().thenApply(response -> (CloudCostActivityResponse)response.getData());
    }

    public ApiResponse<CloudCostActivityResponse> getCloudCostActivityWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/cost/enabled";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.getCloudCostActivity", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CloudCostActivityResponse>(){});
    }

    public CompletableFuture<ApiResponse<CloudCostActivityResponse>> getCloudCostActivityWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/cost/enabled";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.getCloudCostActivity", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CloudCostActivityResponse>> result = new CompletableFuture<ApiResponse<CloudCostActivityResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CloudCostActivityResponse>(){});
    }

    public AWSRelatedAccountsResponse listAWSRelatedAccounts(String filterManagementAccountId) throws ApiException {
        return this.listAWSRelatedAccountsWithHttpInfo(filterManagementAccountId).getData();
    }

    public CompletableFuture<AWSRelatedAccountsResponse> listAWSRelatedAccountsAsync(String filterManagementAccountId) {
        return this.listAWSRelatedAccountsWithHttpInfoAsync(filterManagementAccountId).thenApply(response -> (AWSRelatedAccountsResponse)response.getData());
    }

    public ApiResponse<AWSRelatedAccountsResponse> listAWSRelatedAccountsWithHttpInfo(String filterManagementAccountId) throws ApiException {
        Object localVarPostBody = null;
        if (filterManagementAccountId == null) {
            throw new ApiException(400, "Missing the required parameter 'filterManagementAccountId' when calling listAWSRelatedAccounts");
        }
        String localVarPath = "/api/v2/cost/aws_related_accounts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[management_account_id]", filterManagementAccountId));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.listAWSRelatedAccounts", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AWSRelatedAccountsResponse>(){});
    }

    public CompletableFuture<ApiResponse<AWSRelatedAccountsResponse>> listAWSRelatedAccountsWithHttpInfoAsync(String filterManagementAccountId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (filterManagementAccountId == null) {
            CompletableFuture<ApiResponse<AWSRelatedAccountsResponse>> result = new CompletableFuture<ApiResponse<AWSRelatedAccountsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'filterManagementAccountId' when calling listAWSRelatedAccounts"));
            return result;
        }
        String localVarPath = "/api/v2/cost/aws_related_accounts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[management_account_id]", filterManagementAccountId));
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.listAWSRelatedAccounts", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AWSRelatedAccountsResponse>> result = new CompletableFuture<ApiResponse<AWSRelatedAccountsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AWSRelatedAccountsResponse>(){});
    }

    public AwsCURConfigsResponse listCostAWSCURConfigs() throws ApiException {
        return this.listCostAWSCURConfigsWithHttpInfo().getData();
    }

    public CompletableFuture<AwsCURConfigsResponse> listCostAWSCURConfigsAsync() {
        return this.listCostAWSCURConfigsWithHttpInfoAsync().thenApply(response -> (AwsCURConfigsResponse)response.getData());
    }

    public ApiResponse<AwsCURConfigsResponse> listCostAWSCURConfigsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/cost/aws_cur_config";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.listCostAWSCURConfigs", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AwsCURConfigsResponse>(){});
    }

    public CompletableFuture<ApiResponse<AwsCURConfigsResponse>> listCostAWSCURConfigsWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/cost/aws_cur_config";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.listCostAWSCURConfigs", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AwsCURConfigsResponse>> result = new CompletableFuture<ApiResponse<AwsCURConfigsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AwsCURConfigsResponse>(){});
    }

    public AzureUCConfigsResponse listCostAzureUCConfigs() throws ApiException {
        return this.listCostAzureUCConfigsWithHttpInfo().getData();
    }

    public CompletableFuture<AzureUCConfigsResponse> listCostAzureUCConfigsAsync() {
        return this.listCostAzureUCConfigsWithHttpInfoAsync().thenApply(response -> (AzureUCConfigsResponse)response.getData());
    }

    public ApiResponse<AzureUCConfigsResponse> listCostAzureUCConfigsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/cost/azure_uc_config";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.listCostAzureUCConfigs", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AzureUCConfigsResponse>(){});
    }

    public CompletableFuture<ApiResponse<AzureUCConfigsResponse>> listCostAzureUCConfigsWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/cost/azure_uc_config";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.listCostAzureUCConfigs", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AzureUCConfigsResponse>> result = new CompletableFuture<ApiResponse<AzureUCConfigsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AzureUCConfigsResponse>(){});
    }

    public AwsCURConfigsResponse updateCostAWSCURConfig(String cloudAccountId, AwsCURConfigPatchRequest body) throws ApiException {
        return this.updateCostAWSCURConfigWithHttpInfo(cloudAccountId, body).getData();
    }

    public CompletableFuture<AwsCURConfigsResponse> updateCostAWSCURConfigAsync(String cloudAccountId, AwsCURConfigPatchRequest body) {
        return this.updateCostAWSCURConfigWithHttpInfoAsync(cloudAccountId, body).thenApply(response -> (AwsCURConfigsResponse)response.getData());
    }

    public ApiResponse<AwsCURConfigsResponse> updateCostAWSCURConfigWithHttpInfo(String cloudAccountId, AwsCURConfigPatchRequest body) throws ApiException {
        AwsCURConfigPatchRequest localVarPostBody = body;
        if (cloudAccountId == null) {
            throw new ApiException(400, "Missing the required parameter 'cloudAccountId' when calling updateCostAWSCURConfig");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateCostAWSCURConfig");
        }
        String localVarPath = "/api/v2/cost/aws_cur_config/{cloud_account_id}".replaceAll("\\{cloud_account_id\\}", this.apiClient.escapeString(cloudAccountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.updateCostAWSCURConfig", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AwsCURConfigsResponse>(){});
    }

    public CompletableFuture<ApiResponse<AwsCURConfigsResponse>> updateCostAWSCURConfigWithHttpInfoAsync(String cloudAccountId, AwsCURConfigPatchRequest body) {
        Invocation.Builder builder;
        AwsCURConfigPatchRequest localVarPostBody = body;
        if (cloudAccountId == null) {
            CompletableFuture<ApiResponse<AwsCURConfigsResponse>> result = new CompletableFuture<ApiResponse<AwsCURConfigsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'cloudAccountId' when calling updateCostAWSCURConfig"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<AwsCURConfigsResponse>> result = new CompletableFuture<ApiResponse<AwsCURConfigsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateCostAWSCURConfig"));
            return result;
        }
        String localVarPath = "/api/v2/cost/aws_cur_config/{cloud_account_id}".replaceAll("\\{cloud_account_id\\}", this.apiClient.escapeString(cloudAccountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.updateCostAWSCURConfig", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AwsCURConfigsResponse>> result = new CompletableFuture<ApiResponse<AwsCURConfigsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AwsCURConfigsResponse>(){});
    }

    public AzureUCConfigPairsResponse updateCostAzureUCConfigs(String cloudAccountId, AzureUCConfigPatchRequest body) throws ApiException {
        return this.updateCostAzureUCConfigsWithHttpInfo(cloudAccountId, body).getData();
    }

    public CompletableFuture<AzureUCConfigPairsResponse> updateCostAzureUCConfigsAsync(String cloudAccountId, AzureUCConfigPatchRequest body) {
        return this.updateCostAzureUCConfigsWithHttpInfoAsync(cloudAccountId, body).thenApply(response -> (AzureUCConfigPairsResponse)response.getData());
    }

    public ApiResponse<AzureUCConfigPairsResponse> updateCostAzureUCConfigsWithHttpInfo(String cloudAccountId, AzureUCConfigPatchRequest body) throws ApiException {
        AzureUCConfigPatchRequest localVarPostBody = body;
        if (cloudAccountId == null) {
            throw new ApiException(400, "Missing the required parameter 'cloudAccountId' when calling updateCostAzureUCConfigs");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateCostAzureUCConfigs");
        }
        String localVarPath = "/api/v2/cost/azure_uc_config/{cloud_account_id}".replaceAll("\\{cloud_account_id\\}", this.apiClient.escapeString(cloudAccountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.updateCostAzureUCConfigs", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AzureUCConfigPairsResponse>(){});
    }

    public CompletableFuture<ApiResponse<AzureUCConfigPairsResponse>> updateCostAzureUCConfigsWithHttpInfoAsync(String cloudAccountId, AzureUCConfigPatchRequest body) {
        Invocation.Builder builder;
        AzureUCConfigPatchRequest localVarPostBody = body;
        if (cloudAccountId == null) {
            CompletableFuture<ApiResponse<AzureUCConfigPairsResponse>> result = new CompletableFuture<ApiResponse<AzureUCConfigPairsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'cloudAccountId' when calling updateCostAzureUCConfigs"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<AzureUCConfigPairsResponse>> result = new CompletableFuture<ApiResponse<AzureUCConfigPairsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateCostAzureUCConfigs"));
            return result;
        }
        String localVarPath = "/api/v2/cost/azure_uc_config/{cloud_account_id}".replaceAll("\\{cloud_account_id\\}", this.apiClient.escapeString(cloudAccountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CloudCostManagementApi.updateCostAzureUCConfigs", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AzureUCConfigPairsResponse>> result = new CompletableFuture<ApiResponse<AzureUCConfigPairsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AzureUCConfigPairsResponse>(){});
    }
}

