/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.DORADeploymentRequest;
import com.datadog.api.client.v2.model.DORADeploymentResponse;
import com.datadog.api.client.v2.model.DORAIncidentRequest;
import com.datadog.api.client.v2.model.DORAIncidentResponse;
import com.datadoghq.jakarta.ws.rs.client.Invocation;
import com.datadoghq.jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class DoraMetricsApi {
    private ApiClient apiClient;

    public DoraMetricsApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public DoraMetricsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public DORADeploymentResponse createDORADeployment(DORADeploymentRequest body) throws ApiException {
        return this.createDORADeploymentWithHttpInfo(body).getData();
    }

    public CompletableFuture<DORADeploymentResponse> createDORADeploymentAsync(DORADeploymentRequest body) {
        return this.createDORADeploymentWithHttpInfoAsync(body).thenApply(response -> (DORADeploymentResponse)response.getData());
    }

    public ApiResponse<DORADeploymentResponse> createDORADeploymentWithHttpInfo(DORADeploymentRequest body) throws ApiException {
        String operationId = "createDORADeployment";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        DORADeploymentRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createDORADeployment");
        }
        String localVarPath = "/api/v2/dora/deployment";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.DoraMetricsApi.createDORADeployment", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DORADeploymentResponse>(){});
    }

    public CompletableFuture<ApiResponse<DORADeploymentResponse>> createDORADeploymentWithHttpInfoAsync(DORADeploymentRequest body) {
        Invocation.Builder builder;
        String operationId = "createDORADeployment";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<DORADeploymentResponse>> result = new CompletableFuture<ApiResponse<DORADeploymentResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        DORADeploymentRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<DORADeploymentResponse>> result = new CompletableFuture<ApiResponse<DORADeploymentResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createDORADeployment"));
            return result;
        }
        String localVarPath = "/api/v2/dora/deployment";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.DoraMetricsApi.createDORADeployment", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DORADeploymentResponse>> result = new CompletableFuture<ApiResponse<DORADeploymentResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DORADeploymentResponse>(){});
    }

    public DORAIncidentResponse createDORAIncident(DORAIncidentRequest body) throws ApiException {
        return this.createDORAIncidentWithHttpInfo(body).getData();
    }

    public CompletableFuture<DORAIncidentResponse> createDORAIncidentAsync(DORAIncidentRequest body) {
        return this.createDORAIncidentWithHttpInfoAsync(body).thenApply(response -> (DORAIncidentResponse)response.getData());
    }

    public ApiResponse<DORAIncidentResponse> createDORAIncidentWithHttpInfo(DORAIncidentRequest body) throws ApiException {
        String operationId = "createDORAIncident";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        DORAIncidentRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createDORAIncident");
        }
        String localVarPath = "/api/v2/dora/incident";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.DoraMetricsApi.createDORAIncident", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DORAIncidentResponse>(){});
    }

    public CompletableFuture<ApiResponse<DORAIncidentResponse>> createDORAIncidentWithHttpInfoAsync(DORAIncidentRequest body) {
        Invocation.Builder builder;
        String operationId = "createDORAIncident";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<DORAIncidentResponse>> result = new CompletableFuture<ApiResponse<DORAIncidentResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        DORAIncidentRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<DORAIncidentResponse>> result = new CompletableFuture<ApiResponse<DORAIncidentResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createDORAIncident"));
            return result;
        }
        String localVarPath = "/api/v2/dora/incident";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.DoraMetricsApi.createDORAIncident", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DORAIncidentResponse>> result = new CompletableFuture<ApiResponse<DORAIncidentResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DORAIncidentResponse>(){});
    }
}

