/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.PaginationIterable;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.DowntimeCreateRequest;
import com.datadog.api.client.v2.model.DowntimeResponse;
import com.datadog.api.client.v2.model.DowntimeResponseData;
import com.datadog.api.client.v2.model.DowntimeUpdateRequest;
import com.datadog.api.client.v2.model.ListDowntimesResponse;
import com.datadog.api.client.v2.model.MonitorDowntimeMatchResponse;
import com.datadog.api.client.v2.model.MonitorDowntimeMatchResponseData;
import com.datadoghq.jakarta.ws.rs.client.Invocation;
import com.datadoghq.jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.concurrent.CompletableFuture;

public class DowntimesApi {
    private ApiClient apiClient;

    public DowntimesApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public DowntimesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void cancelDowntime(String downtimeId) throws ApiException {
        this.cancelDowntimeWithHttpInfo(downtimeId);
    }

    public CompletableFuture<Void> cancelDowntimeAsync(String downtimeId) {
        return this.cancelDowntimeWithHttpInfoAsync(downtimeId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> cancelDowntimeWithHttpInfo(String downtimeId) throws ApiException {
        Object localVarPostBody = null;
        if (downtimeId == null) {
            throw new ApiException(400, "Missing the required parameter 'downtimeId' when calling cancelDowntime");
        }
        String localVarPath = "/api/v2/downtime/{downtime_id}".replaceAll("\\{downtime_id\\}", this.apiClient.escapeString(downtimeId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.DowntimesApi.cancelDowntime", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> cancelDowntimeWithHttpInfoAsync(String downtimeId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (downtimeId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'downtimeId' when calling cancelDowntime"));
            return result;
        }
        String localVarPath = "/api/v2/downtime/{downtime_id}".replaceAll("\\{downtime_id\\}", this.apiClient.escapeString(downtimeId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.DowntimesApi.cancelDowntime", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public DowntimeResponse createDowntime(DowntimeCreateRequest body) throws ApiException {
        return this.createDowntimeWithHttpInfo(body).getData();
    }

    public CompletableFuture<DowntimeResponse> createDowntimeAsync(DowntimeCreateRequest body) {
        return this.createDowntimeWithHttpInfoAsync(body).thenApply(response -> (DowntimeResponse)response.getData());
    }

    public ApiResponse<DowntimeResponse> createDowntimeWithHttpInfo(DowntimeCreateRequest body) throws ApiException {
        DowntimeCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createDowntime");
        }
        String localVarPath = "/api/v2/downtime";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.DowntimesApi.createDowntime", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DowntimeResponse>(){});
    }

    public CompletableFuture<ApiResponse<DowntimeResponse>> createDowntimeWithHttpInfoAsync(DowntimeCreateRequest body) {
        Invocation.Builder builder;
        DowntimeCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<DowntimeResponse>> result = new CompletableFuture<ApiResponse<DowntimeResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createDowntime"));
            return result;
        }
        String localVarPath = "/api/v2/downtime";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.DowntimesApi.createDowntime", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DowntimeResponse>> result = new CompletableFuture<ApiResponse<DowntimeResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DowntimeResponse>(){});
    }

    public DowntimeResponse getDowntime(String downtimeId) throws ApiException {
        return this.getDowntimeWithHttpInfo(downtimeId, new GetDowntimeOptionalParameters()).getData();
    }

    public CompletableFuture<DowntimeResponse> getDowntimeAsync(String downtimeId) {
        return this.getDowntimeWithHttpInfoAsync(downtimeId, new GetDowntimeOptionalParameters()).thenApply(response -> (DowntimeResponse)response.getData());
    }

    public DowntimeResponse getDowntime(String downtimeId, GetDowntimeOptionalParameters parameters) throws ApiException {
        return this.getDowntimeWithHttpInfo(downtimeId, parameters).getData();
    }

    public CompletableFuture<DowntimeResponse> getDowntimeAsync(String downtimeId, GetDowntimeOptionalParameters parameters) {
        return this.getDowntimeWithHttpInfoAsync(downtimeId, parameters).thenApply(response -> (DowntimeResponse)response.getData());
    }

    public ApiResponse<DowntimeResponse> getDowntimeWithHttpInfo(String downtimeId, GetDowntimeOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (downtimeId == null) {
            throw new ApiException(400, "Missing the required parameter 'downtimeId' when calling getDowntime");
        }
        String include = parameters.include;
        String localVarPath = "/api/v2/downtime/{downtime_id}".replaceAll("\\{downtime_id\\}", this.apiClient.escapeString(downtimeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.DowntimesApi.getDowntime", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DowntimeResponse>(){});
    }

    public CompletableFuture<ApiResponse<DowntimeResponse>> getDowntimeWithHttpInfoAsync(String downtimeId, GetDowntimeOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (downtimeId == null) {
            CompletableFuture<ApiResponse<DowntimeResponse>> result = new CompletableFuture<ApiResponse<DowntimeResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'downtimeId' when calling getDowntime"));
            return result;
        }
        String include = parameters.include;
        String localVarPath = "/api/v2/downtime/{downtime_id}".replaceAll("\\{downtime_id\\}", this.apiClient.escapeString(downtimeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        try {
            builder = this.apiClient.createBuilder("v2.DowntimesApi.getDowntime", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DowntimeResponse>> result = new CompletableFuture<ApiResponse<DowntimeResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DowntimeResponse>(){});
    }

    public ListDowntimesResponse listDowntimes() throws ApiException {
        return this.listDowntimesWithHttpInfo(new ListDowntimesOptionalParameters()).getData();
    }

    public CompletableFuture<ListDowntimesResponse> listDowntimesAsync() {
        return this.listDowntimesWithHttpInfoAsync(new ListDowntimesOptionalParameters()).thenApply(response -> (ListDowntimesResponse)response.getData());
    }

    public ListDowntimesResponse listDowntimes(ListDowntimesOptionalParameters parameters) throws ApiException {
        return this.listDowntimesWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<ListDowntimesResponse> listDowntimesAsync(ListDowntimesOptionalParameters parameters) {
        return this.listDowntimesWithHttpInfoAsync(parameters).thenApply(response -> (ListDowntimesResponse)response.getData());
    }

    public PaginationIterable<DowntimeResponseData> listDowntimesWithPagination() {
        ListDowntimesOptionalParameters parameters = new ListDowntimesOptionalParameters();
        return this.listDowntimesWithPagination(parameters);
    }

    public PaginationIterable<DowntimeResponseData> listDowntimesWithPagination(ListDowntimesOptionalParameters parameters) {
        Long limit;
        String resultsPath = "getData";
        String valueGetterPath = "";
        String valueSetterPath = "pageOffset";
        Boolean valueSetterParamOptional = true;
        if (parameters.pageLimit == null) {
            limit = 30L;
            parameters.pageLimit(limit);
        } else {
            limit = parameters.pageLimit;
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("optionalParams", parameters);
        PaginationIterable<DowntimeResponseData> iterator = new PaginationIterable<DowntimeResponseData>(this, "listDowntimes", resultsPath, valueGetterPath, valueSetterPath, valueSetterParamOptional, true, limit, args);
        return iterator;
    }

    public ApiResponse<ListDowntimesResponse> listDowntimesWithHttpInfo(ListDowntimesOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        Boolean currentOnly = parameters.currentOnly;
        String include = parameters.include;
        Long pageOffset = parameters.pageOffset;
        Long pageLimit = parameters.pageLimit;
        String localVarPath = "/api/v2/downtime";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "current_only", currentOnly));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[offset]", pageOffset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.DowntimesApi.listDowntimes", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListDowntimesResponse>(){});
    }

    public CompletableFuture<ApiResponse<ListDowntimesResponse>> listDowntimesWithHttpInfoAsync(ListDowntimesOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        Boolean currentOnly = parameters.currentOnly;
        String include = parameters.include;
        Long pageOffset = parameters.pageOffset;
        Long pageLimit = parameters.pageLimit;
        String localVarPath = "/api/v2/downtime";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "current_only", currentOnly));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[offset]", pageOffset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        try {
            builder = this.apiClient.createBuilder("v2.DowntimesApi.listDowntimes", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ListDowntimesResponse>> result = new CompletableFuture<ApiResponse<ListDowntimesResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListDowntimesResponse>(){});
    }

    public MonitorDowntimeMatchResponse listMonitorDowntimes(Long monitorId) throws ApiException {
        return this.listMonitorDowntimesWithHttpInfo(monitorId, new ListMonitorDowntimesOptionalParameters()).getData();
    }

    public CompletableFuture<MonitorDowntimeMatchResponse> listMonitorDowntimesAsync(Long monitorId) {
        return this.listMonitorDowntimesWithHttpInfoAsync(monitorId, new ListMonitorDowntimesOptionalParameters()).thenApply(response -> (MonitorDowntimeMatchResponse)response.getData());
    }

    public MonitorDowntimeMatchResponse listMonitorDowntimes(Long monitorId, ListMonitorDowntimesOptionalParameters parameters) throws ApiException {
        return this.listMonitorDowntimesWithHttpInfo(monitorId, parameters).getData();
    }

    public CompletableFuture<MonitorDowntimeMatchResponse> listMonitorDowntimesAsync(Long monitorId, ListMonitorDowntimesOptionalParameters parameters) {
        return this.listMonitorDowntimesWithHttpInfoAsync(monitorId, parameters).thenApply(response -> (MonitorDowntimeMatchResponse)response.getData());
    }

    public PaginationIterable<MonitorDowntimeMatchResponseData> listMonitorDowntimesWithPagination(Long monitorId) {
        ListMonitorDowntimesOptionalParameters parameters = new ListMonitorDowntimesOptionalParameters();
        return this.listMonitorDowntimesWithPagination(monitorId, parameters);
    }

    public PaginationIterable<MonitorDowntimeMatchResponseData> listMonitorDowntimesWithPagination(Long monitorId, ListMonitorDowntimesOptionalParameters parameters) {
        Long limit;
        String resultsPath = "getData";
        String valueGetterPath = "";
        String valueSetterPath = "pageOffset";
        Boolean valueSetterParamOptional = true;
        if (parameters.pageLimit == null) {
            limit = 30L;
            parameters.pageLimit(limit);
        } else {
            limit = parameters.pageLimit;
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("monitorId", monitorId);
        args.put("optionalParams", parameters);
        PaginationIterable<MonitorDowntimeMatchResponseData> iterator = new PaginationIterable<MonitorDowntimeMatchResponseData>(this, "listMonitorDowntimes", resultsPath, valueGetterPath, valueSetterPath, valueSetterParamOptional, true, limit, args);
        return iterator;
    }

    public ApiResponse<MonitorDowntimeMatchResponse> listMonitorDowntimesWithHttpInfo(Long monitorId, ListMonitorDowntimesOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (monitorId == null) {
            throw new ApiException(400, "Missing the required parameter 'monitorId' when calling listMonitorDowntimes");
        }
        Long pageOffset = parameters.pageOffset;
        Long pageLimit = parameters.pageLimit;
        String localVarPath = "/api/v2/monitor/{monitor_id}/downtime_matches".replaceAll("\\{monitor_id\\}", this.apiClient.escapeString(monitorId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[offset]", pageOffset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.DowntimesApi.listMonitorDowntimes", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MonitorDowntimeMatchResponse>(){});
    }

    public CompletableFuture<ApiResponse<MonitorDowntimeMatchResponse>> listMonitorDowntimesWithHttpInfoAsync(Long monitorId, ListMonitorDowntimesOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (monitorId == null) {
            CompletableFuture<ApiResponse<MonitorDowntimeMatchResponse>> result = new CompletableFuture<ApiResponse<MonitorDowntimeMatchResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'monitorId' when calling listMonitorDowntimes"));
            return result;
        }
        Long pageOffset = parameters.pageOffset;
        Long pageLimit = parameters.pageLimit;
        String localVarPath = "/api/v2/monitor/{monitor_id}/downtime_matches".replaceAll("\\{monitor_id\\}", this.apiClient.escapeString(monitorId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[offset]", pageOffset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        try {
            builder = this.apiClient.createBuilder("v2.DowntimesApi.listMonitorDowntimes", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<MonitorDowntimeMatchResponse>> result = new CompletableFuture<ApiResponse<MonitorDowntimeMatchResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MonitorDowntimeMatchResponse>(){});
    }

    public DowntimeResponse updateDowntime(String downtimeId, DowntimeUpdateRequest body) throws ApiException {
        return this.updateDowntimeWithHttpInfo(downtimeId, body).getData();
    }

    public CompletableFuture<DowntimeResponse> updateDowntimeAsync(String downtimeId, DowntimeUpdateRequest body) {
        return this.updateDowntimeWithHttpInfoAsync(downtimeId, body).thenApply(response -> (DowntimeResponse)response.getData());
    }

    public ApiResponse<DowntimeResponse> updateDowntimeWithHttpInfo(String downtimeId, DowntimeUpdateRequest body) throws ApiException {
        DowntimeUpdateRequest localVarPostBody = body;
        if (downtimeId == null) {
            throw new ApiException(400, "Missing the required parameter 'downtimeId' when calling updateDowntime");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateDowntime");
        }
        String localVarPath = "/api/v2/downtime/{downtime_id}".replaceAll("\\{downtime_id\\}", this.apiClient.escapeString(downtimeId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.DowntimesApi.updateDowntime", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DowntimeResponse>(){});
    }

    public CompletableFuture<ApiResponse<DowntimeResponse>> updateDowntimeWithHttpInfoAsync(String downtimeId, DowntimeUpdateRequest body) {
        Invocation.Builder builder;
        DowntimeUpdateRequest localVarPostBody = body;
        if (downtimeId == null) {
            CompletableFuture<ApiResponse<DowntimeResponse>> result = new CompletableFuture<ApiResponse<DowntimeResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'downtimeId' when calling updateDowntime"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<DowntimeResponse>> result = new CompletableFuture<ApiResponse<DowntimeResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateDowntime"));
            return result;
        }
        String localVarPath = "/api/v2/downtime/{downtime_id}".replaceAll("\\{downtime_id\\}", this.apiClient.escapeString(downtimeId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.DowntimesApi.updateDowntime", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DowntimeResponse>> result = new CompletableFuture<ApiResponse<DowntimeResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DowntimeResponse>(){});
    }

    public static class ListMonitorDowntimesOptionalParameters {
        private Long pageOffset;
        private Long pageLimit;

        public ListMonitorDowntimesOptionalParameters pageOffset(Long pageOffset) {
            this.pageOffset = pageOffset;
            return this;
        }

        public ListMonitorDowntimesOptionalParameters pageLimit(Long pageLimit) {
            this.pageLimit = pageLimit;
            return this;
        }
    }

    public static class ListDowntimesOptionalParameters {
        private Boolean currentOnly;
        private String include;
        private Long pageOffset;
        private Long pageLimit;

        public ListDowntimesOptionalParameters currentOnly(Boolean currentOnly) {
            this.currentOnly = currentOnly;
            return this;
        }

        public ListDowntimesOptionalParameters include(String include) {
            this.include = include;
            return this;
        }

        public ListDowntimesOptionalParameters pageOffset(Long pageOffset) {
            this.pageOffset = pageOffset;
            return this;
        }

        public ListDowntimesOptionalParameters pageLimit(Long pageLimit) {
            this.pageLimit = pageLimit;
            return this;
        }
    }

    public static class GetDowntimeOptionalParameters {
        private String include;

        public GetDowntimeOptionalParameters include(String include) {
            this.include = include;
            return this;
        }
    }
}

