/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.com.github.scribejava.core.builder.api;

import com.datadoghq.com.github.scribejava.core.builder.api.OAuth1SignatureType;
import com.datadoghq.com.github.scribejava.core.extractors.BaseStringExtractor;
import com.datadoghq.com.github.scribejava.core.extractors.BaseStringExtractorImpl;
import com.datadoghq.com.github.scribejava.core.extractors.HeaderExtractor;
import com.datadoghq.com.github.scribejava.core.extractors.HeaderExtractorImpl;
import com.datadoghq.com.github.scribejava.core.extractors.OAuth1AccessTokenExtractor;
import com.datadoghq.com.github.scribejava.core.extractors.OAuth1RequestTokenExtractor;
import com.datadoghq.com.github.scribejava.core.extractors.TokenExtractor;
import com.datadoghq.com.github.scribejava.core.httpclient.HttpClient;
import com.datadoghq.com.github.scribejava.core.httpclient.HttpClientConfig;
import com.datadoghq.com.github.scribejava.core.model.OAuth1AccessToken;
import com.datadoghq.com.github.scribejava.core.model.OAuth1RequestToken;
import com.datadoghq.com.github.scribejava.core.model.ParameterList;
import com.datadoghq.com.github.scribejava.core.model.Verb;
import com.datadoghq.com.github.scribejava.core.oauth.OAuth10aService;
import com.datadoghq.com.github.scribejava.core.services.HMACSha1SignatureService;
import com.datadoghq.com.github.scribejava.core.services.SignatureService;
import com.datadoghq.com.github.scribejava.core.services.TimestampService;
import com.datadoghq.com.github.scribejava.core.services.TimestampServiceImpl;
import java.io.OutputStream;

public abstract class DefaultApi10a {
    public TokenExtractor<OAuth1AccessToken> getAccessTokenExtractor() {
        return OAuth1AccessTokenExtractor.instance();
    }

    public BaseStringExtractor getBaseStringExtractor() {
        return new BaseStringExtractorImpl();
    }

    public HeaderExtractor getHeaderExtractor() {
        return new HeaderExtractorImpl();
    }

    public TokenExtractor<OAuth1RequestToken> getRequestTokenExtractor() {
        return OAuth1RequestTokenExtractor.instance();
    }

    public SignatureService getSignatureService() {
        return new HMACSha1SignatureService();
    }

    public OAuth1SignatureType getSignatureType() {
        return OAuth1SignatureType.HEADER;
    }

    public TimestampService getTimestampService() {
        return new TimestampServiceImpl();
    }

    public Verb getAccessTokenVerb() {
        return Verb.POST;
    }

    public Verb getRequestTokenVerb() {
        return Verb.POST;
    }

    public abstract String getRequestTokenEndpoint();

    public abstract String getAccessTokenEndpoint();

    protected abstract String getAuthorizationBaseUrl();

    public String getAuthorizationUrl(OAuth1RequestToken requestToken) {
        ParameterList parameters = new ParameterList();
        parameters.add("oauth_token", requestToken.getToken());
        return parameters.appendTo(this.getAuthorizationBaseUrl());
    }

    public OAuth10aService createService(String apiKey, String apiSecret, String callback, String scope, OutputStream debugStream, String userAgent, HttpClientConfig httpClientConfig, HttpClient httpClient) {
        return new OAuth10aService(this, apiKey, apiSecret, callback, scope, debugStream, userAgent, httpClientConfig, httpClient);
    }

    public boolean isEmptyOAuthTokenParamIsRequired() {
        return false;
    }
}

