/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.org.glassfish.jersey.jackson;

import com.datadoghq.jakarta.ws.rs.core.Configuration;
import com.datadoghq.jakarta.ws.rs.core.Feature;
import com.datadoghq.jakarta.ws.rs.core.FeatureContext;
import com.datadoghq.jakarta.ws.rs.ext.MessageBodyReader;
import com.datadoghq.jakarta.ws.rs.ext.MessageBodyWriter;
import com.datadoghq.org.glassfish.jersey.CommonProperties;
import com.datadoghq.org.glassfish.jersey.internal.util.PropertiesHelper;
import com.datadoghq.org.glassfish.jersey.jackson.internal.DefaultJacksonJaxbJsonProvider;
import com.datadoghq.org.glassfish.jersey.jackson.internal.FilteringJacksonJaxbJsonProvider;
import com.datadoghq.org.glassfish.jersey.jackson.internal.JacksonFilteringFeature;
import com.datadoghq.org.glassfish.jersey.jackson.internal.jackson.jaxrs.base.JsonMappingExceptionMapper;
import com.datadoghq.org.glassfish.jersey.jackson.internal.jackson.jaxrs.base.JsonParseExceptionMapper;
import com.datadoghq.org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import com.datadoghq.org.glassfish.jersey.message.filtering.EntityFilteringFeature;

public class JacksonFeature
implements Feature {
    private final boolean registerExceptionMappers;
    private static final String JSON_FEATURE = JacksonFeature.class.getSimpleName();

    public JacksonFeature() {
        this(true);
    }

    private JacksonFeature(boolean registerExceptionMappers) {
        this.registerExceptionMappers = registerExceptionMappers;
    }

    public static JacksonFeature withExceptionMappers() {
        return new JacksonFeature();
    }

    public static JacksonFeature withoutExceptionMappers() {
        return new JacksonFeature(false);
    }

    @Override
    public boolean configure(FeatureContext context) {
        Configuration config = context.getConfiguration();
        String jsonFeature = CommonProperties.getValue(config.getProperties(), config.getRuntimeType(), "jersey.config.jsonFeature", JSON_FEATURE, String.class);
        if (!JSON_FEATURE.equalsIgnoreCase(jsonFeature)) {
            return false;
        }
        context.property(PropertiesHelper.getPropertyNameForRuntime("jersey.config.jsonFeature", config.getRuntimeType()), JSON_FEATURE);
        if (!config.isRegistered(JacksonJaxbJsonProvider.class)) {
            if (this.registerExceptionMappers) {
                context.register(JsonParseExceptionMapper.class);
                context.register(JsonMappingExceptionMapper.class);
            }
            if (EntityFilteringFeature.enabled(config)) {
                context.register(JacksonFilteringFeature.class);
                context.register(FilteringJacksonJaxbJsonProvider.class, MessageBodyReader.class, MessageBodyWriter.class);
            } else {
                context.register(DefaultJacksonJaxbJsonProvider.class, MessageBodyReader.class, MessageBodyWriter.class);
            }
        }
        return true;
    }
}

