/*
 * Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2019-Present Datadog, Inc.
 */

package com.datadog.api.client.v1.model;

import com.datadog.api.client.ModelEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/** Type of the log stream widget. */
@JsonSerialize(using = LogStreamWidgetDefinitionType.LogStreamWidgetDefinitionTypeSerializer.class)
public class LogStreamWidgetDefinitionType extends ModelEnum<String> {

  private static final Set<String> allowedValues = new HashSet<String>(Arrays.asList("log_stream"));

  public static final LogStreamWidgetDefinitionType LOG_STREAM =
      new LogStreamWidgetDefinitionType("log_stream");

  LogStreamWidgetDefinitionType(String value) {
    super(value, allowedValues);
  }

  public static class LogStreamWidgetDefinitionTypeSerializer
      extends StdSerializer<LogStreamWidgetDefinitionType> {
    public LogStreamWidgetDefinitionTypeSerializer(Class<LogStreamWidgetDefinitionType> t) {
      super(t);
    }

    public LogStreamWidgetDefinitionTypeSerializer() {
      this(null);
    }

    @Override
    public void serialize(
        LogStreamWidgetDefinitionType value, JsonGenerator jgen, SerializerProvider provider)
        throws IOException, JsonProcessingException {
      jgen.writeObject(value.value);
    }
  }

  @JsonCreator
  public static LogStreamWidgetDefinitionType fromValue(String value) {
    return new LogStreamWidgetDefinitionType(value);
  }
}
