/*
 * Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2019-Present Datadog, Inc.
 */

package com.datadog.api.client.v1.model;

import com.datadog.api.client.ModelEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/** Width of line displayed. */
@JsonSerialize(using = WidgetLineWidth.WidgetLineWidthSerializer.class)
public class WidgetLineWidth extends ModelEnum<String> {

  private static final Set<String> allowedValues =
      new HashSet<String>(Arrays.asList("normal", "thick", "thin"));

  public static final WidgetLineWidth NORMAL = new WidgetLineWidth("normal");
  public static final WidgetLineWidth THICK = new WidgetLineWidth("thick");
  public static final WidgetLineWidth THIN = new WidgetLineWidth("thin");

  WidgetLineWidth(String value) {
    super(value, allowedValues);
  }

  public static class WidgetLineWidthSerializer extends StdSerializer<WidgetLineWidth> {
    public WidgetLineWidthSerializer(Class<WidgetLineWidth> t) {
      super(t);
    }

    public WidgetLineWidthSerializer() {
      this(null);
    }

    @Override
    public void serialize(WidgetLineWidth value, JsonGenerator jgen, SerializerProvider provider)
        throws IOException, JsonProcessingException {
      jgen.writeObject(value.value);
    }
  }

  @JsonCreator
  public static WidgetLineWidth fromValue(String value) {
    return new WidgetLineWidth(value);
  }
}
