/*
 * Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2019-Present Datadog, Inc.
 */

package com.datadog.api.client.v2.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/** Attributes of AuthN Mapping. */
@JsonPropertyOrder({
  AuthNMappingAttributes.JSON_PROPERTY_ATTRIBUTE_KEY,
  AuthNMappingAttributes.JSON_PROPERTY_ATTRIBUTE_VALUE,
  AuthNMappingAttributes.JSON_PROPERTY_CREATED_AT,
  AuthNMappingAttributes.JSON_PROPERTY_MODIFIED_AT,
  AuthNMappingAttributes.JSON_PROPERTY_SAML_ASSERTION_ATTRIBUTE_ID
})
@jakarta.annotation.Generated(
    value = "https://github.com/DataDog/datadog-api-client-java/blob/master/.generator")
public class AuthNMappingAttributes {
  @JsonIgnore public boolean unparsed = false;
  public static final String JSON_PROPERTY_ATTRIBUTE_KEY = "attribute_key";
  private String attributeKey;

  public static final String JSON_PROPERTY_ATTRIBUTE_VALUE = "attribute_value";
  private String attributeValue;

  public static final String JSON_PROPERTY_CREATED_AT = "created_at";
  private OffsetDateTime createdAt;

  public static final String JSON_PROPERTY_MODIFIED_AT = "modified_at";
  private OffsetDateTime modifiedAt;

  public static final String JSON_PROPERTY_SAML_ASSERTION_ATTRIBUTE_ID =
      "saml_assertion_attribute_id";
  private String samlAssertionAttributeId;

  public AuthNMappingAttributes attributeKey(String attributeKey) {
    this.attributeKey = attributeKey;
    return this;
  }

  /**
   * Key portion of a key/value pair of the attribute sent from the Identity Provider.
   *
   * @return attributeKey
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ATTRIBUTE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAttributeKey() {
    return attributeKey;
  }

  public void setAttributeKey(String attributeKey) {
    this.attributeKey = attributeKey;
  }

  public AuthNMappingAttributes attributeValue(String attributeValue) {
    this.attributeValue = attributeValue;
    return this;
  }

  /**
   * Value portion of a key/value pair of the attribute sent from the Identity Provider.
   *
   * @return attributeValue
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ATTRIBUTE_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAttributeValue() {
    return attributeValue;
  }

  public void setAttributeValue(String attributeValue) {
    this.attributeValue = attributeValue;
  }

  /**
   * Creation time of the AuthN Mapping.
   *
   * @return createdAt
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  /**
   * Time of last AuthN Mapping modification.
   *
   * @return modifiedAt
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MODIFIED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getModifiedAt() {
    return modifiedAt;
  }

  public AuthNMappingAttributes samlAssertionAttributeId(String samlAssertionAttributeId) {
    this.samlAssertionAttributeId = samlAssertionAttributeId;
    return this;
  }

  /**
   * The ID of the SAML assertion attribute.
   *
   * @return samlAssertionAttributeId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SAML_ASSERTION_ATTRIBUTE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getSamlAssertionAttributeId() {
    return samlAssertionAttributeId;
  }

  public void setSamlAssertionAttributeId(String samlAssertionAttributeId) {
    this.samlAssertionAttributeId = samlAssertionAttributeId;
  }

  /**
   * A container for additional, undeclared properties. This is a holder for any undeclared
   * properties as specified with the 'additionalProperties' keyword in the OAS document.
   */
  private Map<String, Object> additionalProperties;

  /**
   * Set the additional (undeclared) property with the specified name and value. If the property
   * does not already exist, create it otherwise replace it.
   *
   * @param key The arbitrary key to set
   * @param value The associated value
   * @return AuthNMappingAttributes
   */
  @JsonAnySetter
  public AuthNMappingAttributes putAdditionalProperty(String key, Object value) {
    if (this.additionalProperties == null) {
      this.additionalProperties = new HashMap<String, Object>();
    }
    this.additionalProperties.put(key, value);
    return this;
  }

  /**
   * Return the additional (undeclared) property.
   *
   * @return The additional properties
   */
  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  /**
   * Return the additional (undeclared) property with the specified name.
   *
   * @param key The arbitrary key to get
   * @return The specific additional property for the given key
   */
  public Object getAdditionalProperty(String key) {
    if (this.additionalProperties == null) {
      return null;
    }
    return this.additionalProperties.get(key);
  }

  /** Return true if this AuthNMappingAttributes object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AuthNMappingAttributes authNMappingAttributes = (AuthNMappingAttributes) o;
    return Objects.equals(this.attributeKey, authNMappingAttributes.attributeKey)
        && Objects.equals(this.attributeValue, authNMappingAttributes.attributeValue)
        && Objects.equals(this.createdAt, authNMappingAttributes.createdAt)
        && Objects.equals(this.modifiedAt, authNMappingAttributes.modifiedAt)
        && Objects.equals(
            this.samlAssertionAttributeId, authNMappingAttributes.samlAssertionAttributeId)
        && Objects.equals(this.additionalProperties, authNMappingAttributes.additionalProperties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        attributeKey,
        attributeValue,
        createdAt,
        modifiedAt,
        samlAssertionAttributeId,
        additionalProperties);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AuthNMappingAttributes {\n");
    sb.append("    attributeKey: ").append(toIndentedString(attributeKey)).append("\n");
    sb.append("    attributeValue: ").append(toIndentedString(attributeValue)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    modifiedAt: ").append(toIndentedString(modifiedAt)).append("\n");
    sb.append("    samlAssertionAttributeId: ")
        .append(toIndentedString(samlAssertionAttributeId))
        .append("\n");
    sb.append("    additionalProperties: ")
        .append(toIndentedString(additionalProperties))
        .append("\n");
    sb.append('}');
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
