/*
 * Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2019-Present Datadog, Inc.
 */

package com.datadog.api.client.v2.model;

import com.datadog.api.client.ModelEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/**
 * The schema version of entity type. The field is known as schema-version in the previous version
 */
@JsonSerialize(using = EntityV3APIVersion.EntityV3APIVersionSerializer.class)
public class EntityV3APIVersion extends ModelEnum<String> {

  private static final Set<String> allowedValues = new HashSet<String>(Arrays.asList("v3"));

  public static final EntityV3APIVersion V3 = new EntityV3APIVersion("v3");

  EntityV3APIVersion(String value) {
    super(value, allowedValues);
  }

  public static class EntityV3APIVersionSerializer extends StdSerializer<EntityV3APIVersion> {
    public EntityV3APIVersionSerializer(Class<EntityV3APIVersion> t) {
      super(t);
    }

    public EntityV3APIVersionSerializer() {
      this(null);
    }

    @Override
    public void serialize(EntityV3APIVersion value, JsonGenerator jgen, SerializerProvider provider)
        throws IOException, JsonProcessingException {
      jgen.writeObject(value.value);
    }
  }

  @JsonCreator
  public static EntityV3APIVersion fromValue(String value) {
    return new EntityV3APIVersion(value);
  }
}
